/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregateFactory;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSum
implements AggregateFactory {
    private Expr expr;
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;

    public AggSum(Expr var) {
        this.expr = var;
    }

    public Aggregator create() {
        return new AggSumWorker();
    }

    class AccSumVar
    implements Accumulator {
        private NodeValue total = AggSum.access$100();

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggSum.this.expr.eval(binding, functionEnv);
                if (nv.isNumber()) {
                    this.total = this.total == noValuesToSum ? nv : XSDFuncOp.add(nv, this.total);
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return this.total;
        }
    }

    class AggSumWorker
    extends AggregatorBase {
        public String toString() {
            return "sum(" + ExprUtils.fmtSPARQL(AggSum.this.expr) + ")";
        }

        public String toPrefixString() {
            return "(sum " + WriterExpr.asString(AggSum.this.expr) + ")";
        }

        protected Accumulator createAccumulator() {
            return new AccSumVar();
        }

        private final Expr getExpr() {
            return AggSum.this.expr;
        }

        public boolean equalsAsExpr(Aggregator other) {
            if (!(other instanceof AggSumWorker)) {
                return false;
            }
            AggSumWorker agg = (AggSumWorker)other;
            return agg.getExpr().equals(this.getExpr());
        }

        public Node getValueEmpty() {
            return NodeValue.toNode(noValuesToSum);
        }
    }
}

