/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import jjtraveler.Logger;
import jjtraveler.Sequence;
import jjtraveler.TimeLogVisitor;
import jjtraveler.TopDown;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;
import jjtraveler.VisitorTestCase;
import junit.framework.Assert;

public class TimeLogVisitorTest
extends VisitorTestCase {
    public TimeLogVisitorTest(String test) {
        super(test);
    }

    public void testVisitorTiming() throws InterruptedException, VisitFailure {
        Logger l = new Logger();
        TimeLogVisitor tlv = new TimeLogVisitor(new Sleep(1), l);
        new TopDown(new Sequence(tlv, new Sleep(1))).visit(this.n0);
        System.err.println("Elapsed: " + tlv.getElapsedTime());
        System.err.println("Consumed: " + tlv.getConsumedTime());
        Assert.assertTrue((tlv.getElapsedTime() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((tlv.getConsumedTime() >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((tlv.getElapsedTime() >= tlv.getConsumedTime() ? 1 : 0) != 0);
    }

    public static class Sleep
    implements Visitor {
        int sleepTime;

        public Sleep(int i) {
            this.sleepTime = i;
        }

        public Visitable visit(Visitable x) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return x;
        }
    }
}

