/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public abstract class LuceneEntityExtractionIndexer {
    public static final String URI = "uri";
    public static final String LABEL = "label";
    public static final String PREF_LABEL = "pref_label";
    public static final String TYPE = "type";
    private Analyzer indexAnalyzer;
    private Directory directory;

    public LuceneEntityExtractionIndexer(Analyzer analyzer, Directory directory) {
        this.indexAnalyzer = analyzer;
        this.directory = directory;
    }

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void index() throws IOException {
        IndexWriter iwriter = new IndexWriter(this.directory, this.indexAnalyzer, true, IndexWriter.MaxFieldLength.LIMITED);
        this.addDocuments(iwriter);
        iwriter.optimize();
        iwriter.close();
    }

    protected abstract void addDocuments(IndexWriter var1) throws IOException;

    protected void updateDocument(String uri, String prefLabel, List<String> labels, List<String> typeURIs, IndexWriter iwriter) throws IOException {
        Document doc = new Document();
        doc.add(new Field(URI, uri, Field.Store.YES, Field.Index.NO));
        if (prefLabel != null) {
            doc.add(new Field(PREF_LABEL, prefLabel, Field.Store.YES, Field.Index.NO));
        }
        if (labels != null) {
            for (String label : labels) {
                doc.add(new Field(LABEL, label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
            }
        }
        if (typeURIs != null) {
            for (String type : typeURIs) {
                doc.add(new Field(TYPE, type, Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        iwriter.updateDocument(new Term(URI, uri), doc);
    }
}

