/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class EagleIOntUtils {
    public static List<OntClass> getClassesInGroup(OntModel jenaOntModel, String classGroupURI) {
        return EagleIOntUtils.getClassesInGroup(jenaOntModel, Arrays.asList(classGroupURI)).get(0);
    }

    public static List<List<OntClass>> getClassesInGroup(OntModel jenaOntModel, List<String> listClassGroupURI) {
        assert (listClassGroupURI != null);
        AnnotationProperty inClassGroup = jenaOntModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/inClassGroup");
        ArrayList<List<OntClass>> listClassesInGroup = new ArrayList<List<OntClass>>(listClassGroupURI.size());
        for (String uri : listClassGroupURI) {
            listClassesInGroup.add(new ArrayList());
        }
        ExtendedIterator<OntClass> exIt = jenaOntModel.listClasses();
        while (exIt.hasNext()) {
            OntClass ontClass = (OntClass)exIt.next();
            NodeIterator nodeIt = ontClass.listPropertyValues(inClassGroup);
            while (nodeIt.hasNext()) {
                RDFNode node = nodeIt.next();
                String nodeURI = node.asNode().getURI();
                for (int i = 0; i < listClassGroupURI.size(); ++i) {
                    if (!nodeURI.equals(listClassGroupURI.get(i))) continue;
                    ((List)listClassesInGroup.get(i)).add(ontClass);
                }
            }
        }
        return listClassesInGroup;
    }

    public static boolean isPropertyInGroup(OntModel jenaOntModel, String propertyGroupURI, String propertyURI) {
        assert (propertyGroupURI != null);
        assert (propertyURI != null);
        AnnotationProperty inPropertyGroup = jenaOntModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/inPropertyGroup");
        Property property = jenaOntModel.getProperty(propertyURI);
        StmtIterator stmtIt = property.listProperties(inPropertyGroup);
        while (stmtIt.hasNext()) {
            Statement stmt = (Statement)stmtIt.next();
            if (!stmt.getObject().asNode().getURI().equals(propertyGroupURI)) continue;
            return true;
        }
        return false;
    }
}

