/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eaglei.network.actions.HasSearchProvider;
import org.eaglei.network.actions.SearchProviderOp;
import org.eaglei.network.actions.Shared;
import org.eaglei.network.actions.WithSerializerQueryAction;
import org.eaglei.search.common.SerializationException;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchProvider;
import org.spin.node.QueryContext;
import org.spin.node.actions.QueryException;
import org.spin.tools.Util;

public abstract class SearchProviderQueryAction<In, Out>
extends WithSerializerQueryAction<In>
implements HasSearchProvider {
    private static final Logger log = Logger.getLogger(SearchProviderQueryAction.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private final Serializer<Out> outputSerializer;
    private final SearchProviderOp<In, Out> operation;

    SearchProviderQueryAction(Serializer<In> inputSerializer, Serializer<Out> outputSerializer, SearchProviderOp<In, Out> operation) {
        super(inputSerializer);
        Util.guardNotNull(outputSerializer);
        Util.guardNotNull(operation);
        this.outputSerializer = outputSerializer;
        this.operation = operation;
    }

    @Override
    public SearchProvider getSearchProvider() {
        return this.operation.getSearchProvider();
    }

    public String perform(QueryContext context, In request) throws QueryException {
        String jsonResults;
        Out result;
        Util.guardNotNull(request);
        if (DEBUG) {
            try {
                log.debug("Raw input JSON: '" + this.inputSerializer.serialize(request) + "'");
            }
            catch (SerializationException e2) {
                log.error("Error serializing SearchRequest to JSON for debug output", e2);
            }
        }
        try {
            Shared.initializeProviderIfNecessary();
            result = this.operation.perform(request);
        }
        catch (IOException e3) {
            throw new QueryException("Error performing SearchProvider operation: ", (Throwable)e3);
        }
        if (INFO) {
            log.info("Performed SearchProvider operation");
        }
        try {
            jsonResults = this.outputSerializer.serialize(result);
        }
        catch (SerializationException e4) {
            throw new QueryException("Error serializing results: ", (Throwable)e4);
        }
        if (DEBUG) {
            log.debug("Raw JSON results '" + jsonResults + "'");
        }
        return jsonResults;
    }
}

