/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io.manchester;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.DescriptionSorter;
import com.clarkparsia.owlapi.explanation.io.manchester.Keyword;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLStringLiteral;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTypedLiteral;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterSyntaxObjectRenderer
implements OWLObjectVisitor {
    private boolean wrapLines = true;
    private boolean smartIndent = true;
    protected BlockWriter writer;

    public ManchesterSyntaxObjectRenderer(BlockWriter writer) {
        this.writer = writer;
    }

    public boolean isSmartIndent() {
        return this.smartIndent;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void setSmartIndent(boolean smartIndent) {
        this.smartIndent = smartIndent;
    }

    public void setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
    }

    protected String shortForm(IRI theIRI) {
        String fragment = theIRI.getFragment();
        if (fragment != null) {
            return fragment;
        }
        String str2 = theIRI.toString();
        int lastSlashIndex = str2.lastIndexOf(47);
        if (lastSlashIndex != -1) {
            return str2.substring(lastSlashIndex + 1, str2.length());
        }
        return str2;
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.ASYMMETRIC_PROPERTY);
    }

    public void visit(OWLClass theOWLClass) {
        this.write(theOWLClass.getIRI());
    }

    public void visit(OWLClassAssertionAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.TYPE, (OWLObject)theAxiom.getIndividual(), (OWLObject)theAxiom.getClassExpression());
    }

    public void visit(OWLAnnotation theAnnotation) {
        this.write(Keyword.ANNOTATION);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAnnotation.getProperty());
        this.write(" ");
        this.write((OWLObject)theAnnotation.getValue());
        this.write(")");
    }

    public void visit(OWLDataAllValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLDataComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getDataRange());
    }

    public void visit(OWLDataExactCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLDataMaxCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLDataMinCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLDataOneOf theDescription) {
        this.writeEnumeration(theDescription.getValues());
    }

    public void visit(OWLDataProperty theProperty) {
        this.write(theProperty.getIRI());
    }

    public void visit(OWLDataPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
    }

    public void visit(OWLDataPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getDomain());
    }

    public void visit(OWLDataPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getRange());
    }

    public void visit(OWLFacetRestriction theRestriction) {
        this.write(theRestriction.getFacet().getSymbolicForm());
        this.writeSpace();
        this.write((OWLObject)theRestriction.getFacetValue());
    }

    public void visit(OWLDatatypeRestriction theRestriction) {
        this.write((OWLObject)theRestriction.getDatatype());
        this.write("[");
        boolean first = true;
        for (OWLFacetRestriction restriction : theRestriction.getFacetRestrictions()) {
            if (first) {
                first = false;
            } else {
                this.write(",");
                this.writeSpace();
            }
            this.write((OWLObject)restriction);
        }
        this.write("]");
    }

    public void visit(OWLDataSomeValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLSubDataPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLDatatype node) {
        this.write(node.getIRI());
    }

    public void visit(OWLDataHasValue theDescription) {
        this.writeRestriction(theDescription.getProperty(), Keyword.VALUE, theDescription.getValue());
    }

    public void visit(OWLDeclarationAxiom theAxiom) {
        this.writeKeywordPrefix(Keyword.DECLARATION, (OWLObject)theAxiom.getEntity());
    }

    public void visit(OWLDifferentIndividualsAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getIndividuals(), Keyword.DIFFERENT_INDIVIDUAL, Keyword.DIFFERENT_INDIVIDUALS);
    }

    public void visit(OWLDisjointClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getClassExpressions(), Keyword.DISJOINT_CLASS, Keyword.DISJOINT_CLASSES);
    }

    public void visit(OWLDisjointDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointUnionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getOWLClass());
        this.writeSpace();
        this.write(Keyword.DISJOINT_UNION);
        this.writeSpace();
        this.writeNaryKeyword(Keyword.OR, theAxiom.getClassExpressions());
    }

    public void visit(OWLEquivalentClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getClassExpressions(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_CLASSES);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.EQUIVALENT_TO, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLFunctionalDataPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLAnonymousIndividual theIndividual) {
        this.write(theIndividual.getID().getID());
    }

    public void visit(OWLNamedIndividual theIndividual) {
        this.write(theIndividual.getIRI());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.INVERSE_FUNCTIONAL);
    }

    public void visit(OWLInverseObjectPropertiesAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.INVERSE_OF, (OWLObject)theAxiom.getFirstProperty(), (OWLObject)theAxiom.getSecondProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.IRREFLEXIVE);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLObjectAllValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLObjectComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getOperand());
    }

    public void visit(OWLObjectExactCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLObjectIntersectionOf theDescription) {
        this.writeNaryKeyword(Keyword.AND, theDescription.getOperands());
    }

    public void visit(OWLObjectMaxCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLObjectMinCardinality theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLObjectOneOf theDescription) {
        this.writeEnumeration(theDescription.getIndividuals());
    }

    public void visit(OWLObjectProperty theProperty) {
        this.write(theProperty.getIRI());
    }

    public void visit(OWLObjectPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getObject());
    }

    public void visit(OWLSubPropertyChainOfAxiom theAxiom) {
        this.writeCollection(theAxiom.getPropertyChain(), "o", false);
        this.writeSpace();
        this.write(Keyword.SUB_PROPERTY_OF);
        this.writeSpace();
        this.write((OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getDomain());
    }

    public void visit(OWLObjectInverseOf theInverse) {
        this.writeKeywordPrefix(Keyword.INVERSE, (OWLObject)theInverse.getInverse());
    }

    public void visit(OWLObjectPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getRange());
    }

    public void visit(OWLObjectHasSelf theRestriction) {
        this.writeRestriction(theRestriction.getProperty(), Keyword.SELF, new Object[0]);
    }

    public void visit(OWLObjectSomeValuesFrom theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLSubObjectPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectUnionOf theDescription) {
        this.writeNaryKeyword(Keyword.OR, theDescription.getOperands());
    }

    public void visit(OWLObjectHasValue theDescription) {
        this.writeRestriction(theDescription.getProperty(), Keyword.VALUE, theDescription.getValue());
    }

    public void visit(OWLOntology ontology) {
        this.write(ontology.getOntologyID().getOntologyIRI());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.REFLEXIVE_PROPERTY);
    }

    public void visit(OWLSameIndividualAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getIndividuals(), Keyword.SAME_INDIVIDUAL, Keyword.SAME_INDIVIDUALS);
    }

    public void visit(OWLSubClassOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_CLASS_OF, (OWLObject)theAxiom.getSubClass(), (OWLObject)theAxiom.getSuperClass());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.SYMMETRIC);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.TRANSITIVE);
    }

    public void visit(OWLTypedLiteral node) {
        if (node.getDatatype().getIRI().equals(XSDVocabulary.INTEGER.getIRI()) || node.getDatatype().getIRI().equals(XSDVocabulary.DECIMAL.getIRI())) {
            this.write(node.getLiteral());
        } else if (node.getDatatype().getIRI().equals(XSDVocabulary.FLOAT.getIRI())) {
            this.write(node.getLiteral());
            this.write("f");
        } else {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
            this.write("^^");
            this.write((OWLObject)node.getDatatype());
        }
    }

    public void visit(OWLStringLiteral node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"");
        if (node.getLang() != null) {
            this.write("@");
            this.write(node.getLang());
        }
    }

    public void visit(SWRLLiteralArgument node) {
        this.write((OWLObject)node.getLiteral());
    }

    public void visit(SWRLIndividualArgument node) {
        this.write((OWLObject)node.getIndividual());
    }

    public void visit(SWRLVariable node) {
        this.write("?");
        this.write(node.getIRI());
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(node.getPredicate());
        this.write("(");
        for (SWRLDArgument arg : node.getArguments()) {
            this.write((OWLObject)arg);
            this.write(" ");
        }
        this.write(")");
    }

    public void visit(SWRLClassAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataRangeAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.write("differentFrom");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLRule rule) {
        this.write("Rule");
        this.write("(");
        boolean first = true;
        for (SWRLAtom at : rule.getBody()) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(" -> ");
        first = true;
        for (SWRLAtom at : rule.getHead()) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(")");
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.write("sameAs");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    protected void writeNaryKeyword(Keyword theKeyword, Set<? extends OWLObject> theObjects) {
        theObjects = DescriptionSorter.toSortedSet(theObjects);
        Iterator<? extends OWLObject> aIter = theObjects.iterator();
        if (this.smartIndent) {
            this.writer.startBlock();
        }
        this.write(aIter.next());
        while (aIter.hasNext()) {
            if (this.wrapLines) {
                this.writeNewLine();
            } else {
                this.writeSpace();
            }
            if (theKeyword != null) {
                this.write(theKeyword);
                this.writeSpace();
            }
            this.write(aIter.next());
        }
        if (this.smartIndent) {
            this.writer.endBlock();
        }
    }

    protected void writeCardinalityRestriction(OWLCardinalityRestriction<?, ?> theRestriction, Keyword theKeyword) {
        if (theRestriction.isQualified()) {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality(), theRestriction.getFiller());
        } else {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality());
        }
    }

    protected void writeNaryAxiom(Set<? extends OWLObject> set, Keyword binary, Keyword nary) {
        Set<? extends OWLObject> sortedSet = DescriptionSorter.toSortedSet(set);
        Iterator<? extends OWLObject> aIter = sortedSet.iterator();
        if (set.size() == 2) {
            this.writeKeywordInfix(binary, aIter.next(), aIter.next());
        } else {
            this.write(nary);
            this.write("(");
            this.writeNaryKeyword(null, set);
            this.write(")");
        }
    }

    protected void writeQuantifiedRestriction(OWLQuantifiedRestriction<?, ?> theRestriction, Keyword theKeyword) {
        this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getFiller());
    }

    protected void writeRestriction(OWLPropertyExpression<?, ?> theProperty, Keyword theKeyword, Object ... theArgs) {
        this.write((OWLObject)theProperty);
        this.writeSpace();
        this.write(theKeyword);
        for (Object aObject : theArgs) {
            this.writeSpace();
            if (aObject instanceof OWLObject) {
                this.write((OWLObject)aObject);
                continue;
            }
            this.write(aObject.toString());
        }
    }

    protected void writeUnaryPropertyAxiom(OWLUnaryPropertyAxiom<?> theAxiom, Keyword keyword) {
        this.writeKeywordPrefix(keyword, (OWLObject)theAxiom.getProperty());
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg) {
        this.write(keyword);
        this.writeSpace();
        this.write(arg);
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(keyword);
        this.writeSpace();
        this.write("(");
        this.write(arg1);
        this.writeSpace();
        this.write(arg2);
        this.write(")");
    }

    protected void writeKeywordInfix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(arg1);
        this.writeSpace();
        this.write(keyword);
        this.writeSpace();
        this.write(arg2);
    }

    protected void writeEnumeration(Set<? extends OWLObject> objects) {
        this.write(Keyword.OPEN_BRACE);
        this.writeCollection(objects, ",", true);
        this.write(Keyword.CLOSE_BRACE);
    }

    protected void writeCollection(Collection<? extends OWLObject> objects, String separator, boolean sort) {
        if (sort) {
            objects = DescriptionSorter.toSortedSet(objects);
        }
        boolean first = true;
        for (OWLObject oWLObject : objects) {
            if (first) {
                first = false;
            } else {
                this.write(separator);
                this.writeSpace();
            }
            this.write(oWLObject);
        }
    }

    protected void write(OWLObject object) {
        object.accept((OWLObjectVisitor)this);
    }

    protected void write(Keyword keyword) {
        this.write(keyword.getLabel());
    }

    protected void write(String s) {
        this.writer.print(s);
    }

    protected void write(IRI iri) {
        this.write(this.shortForm(iri));
    }

    protected void writeNewLine() {
        this.writer.println();
    }

    protected void writeSpace() {
        this.write(" ");
    }

    public void visit(OWLHasKeyAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getClassExpression());
        this.writeSpace();
        this.write(Keyword.HAS_KEY);
        if (!theAxiom.getObjectPropertyExpressions().isEmpty()) {
            this.writeCollection(theAxiom.getObjectPropertyExpressions(), "", true);
            this.writeSpace();
        }
        this.writeCollection(theAxiom.getDataPropertyExpressions(), "", true);
    }

    public void visit(OWLDatatypeDefinitionAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.EQUIVALENT_TO, (OWLObject)theAxiom.getDatatype(), (OWLObject)theAxiom.getDataRange());
    }

    public void visit(OWLAnnotationAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getValue());
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLAnnotationPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getDomain());
    }

    public void visit(OWLAnnotationPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getRange());
    }

    public void visit(OWLDataIntersectionOf node) {
        this.writeNaryKeyword(Keyword.AND, node.getOperands());
    }

    public void visit(OWLDataUnionOf node) {
        this.writeNaryKeyword(Keyword.OR, node.getOperands());
    }

    public void visit(OWLAnnotationProperty property) {
        this.write(property.getIRI());
    }

    public void visit(IRI iri) {
        this.write(iri);
    }
}

