/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.DiscreteInterval;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerInterval
extends DiscreteInterval<Number, IntegerInterval> {
    private static final IntegerInterval unconstrained = new IntegerInterval(null, null);

    public static IntegerInterval allIntegers() {
        return unconstrained;
    }

    public IntegerInterval(Number point) {
        super(point);
    }

    public IntegerInterval(Number lower, Number upper) {
        super(lower, upper);
    }

    @Override
    protected IntegerInterval cast(DiscreteInterval<Number, IntegerInterval> i) {
        if (IntegerInterval.class.isInstance(i)) {
            return (IntegerInterval)IntegerInterval.class.cast(i);
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected int compare(Number a, DiscreteInterval.NullSemantics na, Number b, DiscreteInterval.NullSemantics nb) {
        if (a == null && NA.equals((Object)na)) {
            throw new NullPointerException();
        }
        if (b == null && NA.equals((Object)nb)) {
            throw new NullPointerException();
        }
        if (a == null) {
            if (b == null) {
                if (na.equals((Object)nb)) {
                    return 0;
                }
                if (LEAST.equals((Object)na)) {
                    return -1;
                }
                return 1;
            }
            if (LEAST.equals((Object)na)) {
                return -1;
            }
            return 1;
        }
        if (b == null) {
            if (GREATEST.equals((Object)nb)) {
                return -1;
            }
            return 1;
        }
        return OWLRealUtils.compare(a, b);
    }

    @Override
    protected IntegerInterval create(Number lower, Number upper) {
        return new IntegerInterval(lower, upper);
    }

    @Override
    protected Number decrement(Number t) {
        return OWLRealUtils.integerDecrement(t);
    }

    @Override
    protected boolean equal(Number a, Number b) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        return OWLRealUtils.compare(a, b) == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerInterval other = (IntegerInterval)obj;
        if (this.getLower() == null) {
            if (other.getLower() != null) {
                return false;
            }
        } else {
            if (other.getLower() == null) {
                return false;
            }
            if (OWLRealUtils.compare(this.getLower(), other.getLower()) != 0) {
                return false;
            }
        }
        if (this.getUpper() == null) {
            if (other.getUpper() != null) {
                return false;
            }
        } else {
            if (other.getUpper() == null) {
                return false;
            }
            if (OWLRealUtils.compare(this.getUpper(), other.getUpper()) != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Number increment(Number n) {
        return OWLRealUtils.integerIncrement(n);
    }

    @Override
    public Number size() {
        if (this.getLower() == null || this.getUpper() == null) {
            throw new IllegalStateException();
        }
        return OWLRealUtils.integerIncrement(OWLRealUtils.integerDifference(this.getUpper(), this.getLower()));
    }

    @Override
    protected boolean valid(Number n) {
        if (n == null) {
            return true;
        }
        return OWLRealUtils.acceptable(n.getClass()) && OWLRealUtils.isInteger(n);
    }
}

