/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import java.util.ArrayList;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class EntailmentQueryVisitor
extends OWLAxiomVisitorAdapter {
    private IndividualTermConverter indConv;
    private PelletReasoner reasoner;
    private Query query;

    public EntailmentQueryVisitor(PelletReasoner reasoner) {
        this.reasoner = reasoner;
        this.indConv = new IndividualTermConverter();
        this.reset();
    }

    public boolean isEntailed() {
        QueryResult results = QueryEngine.exec(this.query);
        return !results.isEmpty();
    }

    public void reset() {
        this.query = new QueryImpl(this.reasoner.getKB(), false);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        ATermAppl ind = this.indConv.getTerm(axiom.getIndividual());
        ATermAppl cls = this.reasoner.term((OWLObject)axiom.getClassExpression());
        this.query.add(QueryAtomFactory.TypeAtom(ind, cls));
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ATermAppl subj = this.indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this.reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this.reasoner.term((OWLObject)axiom.getObject());
        this.query.add(QueryAtomFactory.PropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        ArrayList differents = new ArrayList();
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ATermAppl term = this.indConv.getTerm(ind);
            for (ATermAppl dterm : differents) {
                this.query.add(QueryAtomFactory.DifferentFromAtom(term, dterm));
            }
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ATermAppl subj = this.indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this.reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this.reasoner.term((OWLObject)axiom.getObject());
        this.query.add(QueryAtomFactory.NegativePropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ATermAppl subj = this.indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this.reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this.indConv.getTerm((OWLIndividual)axiom.getObject());
        this.query.add(QueryAtomFactory.NegativePropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ATermAppl subj = this.indConv.getTerm(axiom.getSubject());
        ATermAppl pred = this.reasoner.term((OWLObject)axiom.getProperty());
        ATermAppl obj = this.indConv.getTerm((OWLIndividual)axiom.getObject());
        this.query.add(QueryAtomFactory.PropertyValueAtom(subj, pred, obj));
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        ATermAppl head = null;
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ATermAppl term = this.indConv.getTerm(ind);
            if (head == null) {
                head = term;
                continue;
            }
            this.query.add(QueryAtomFactory.SameAsAtom(head, term));
        }
    }

    private class IndividualTermConverter
    implements OWLIndividualVisitor {
        private ATermAppl term;

        private IndividualTermConverter() {
        }

        public ATermAppl getTerm(OWLIndividual individual) {
            this.term = null;
            individual.accept((OWLIndividualVisitor)this);
            return this.term;
        }

        public void visit(OWLNamedIndividual individual) {
            this.term = EntailmentQueryVisitor.this.reasoner.term((OWLObject)individual);
        }

        public void visit(OWLAnonymousIndividual individual) {
            this.term = ATermUtils.makeVar(individual.toStringID());
        }
    }
}

