/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializationContextDefault;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonDeserializerExceptionWrapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.ObjectConstructor;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeInfoCollection;
import com.google.gson.TypeInfoMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultTypeAdapters {
    private static final DefaultDateTypeAdapter DATE_TYPE_ADAPTER = new DefaultDateTypeAdapter();
    private static final EnumTypeAdapter ENUM_TYPE_ADAPTER = new EnumTypeAdapter();
    private static final UrlTypeAdapter URL_TYPE_ADAPTER = new UrlTypeAdapter();
    private static final UriTypeAdapter URI_TYPE_ADAPTER = new UriTypeAdapter();
    private static final UuidTypeAdapter UUUID_TYPE_ADAPTER = new UuidTypeAdapter();
    private static final LocaleTypeAdapter LOCALE_TYPE_ADAPTER = new LocaleTypeAdapter();
    private static final CollectionTypeAdapter COLLECTION_TYPE_ADAPTER = new CollectionTypeAdapter();
    private static final MapTypeAdapter MAP_TYPE_ADAPTER = new MapTypeAdapter();
    private static final BigDecimalTypeAdapter BIG_DECIMAL_TYPE_ADAPTER = new BigDecimalTypeAdapter();
    private static final BigIntegerTypeAdapter BIG_INTEGER_TYPE_ADAPTER = new BigIntegerTypeAdapter();
    private static final BooleanTypeAdapter BOOLEAN_TYPE_ADAPTER = new BooleanTypeAdapter();
    private static final ByteTypeAdapter BYTE_TYPE_ADAPTER = new ByteTypeAdapter();
    private static final CharacterTypeAdapter CHARACTER_TYPE_ADAPTER = new CharacterTypeAdapter();
    private static final DoubleDeserializer DOUBLE_TYPE_ADAPTER = new DoubleDeserializer();
    private static final FloatDeserializer FLOAT_TYPE_ADAPTER = new FloatDeserializer();
    private static final IntegerTypeAdapter INTEGER_TYPE_ADAPTER = new IntegerTypeAdapter();
    private static final LongDeserializer LONG_DESERIALIZER = new LongDeserializer();
    private static final NumberTypeAdapter NUMBER_TYPE_ADAPTER = new NumberTypeAdapter();
    private static final ShortTypeAdapter SHORT_TYPE_ADAPTER = new ShortTypeAdapter();
    private static final StringTypeAdapter STRING_TYPE_ADAPTER = new StringTypeAdapter();
    private static final PropertiesCreator PROPERTIES_CREATOR = new PropertiesCreator();
    private static final TreeSetCreator TREE_SET_CREATOR = new TreeSetCreator();
    private static final HashSetCreator HASH_SET_CREATOR = new HashSetCreator();
    private static final GregorianCalendarTypeAdapter GREGORIAN_CALENDAR_TYPE_ADAPTER = new GregorianCalendarTypeAdapter();
    private static final ParameterizedTypeHandlerMap<JsonSerializer<?>> DEFAULT_SERIALIZERS = DefaultTypeAdapters.createDefaultSerializers();
    private static final ParameterizedTypeHandlerMap<JsonDeserializer<?>> DEFAULT_DESERIALIZERS = DefaultTypeAdapters.createDefaultDeserializers();
    private static final ParameterizedTypeHandlerMap<InstanceCreator<?>> DEFAULT_INSTANCE_CREATORS = DefaultTypeAdapters.createDefaultInstanceCreators();

    DefaultTypeAdapters() {
    }

    private static ParameterizedTypeHandlerMap<JsonSerializer<?>> createDefaultSerializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), ENUM_TYPE_ADAPTER);
        map.register((Type)((Object)URL.class), URL_TYPE_ADAPTER);
        map.register((Type)((Object)URI.class), URI_TYPE_ADAPTER);
        map.register((Type)((Object)UUID.class), UUUID_TYPE_ADAPTER);
        map.register((Type)((Object)Locale.class), LOCALE_TYPE_ADAPTER);
        map.register((Type)((Object)Collection.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)Map.class), MAP_TYPE_ADAPTER);
        map.register((Type)((Object)Date.class), DATE_TYPE_ADAPTER);
        map.register((Type)((Object)Calendar.class), GREGORIAN_CALENDAR_TYPE_ADAPTER);
        map.register((Type)((Object)GregorianCalendar.class), GREGORIAN_CALENDAR_TYPE_ADAPTER);
        map.register((Type)((Object)BigDecimal.class), BIG_DECIMAL_TYPE_ADAPTER);
        map.register((Type)((Object)BigInteger.class), BIG_INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Boolean.class), BOOLEAN_TYPE_ADAPTER);
        map.register(Boolean.TYPE, BOOLEAN_TYPE_ADAPTER);
        map.register((Type)((Object)Byte.class), BYTE_TYPE_ADAPTER);
        map.register(Byte.TYPE, BYTE_TYPE_ADAPTER);
        map.register((Type)((Object)Character.class), CHARACTER_TYPE_ADAPTER);
        map.register(Character.TYPE, CHARACTER_TYPE_ADAPTER);
        map.register((Type)((Object)Integer.class), INTEGER_TYPE_ADAPTER);
        map.register(Integer.TYPE, INTEGER_TYPE_ADAPTER);
        map.register((Type)((Object)Number.class), NUMBER_TYPE_ADAPTER);
        map.register((Type)((Object)Short.class), SHORT_TYPE_ADAPTER);
        map.register(Short.TYPE, SHORT_TYPE_ADAPTER);
        map.register((Type)((Object)String.class), STRING_TYPE_ADAPTER);
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<JsonDeserializer<?>> createDefaultDeserializers() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Enum.class), DefaultTypeAdapters.wrapDeserializer(ENUM_TYPE_ADAPTER));
        map.register((Type)((Object)URL.class), DefaultTypeAdapters.wrapDeserializer(URL_TYPE_ADAPTER));
        map.register((Type)((Object)URI.class), DefaultTypeAdapters.wrapDeserializer(URI_TYPE_ADAPTER));
        map.register((Type)((Object)UUID.class), DefaultTypeAdapters.wrapDeserializer(UUUID_TYPE_ADAPTER));
        map.register((Type)((Object)Locale.class), DefaultTypeAdapters.wrapDeserializer(LOCALE_TYPE_ADAPTER));
        map.register((Type)((Object)Collection.class), DefaultTypeAdapters.wrapDeserializer(COLLECTION_TYPE_ADAPTER));
        map.register((Type)((Object)Map.class), DefaultTypeAdapters.wrapDeserializer(MAP_TYPE_ADAPTER));
        map.register((Type)((Object)Date.class), DefaultTypeAdapters.wrapDeserializer(DATE_TYPE_ADAPTER));
        map.register((Type)((Object)Calendar.class), GREGORIAN_CALENDAR_TYPE_ADAPTER);
        map.register((Type)((Object)GregorianCalendar.class), GREGORIAN_CALENDAR_TYPE_ADAPTER);
        map.register((Type)((Object)BigDecimal.class), DefaultTypeAdapters.wrapDeserializer(BIG_DECIMAL_TYPE_ADAPTER));
        map.register((Type)((Object)BigInteger.class), DefaultTypeAdapters.wrapDeserializer(BIG_INTEGER_TYPE_ADAPTER));
        map.register((Type)((Object)Boolean.class), DefaultTypeAdapters.wrapDeserializer(BOOLEAN_TYPE_ADAPTER));
        map.register(Boolean.TYPE, DefaultTypeAdapters.wrapDeserializer(BOOLEAN_TYPE_ADAPTER));
        map.register((Type)((Object)Byte.class), DefaultTypeAdapters.wrapDeserializer(BYTE_TYPE_ADAPTER));
        map.register(Byte.TYPE, DefaultTypeAdapters.wrapDeserializer(BYTE_TYPE_ADAPTER));
        map.register((Type)((Object)Character.class), DefaultTypeAdapters.wrapDeserializer(CHARACTER_TYPE_ADAPTER));
        map.register(Character.TYPE, DefaultTypeAdapters.wrapDeserializer(CHARACTER_TYPE_ADAPTER));
        map.register((Type)((Object)Double.class), DefaultTypeAdapters.wrapDeserializer(DOUBLE_TYPE_ADAPTER));
        map.register(Double.TYPE, DefaultTypeAdapters.wrapDeserializer(DOUBLE_TYPE_ADAPTER));
        map.register((Type)((Object)Float.class), DefaultTypeAdapters.wrapDeserializer(FLOAT_TYPE_ADAPTER));
        map.register(Float.TYPE, DefaultTypeAdapters.wrapDeserializer(FLOAT_TYPE_ADAPTER));
        map.register((Type)((Object)Integer.class), DefaultTypeAdapters.wrapDeserializer(INTEGER_TYPE_ADAPTER));
        map.register(Integer.TYPE, DefaultTypeAdapters.wrapDeserializer(INTEGER_TYPE_ADAPTER));
        map.register((Type)((Object)Long.class), DefaultTypeAdapters.wrapDeserializer(LONG_DESERIALIZER));
        map.register(Long.TYPE, DefaultTypeAdapters.wrapDeserializer(LONG_DESERIALIZER));
        map.register((Type)((Object)Number.class), DefaultTypeAdapters.wrapDeserializer(NUMBER_TYPE_ADAPTER));
        map.register((Type)((Object)Short.class), DefaultTypeAdapters.wrapDeserializer(SHORT_TYPE_ADAPTER));
        map.register(Short.TYPE, DefaultTypeAdapters.wrapDeserializer(SHORT_TYPE_ADAPTER));
        map.register((Type)((Object)String.class), DefaultTypeAdapters.wrapDeserializer(STRING_TYPE_ADAPTER));
        map.makeUnmodifiable();
        return map;
    }

    private static ParameterizedTypeHandlerMap<InstanceCreator<?>> createDefaultInstanceCreators() {
        ParameterizedTypeHandlerMap map = new ParameterizedTypeHandlerMap();
        map.register((Type)((Object)Map.class), MAP_TYPE_ADAPTER);
        map.register((Type)((Object)Collection.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)List.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)Queue.class), COLLECTION_TYPE_ADAPTER);
        map.register((Type)((Object)Set.class), HASH_SET_CREATOR);
        map.register((Type)((Object)SortedSet.class), TREE_SET_CREATOR);
        map.register((Type)((Object)Properties.class), PROPERTIES_CREATOR);
        map.makeUnmodifiable();
        return map;
    }

    private static JsonDeserializer<?> wrapDeserializer(JsonDeserializer<?> deserializer) {
        return new JsonDeserializerExceptionWrapper(deserializer);
    }

    static ParameterizedTypeHandlerMap<JsonSerializer<?>> getDefaultSerializers() {
        return DefaultTypeAdapters.getDefaultSerializers(false, LongSerializationPolicy.DEFAULT);
    }

    static ParameterizedTypeHandlerMap<JsonSerializer<?>> getDefaultSerializers(boolean serializeSpecialFloatingPointValues, LongSerializationPolicy longSerializationPolicy) {
        ParameterizedTypeHandlerMap serializers = new ParameterizedTypeHandlerMap();
        DoubleSerializer doubleSerializer = new DoubleSerializer(serializeSpecialFloatingPointValues);
        serializers.registerIfAbsent((Type)((Object)Double.class), doubleSerializer);
        serializers.registerIfAbsent(Double.TYPE, doubleSerializer);
        FloatSerializer floatSerializer = new FloatSerializer(serializeSpecialFloatingPointValues);
        serializers.registerIfAbsent((Type)((Object)Float.class), floatSerializer);
        serializers.registerIfAbsent(Float.TYPE, floatSerializer);
        LongSerializer longSerializer = new LongSerializer(longSerializationPolicy);
        serializers.registerIfAbsent((Type)((Object)Long.class), longSerializer);
        serializers.registerIfAbsent(Long.TYPE, longSerializer);
        serializers.registerIfAbsent(DEFAULT_SERIALIZERS);
        return serializers;
    }

    static ParameterizedTypeHandlerMap<JsonDeserializer<?>> getDefaultDeserializers() {
        return DEFAULT_DESERIALIZERS;
    }

    static ParameterizedTypeHandlerMap<InstanceCreator<?>> getDefaultInstanceCreators() {
        return DEFAULT_INSTANCE_CREATORS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashSetCreator
    implements InstanceCreator<HashSet<?>> {
        private HashSetCreator() {
        }

        @Override
        public HashSet<?> createInstance(Type type) {
            return new HashSet();
        }

        public String toString() {
            return HashSetCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeSetCreator
    implements InstanceCreator<TreeSet<?>> {
        private TreeSetCreator() {
        }

        @Override
        public TreeSet<?> createInstance(Type type) {
            return new TreeSet();
        }

        public String toString() {
            return TreeSetCreator.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanTypeAdapter
    implements JsonSerializer<Boolean>,
    JsonDeserializer<Boolean> {
        private BooleanTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Boolean src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Boolean deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBoolean();
        }

        public String toString() {
            return BooleanTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringTypeAdapter
    implements JsonSerializer<String>,
    JsonDeserializer<String> {
        private StringTypeAdapter() {
        }

        @Override
        public JsonElement serialize(String src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsString();
        }

        public String toString() {
            return StringTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterTypeAdapter
    implements JsonSerializer<Character>,
    JsonDeserializer<Character> {
        private CharacterTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Character src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Character deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Character.valueOf(json.getAsCharacter());
        }

        public String toString() {
            return CharacterTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleDeserializer
    implements JsonDeserializer<Double> {
        private DoubleDeserializer() {
        }

        @Override
        public Double deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsDouble();
        }

        public String toString() {
            return DoubleDeserializer.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleSerializer
    implements JsonSerializer<Double> {
        private final boolean serializeSpecialFloatingPointValues;

        DoubleSerializer(boolean serializeSpecialDoubleValues) {
            this.serializeSpecialFloatingPointValues = serializeSpecialDoubleValues;
        }

        @Override
        public JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
            if (!this.serializeSpecialFloatingPointValues && (Double.isNaN(src) || Double.isInfinite(src))) {
                throw new IllegalArgumentException(src + " is not a valid double value as per JSON specification. To override this" + " behavior, use GsonBuilder.serializeSpecialDoubleValues() method.");
            }
            return new JsonPrimitive(src);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatDeserializer
    implements JsonDeserializer<Float> {
        private FloatDeserializer() {
        }

        @Override
        public Float deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Float.valueOf(json.getAsFloat());
        }

        public String toString() {
            return FloatDeserializer.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatSerializer
    implements JsonSerializer<Float> {
        private final boolean serializeSpecialFloatingPointValues;

        FloatSerializer(boolean serializeSpecialDoubleValues) {
            this.serializeSpecialFloatingPointValues = serializeSpecialDoubleValues;
        }

        @Override
        public JsonElement serialize(Float src, Type typeOfSrc, JsonSerializationContext context) {
            if (!this.serializeSpecialFloatingPointValues && (Float.isNaN(src.floatValue()) || Float.isInfinite(src.floatValue()))) {
                throw new IllegalArgumentException(src + " is not a valid float value as per JSON specification. To override this" + " behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
            }
            return new JsonPrimitive(src);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteTypeAdapter
    implements JsonSerializer<Byte>,
    JsonDeserializer<Byte> {
        private ByteTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Byte src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Byte deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsByte();
        }

        public String toString() {
            return ByteTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortTypeAdapter
    implements JsonSerializer<Short>,
    JsonDeserializer<Short> {
        private ShortTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Short src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Short deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsShort();
        }

        public String toString() {
            return ShortTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerTypeAdapter
    implements JsonSerializer<Integer>,
    JsonDeserializer<Integer> {
        private IntegerTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Integer src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Integer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsInt();
        }

        public String toString() {
            return IntegerTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongDeserializer
    implements JsonDeserializer<Long> {
        private LongDeserializer() {
        }

        @Override
        public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsLong();
        }

        public String toString() {
            return LongDeserializer.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    implements JsonSerializer<Long> {
        private final LongSerializationPolicy longSerializationPolicy;

        private LongSerializer(LongSerializationPolicy longSerializationPolicy) {
            this.longSerializationPolicy = longSerializationPolicy;
        }

        @Override
        public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
            return this.longSerializationPolicy.serialize(src);
        }

        public String toString() {
            return LongSerializer.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberTypeAdapter
    implements JsonSerializer<Number>,
    JsonDeserializer<Number> {
        private NumberTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Number src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public Number deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsNumber();
        }

        public String toString() {
            return NumberTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigIntegerTypeAdapter
    implements JsonSerializer<BigInteger>,
    JsonDeserializer<BigInteger> {
        private BigIntegerTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigInteger src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigInteger deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigInteger();
        }

        public String toString() {
            return BigIntegerTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigDecimalTypeAdapter
    implements JsonSerializer<BigDecimal>,
    JsonDeserializer<BigDecimal> {
        private BigDecimalTypeAdapter() {
        }

        @Override
        public JsonElement serialize(BigDecimal src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src);
        }

        @Override
        public BigDecimal deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.getAsBigDecimal();
        }

        public String toString() {
            return BigDecimalTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapTypeAdapter
    implements JsonSerializer<Map>,
    JsonDeserializer<Map>,
    InstanceCreator<Map> {
        MapTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Map src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject map = new JsonObject();
            Class<?> childGenericType = null;
            if (typeOfSrc instanceof ParameterizedType) {
                childGenericType = new TypeInfoMap(typeOfSrc).getValueType();
            }
            for (Map.Entry entry : src.entrySet()) {
                JsonElement valueElement;
                Object value = entry.getValue();
                if (value == null) {
                    valueElement = JsonNull.createJsonNull();
                } else {
                    Class<?> childType = childGenericType == null ? value.getClass() : childGenericType;
                    valueElement = context.serialize(value, childType);
                }
                map.add(String.valueOf(entry.getKey()), valueElement);
            }
            return map;
        }

        @Override
        public Map deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Map map = this.constructMapType(typeOfT, context);
            TypeInfoMap mapTypeInfo = new TypeInfoMap(typeOfT);
            for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                Object key = context.deserialize(new JsonPrimitive(entry.getKey()), mapTypeInfo.getKeyType());
                Object value = context.deserialize(entry.getValue(), mapTypeInfo.getValueType());
                map.put(key, value);
            }
            return map;
        }

        private Map constructMapType(Type mapType, JsonDeserializationContext context) {
            JsonDeserializationContextDefault contextImpl = (JsonDeserializationContextDefault)context;
            ObjectConstructor objectConstructor = contextImpl.getObjectConstructor();
            return (Map)objectConstructor.construct(mapType);
        }

        @Override
        public Map createInstance(Type type) {
            return new LinkedHashMap();
        }

        public String toString() {
            return MapTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertiesCreator
    implements InstanceCreator<Properties> {
        private PropertiesCreator() {
        }

        @Override
        public Properties createInstance(Type type) {
            return new Properties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionTypeAdapter
    implements JsonSerializer<Collection>,
    JsonDeserializer<Collection>,
    InstanceCreator<Collection> {
        private CollectionTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Collection src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return JsonNull.createJsonNull();
            }
            JsonArray array = new JsonArray();
            Type childGenericType = null;
            if (typeOfSrc instanceof ParameterizedType) {
                childGenericType = new TypeInfoCollection(typeOfSrc).getElementType();
            }
            for (Object child : src) {
                if (child == null) {
                    array.add(JsonNull.createJsonNull());
                    continue;
                }
                Type childType = childGenericType == null || childGenericType == Object.class ? child.getClass() : childGenericType;
                JsonElement element = context.serialize(child, childType);
                array.add(element);
            }
            return array;
        }

        @Override
        public Collection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            Collection collection = this.constructCollectionType(typeOfT, context);
            Type childType = new TypeInfoCollection(typeOfT).getElementType();
            for (JsonElement childElement : json.getAsJsonArray()) {
                if (childElement == null || childElement.isJsonNull()) {
                    collection.add(null);
                    continue;
                }
                Object value = context.deserialize(childElement, childType);
                collection.add(value);
            }
            return collection;
        }

        private Collection constructCollectionType(Type collectionType, JsonDeserializationContext context) {
            JsonDeserializationContextDefault contextImpl = (JsonDeserializationContextDefault)context;
            ObjectConstructor objectConstructor = contextImpl.getObjectConstructor();
            return (Collection)objectConstructor.construct(collectionType);
        }

        @Override
        public Collection createInstance(Type type) {
            return new LinkedList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleTypeAdapter
    implements JsonSerializer<Locale>,
    JsonDeserializer<Locale> {
        private LocaleTypeAdapter() {
        }

        @Override
        public JsonElement serialize(Locale src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        public Locale deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String locale = json.getAsString();
            StringTokenizer tokenizer = new StringTokenizer(locale, "_");
            String language = null;
            String country = null;
            String variant = null;
            if (tokenizer.hasMoreElements()) {
                language = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                country = tokenizer.nextToken();
            }
            if (tokenizer.hasMoreElements()) {
                variant = tokenizer.nextToken();
            }
            if (country == null && variant == null) {
                return new Locale(language);
            }
            if (variant == null) {
                return new Locale(language, country);
            }
            return new Locale(language, country, variant);
        }

        public String toString() {
            return LocaleTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UuidTypeAdapter
    implements JsonSerializer<UUID>,
    JsonDeserializer<UUID> {
        private UuidTypeAdapter() {
        }

        @Override
        public JsonElement serialize(UUID src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        public UUID deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return UUID.fromString(json.getAsString());
        }

        public String toString() {
            return UuidTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UriTypeAdapter
    implements JsonSerializer<URI>,
    JsonDeserializer<URI> {
        private UriTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URI src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toASCIIString());
        }

        @Override
        public URI deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URI(json.getAsString());
            }
            catch (URISyntaxException e2) {
                throw new JsonParseException(e2);
            }
        }

        public String toString() {
            return UriTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlTypeAdapter
    implements JsonSerializer<URL>,
    JsonDeserializer<URL> {
        private UrlTypeAdapter() {
        }

        @Override
        public JsonElement serialize(URL src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toExternalForm());
        }

        @Override
        public URL deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return new URL(json.getAsString());
            }
            catch (MalformedURLException e2) {
                throw new JsonParseException(e2);
            }
        }

        public String toString() {
            return UrlTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumTypeAdapter<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private EnumTypeAdapter() {
        }

        @Override
        public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)src).name());
        }

        @Override
        public T deserialize(JsonElement json, Type classOfT, JsonDeserializationContext context) throws JsonParseException {
            return Enum.valueOf((Class)classOfT, json.getAsString());
        }

        public String toString() {
            return EnumTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GregorianCalendarTypeAdapter
    implements JsonSerializer<GregorianCalendar>,
    JsonDeserializer<GregorianCalendar> {
        private static final String YEAR = "year";
        private static final String MONTH = "month";
        private static final String DAY_OF_MONTH = "dayOfMonth";
        private static final String HOUR_OF_DAY = "hourOfDay";
        private static final String MINUTE = "minute";
        private static final String SECOND = "second";

        private GregorianCalendarTypeAdapter() {
        }

        @Override
        public JsonElement serialize(GregorianCalendar src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty(YEAR, src.get(1));
            obj.addProperty(MONTH, src.get(2));
            obj.addProperty(DAY_OF_MONTH, src.get(5));
            obj.addProperty(HOUR_OF_DAY, src.get(11));
            obj.addProperty(MINUTE, src.get(12));
            obj.addProperty(SECOND, src.get(13));
            return obj;
        }

        @Override
        public GregorianCalendar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int year = obj.get(YEAR).getAsInt();
            int month = obj.get(MONTH).getAsInt();
            int dayOfMonth = obj.get(DAY_OF_MONTH).getAsInt();
            int hourOfDay = obj.get(HOUR_OF_DAY).getAsInt();
            int minute = obj.get(MINUTE).getAsInt();
            int second = obj.get(SECOND).getAsInt();
            return new GregorianCalendar(year, month, dayOfMonth, hourOfDay, minute, second);
        }

        public String toString() {
            return GregorianCalendarTypeAdapter.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultDateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat format;

        DefaultDateTypeAdapter() {
            this.format = DateFormat.getDateTimeInstance();
        }

        DefaultDateTypeAdapter(String datePattern) {
            this.format = new SimpleDateFormat(datePattern);
        }

        DefaultDateTypeAdapter(int style) {
            this.format = DateFormat.getDateInstance(style);
        }

        public DefaultDateTypeAdapter(int dateStyle, int timeStyle) {
            this.format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                String dateFormatAsString = this.format.format(src);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonPrimitive)) {
                throw new JsonParseException("The date should be a string value");
            }
            try {
                DateFormat dateFormat = this.format;
                synchronized (dateFormat) {
                    return this.format.parse(json.getAsString());
                }
            }
            catch (ParseException e2) {
                throw new JsonParseException(e2);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(DefaultDateTypeAdapter.class.getSimpleName());
            sb.append('(').append(this.format.getClass().getSimpleName()).append(')');
            return sb.toString();
        }
    }
}

