/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eaglei.search.provider.MultiNodeSearchProvider;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;

public class AggregatingSearchProvider
implements MultiNodeSearchProvider {
    private final List<SearchProvider> providers = new ArrayList<SearchProvider>();
    private final List<MultiNodeSearchProvider> multiNodeProviders = new ArrayList<MultiNodeSearchProvider>();

    public void addSearchProvider(SearchProvider provider) {
        this.providers.add(provider);
    }

    public void addMultiNodeSearchProvider(MultiNodeSearchProvider provider) {
        this.multiNodeProviders.add(provider);
    }

    @Override
    public Collection<SearchResultSet> query(SearchRequest request) throws IOException {
        LinkedHashSet<SearchResultSet> results = new LinkedHashSet<SearchResultSet>();
        for (SearchProvider searchProvider : this.providers) {
            results.add(searchProvider.query(request));
        }
        for (MultiNodeSearchProvider multiNodeSearchProvider : this.multiNodeProviders) {
            for (SearchResultSet resultSet : multiNodeSearchProvider.query(request)) {
                results.add(resultSet);
            }
        }
        return results;
    }

    @Override
    public Collection<SearchCounts> count(SearchCountRequest request) throws IOException {
        LinkedHashSet<SearchCounts> results = new LinkedHashSet<SearchCounts>();
        for (SearchProvider searchProvider : this.providers) {
            results.add(searchProvider.count(request));
        }
        for (MultiNodeSearchProvider multiNodeSearchProvider : this.multiNodeProviders) {
            for (SearchCounts counts : multiNodeSearchProvider.count(request)) {
                results.add(counts);
            }
        }
        return results;
    }

    @Override
    public void init() throws IOException {
        for (SearchProvider searchProvider : this.providers) {
            searchProvider.init();
        }
        for (MultiNodeSearchProvider multiNodeSearchProvider : this.multiNodeProviders) {
            multiNodeSearchProvider.init();
        }
    }
}

