/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATermAppl;
import com.hp.hpl.jena.query.Syntax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryCost;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.ARQParser;
import org.mindswap.pellet.query.impl.DistVarsQueryExec;
import org.mindswap.pellet.query.impl.MultiQueryResults;
import org.mindswap.pellet.query.impl.NoDistVarsQueryExec;
import org.mindswap.pellet.query.impl.OptimizedQueryExec;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.query.impl.SimpleQueryExec;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.PermutationGenerator;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.SizeEstimate;
import org.mindswap.pellet.utils.Timer;

public class QueryEngine {
    public static final Logger log = Logger.getLogger(QueryEngine.class.getName());
    public static final Syntax DEFAULT_SYNTAX = Syntax.syntaxSPARQL;
    private static DistVarsQueryExec distVars = new DistVarsQueryExec();
    private static OptimizedQueryExec optimized = new OptimizedQueryExec();
    private static SimpleQueryExec simple = new SimpleQueryExec();
    private static NoDistVarsQueryExec noVars = new NoDistVarsQueryExec();
    private static QueryExec[] queryExecs = new QueryExec[]{noVars, distVars, optimized, simple};

    public static QueryParser createParser() {
        return QueryEngine.createParser(DEFAULT_SYNTAX);
    }

    public static QueryParser createParser(Syntax syntax) {
        ARQParser parser = new ARQParser();
        parser.setSyntax(syntax);
        return parser;
    }

    public static QueryResults exec(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, DEFAULT_SYNTAX);
    }

    public static QueryResults execRDQL(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, Syntax.syntaxRDQL);
    }

    public static QueryResults execSPARQL(String queryStr, KnowledgeBase kb) {
        return QueryEngine.exec(queryStr, kb, Syntax.syntaxSPARQL);
    }

    public static Query parse(String queryStr, KnowledgeBase kb) {
        return QueryEngine.parse(queryStr, kb, DEFAULT_SYNTAX);
    }

    public static Query parse(String queryStr, KnowledgeBase kb, Syntax syntax) {
        QueryParser parser = QueryEngine.createParser(syntax);
        Query query2 = parser.parse(queryStr, kb);
        return query2;
    }

    public static QueryResults exec(String queryStr, KnowledgeBase kb, Syntax syntax) {
        Query query2 = QueryEngine.parse(queryStr, kb, syntax);
        return QueryEngine.exec(query2);
    }

    public static QueryResults exec(Query query2, KnowledgeBase kb) {
        KnowledgeBase origKB = query2.getKB();
        query2.setKB(kb);
        QueryResults results = QueryEngine.exec(query2);
        query2.setKB(origKB);
        return results;
    }

    public static QueryResults exec(Query query2) {
        List queries;
        if (query2.getQueryPatterns().isEmpty()) {
            QueryResultsImpl results = new QueryResultsImpl(query2);
            results.add(new QueryResultBindingImpl());
            return results;
        }
        if (PelletOptions.SIMPLIFY_QUERY) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Simplifying:\n" + query2);
            }
            QueryEngine.simplify(query2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Split:\n" + query2);
        }
        if ((queries = QueryEngine.split(query2)).isEmpty()) {
            throw new InternalReasonerException("Splitting query returned no results!");
        }
        if (queries.size() == 1) {
            return QueryEngine.execSingleQuery((Query)queries.get(0));
        }
        QueryResults[] results = new QueryResults[queries.size()];
        for (int i = 0; i < queries.size(); ++i) {
            Query qry = (Query)queries.get(i);
            results[i] = QueryEngine.execSingleQuery(qry);
        }
        return new MultiQueryResults(query2, results);
    }

    private static QueryResults execSingleQuery(Query query2) {
        query2.prepare();
        boolean hasUndefinedPredicate = false;
        KnowledgeBase kb = query2.getKB();
        List patterns = query2.getQueryPatterns();
        for (QueryPattern pattern : patterns) {
            ATermAppl s = pattern.getSubject();
            ATermAppl o = pattern.getObject();
            if (!ATermUtils.isVar(s) && !kb.isIndividual(s)) {
                hasUndefinedPredicate = true;
                log.warning("Query refers to an undefined individual: " + s);
                break;
            }
            if (pattern.isTypePattern()) {
                if (kb.isClass(o)) continue;
                hasUndefinedPredicate = true;
                log.warning("Query refers to an undefined class: " + o);
                break;
            }
            if (!(ATermUtils.isVar(o) || ATermUtils.isLiteral(o) || kb.isIndividual(o))) {
                hasUndefinedPredicate = true;
                log.warning("Query refers to an undefined individual: " + o);
                break;
            }
            ATermAppl p = pattern.getPredicate();
            if (kb.isProperty(p)) continue;
            hasUndefinedPredicate = true;
            log.warning("Query refers to an undefined property: " + p);
            break;
        }
        if (hasUndefinedPredicate) {
            return new QueryResultsImpl(query2);
        }
        if (query2.isGround()) {
            return noVars.exec(query2);
        }
        if (PelletOptions.SAMPLING_RATIO > 0.0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Reorder\n" + query2);
            }
            query2 = QueryEngine.reorder(query2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Execute\n" + query2);
        }
        for (int i = 0; i < queryExecs.length; ++i) {
            if (!queryExecs[i].supports(query2)) continue;
            Timer timer = query2.getKB().timers.startTimer("Query");
            QueryExec queryExec = queryExecs[i];
            QueryResults results = queryExec.exec(query2);
            timer.stop();
            return results;
        }
        throw new InternalReasonerException("Cannot determine which query engine to use");
    }

    public static Query reorder(Query query2) {
        double minCost = Double.POSITIVE_INFINITY;
        KnowledgeBase kb = query2.getKB();
        List patterns = query2.getQueryPatterns();
        if (kb.getIndividuals().size() <= 100 || patterns.size() > 7) {
            return query2;
        }
        QueryEngine.computeSizeEstimates(query2);
        QueryCost queryCost = new QueryCost(query2.getKB());
        ArrayList bestOrder = null;
        int n = patterns.size();
        PermutationGenerator gen = new PermutationGenerator(n);
        int i = 0;
        while (gen.hasMore()) {
            int[] perm = gen.getNext();
            ArrayList newPatterns = new ArrayList();
            for (int j = 0; j < n; ++j) {
                newPatterns.add(patterns.get(perm[j]));
            }
            double cost = queryCost.estimateCost(newPatterns);
            if (cost < minCost) {
                minCost = cost;
                bestOrder = newPatterns;
            }
            ++i;
        }
        if (bestOrder == patterns) {
            return query2;
        }
        QueryImpl newQuery = new QueryImpl(kb, query2.isDistinct());
        for (int j = 0; j < n; ++j) {
            newQuery.addPattern((QueryPattern)bestOrder.get(j));
        }
        for (ATermAppl var : query2.getResultVars()) {
            newQuery.addResultVar(var);
        }
        for (ATermAppl var : query2.getDistVars()) {
            newQuery.addDistVar(var);
        }
        return newQuery;
    }

    public static List split(Query query2) {
        try {
            Set distVars = query2.getDistVars();
            HashSet resultVars = new HashSet(query2.getResultVars());
            DisjointSet<ATermAppl> disjointSet = new DisjointSet<ATermAppl>();
            List patterns = query2.getQueryPatterns();
            for (QueryPattern pattern : patterns) {
                ATermAppl subj = pattern.getSubject();
                ATermAppl obj = pattern.getObject();
                if (pattern.isTypePattern()) {
                    disjointSet.add(subj);
                    continue;
                }
                disjointSet.add(subj);
                disjointSet.add(obj);
                disjointSet.union(subj, obj);
            }
            Collection equivalenceSets = disjointSet.getEquivalanceSets();
            if (equivalenceSets.size() == 1) {
                return Collections.singletonList(query2);
            }
            HashMap<ATermAppl, Query> queries = new HashMap<ATermAppl, Query>();
            for (QueryPattern pattern : patterns) {
                ATermAppl subj = pattern.getSubject();
                ATermAppl pred = pattern.getPredicate();
                ATermAppl obj = pattern.getObject();
                ATermAppl representative = disjointSet.find(subj);
                Query newQuery = (Query)queries.get(representative);
                if (newQuery == null) {
                    newQuery = new QueryImpl(query2.getKB(), query2.isDistinct());
                    queries.put(representative, newQuery);
                }
                if (resultVars.contains(subj)) {
                    newQuery.addResultVar(subj);
                } else if (distVars.contains(subj)) {
                    newQuery.addDistVar(subj);
                }
                if (pattern.isTypePattern()) {
                    newQuery.addTypePattern(subj, obj);
                    continue;
                }
                newQuery.addEdgePattern(subj, pred, obj);
                if (resultVars.contains(obj)) {
                    newQuery.addResultVar(obj);
                    continue;
                }
                if (!distVars.contains(obj)) continue;
                newQuery.addDistVar(obj);
            }
            return new ArrayList(queries.values());
        }
        catch (RuntimeException e2) {
            log.log(Level.WARNING, "Query split failed, continuing with query execution.");
            e2.printStackTrace();
            return Collections.singletonList(query2);
        }
    }

    public static void simplify(Query query2) {
        HashMap allInferredTypes = new HashMap();
        KnowledgeBase kb = query2.getKB();
        Set vars = query2.getObjVars();
        for (ATermAppl var : vars) {
            HashSet<ATermAppl> inferredTypes = new HashSet<ATermAppl>();
            List outList = query2.findPatterns(var, null, null);
            for (QueryPattern pattern : outList) {
                ATermAppl pred = pattern.getPredicate();
                inferredTypes.addAll(kb.getDomains(pred));
            }
            List inList = query2.findPatterns(null, null, var);
            for (QueryPattern pattern : inList) {
                ATermAppl pred = pattern.getPredicate();
                inferredTypes.addAll(kb.getRanges(pred));
            }
            if (inferredTypes.isEmpty()) continue;
            allInferredTypes.put(var, inferredTypes);
        }
        ArrayList patterns = new ArrayList(query2.getQueryPatterns());
        for (QueryPattern pattern : patterns) {
            ATermAppl var;
            Set inferredTypes;
            if (pattern.isEdgePattern() || (inferredTypes = (Set)allInferredTypes.get(var = pattern.getSubject())) == null) continue;
            ATermAppl c = pattern.getObject();
            if (inferredTypes.contains(c)) {
                query2.removePattern(pattern);
                continue;
            }
            if (!kb.isClassified()) continue;
            Set<ATermAppl> subs = kb.getTaxonomy().getFlattenedSubs(c, false);
            Set<ATermAppl> eqs = kb.getAllEquivalentClasses(c);
            if (!SetUtils.intersects(inferredTypes, subs) && !SetUtils.intersects(inferredTypes, eqs)) continue;
            query2.removePattern(pattern);
        }
    }

    public static void prepare(KnowledgeBase kb) {
        QueryEngine.computeSizeEstimates(kb);
    }

    public static void computeSizeEstimates(KnowledgeBase kb) {
        kb.getSizeEstimate().computeAll();
    }

    public static void prepare(Query ... queries) {
        QueryEngine.computeSizeEstimates(queries);
    }

    public static void computeSizeEstimates(Query ... queries) {
        if (queries == null || queries.length == 0) {
            throw new IllegalArgumentException("No query specified!");
        }
        SizeEstimate sizeEstimate = queries[0].getKB().getSizeEstimate();
        HashSet<ATermAppl> concepts = new HashSet<ATermAppl>();
        HashSet<ATermAppl> properties = new HashSet<ATermAppl>();
        for (int j = 0; j < queries.length; ++j) {
            Query query2 = queries[j];
            List patterns = query2.getQueryPatterns();
            for (int i = 0; i < patterns.size(); ++i) {
                QueryPattern pattern = (QueryPattern)patterns.get(i);
                if (pattern.isTypePattern()) {
                    if (sizeEstimate.isComputed(pattern.getObject())) continue;
                    concepts.add(pattern.getObject());
                    continue;
                }
                if (sizeEstimate.isComputed(pattern.getPredicate())) continue;
                properties.add(pattern.getPredicate());
            }
        }
        sizeEstimate.compute(concepts, properties);
    }

    public static boolean execBoolean(Query query2) {
        return noVars.execBoolean(query2);
    }

    public static boolean isEquivalent(Query q1, Query q2) {
        return QueryEngine.isSubsumedBy(q1, q2) && QueryEngine.isSubsumedBy(q2, q1);
    }

    public static boolean isSubsumed(Query sub, Query sup) {
        return QueryEngine.isSubsumedBy(sub, sup);
    }

    public static boolean isSubsumedBy(Query sub, Query sup) {
        return !QueryEngine.getSubsumptionMappings(sub, sup).isEmpty();
    }

    public static boolean isSubsumed(Query sub, Query sup, KnowledgeBase backgroundKB) {
        return QueryEngine.isSubsumedBy(sub, sup, backgroundKB);
    }

    public static boolean isSubsumedBy(Query sub, Query sup, KnowledgeBase backgroundKB) {
        return !QueryEngine.getSubsumptionMappings(sub, sup, backgroundKB).isEmpty();
    }

    public static QueryResults getSubsumptionMappings(Query sub, Query sup) {
        return QueryEngine.getSubsumptionMappings(sub, sup, sub.getKB());
    }

    public static QueryResults getSubsumptionMappings(Query sub, Query sup, KnowledgeBase backgroundKB) {
        KnowledgeBase kb = backgroundKB.copy(true);
        List patterns = sub.getQueryPatterns();
        for (QueryPattern pattern : patterns) {
            ATermAppl subj = pattern.getSubject();
            ATermAppl pred = pattern.getPredicate();
            ATermAppl obj = pattern.getObject();
            subj = ATermUtils.isVar(subj) ? subj.getArgument(0) : subj;
            obj = ATermUtils.isVar(obj) ? obj.getArgument(0) : obj;
            kb.addIndividual(subj);
            if (pattern.isTypePattern()) {
                kb.addType(subj, obj);
                continue;
            }
            kb.addIndividual(obj);
            kb.addPropertyValue(pred, subj, obj);
        }
        kb.isConsistent();
        sup.setKB(kb);
        QueryResults results = QueryEngine.exec(sup);
        sup.setKB(backgroundKB);
        return results;
    }
}

