/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class GenericIntervalList {
    private final List intervals;
    private ValueSpace valueSpace;

    public GenericIntervalList(Object start, Object end, ValueSpace comp) {
        this.valueSpace = comp;
        this.intervals = new LinkedList();
        this.intervals.add(new Interval(start, true, end, true));
    }

    public GenericIntervalList(ValueSpace comp) {
        this.valueSpace = comp;
        this.intervals = new LinkedList();
    }

    public GenericIntervalList(GenericIntervalList il) {
        this.valueSpace = il.valueSpace;
        this.intervals = new LinkedList(il.intervals);
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public Object min() {
        if (this.intervals.isEmpty()) {
            return null;
        }
        return ((Interval)this.intervals.get(0)).start();
    }

    public Object max() {
        if (this.intervals.isEmpty()) {
            return null;
        }
        return ((Interval)this.intervals.get(this.intervals.size() - 1)).end();
    }

    public int count() {
        int count = 0;
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval i = (Interval)iter.next();
            int intervalCount = i.count();
            if (intervalCount == -1) {
                return -1;
            }
            if ((count += i.count()) >= 0) continue;
            return -1;
        }
        return count;
    }

    private void canonicalize() {
        Collections.sort(this.intervals);
        ListIterator<Interval> iter = this.intervals.listIterator();
        if (!iter.hasNext()) {
            return;
        }
        Interval currentElement = (Interval)iter.next();
        while (iter.hasNext()) {
            Interval lastElement = currentElement;
            if (!lastElement.overlaps(currentElement = (Interval)iter.next())) continue;
            Interval newElement = lastElement.merge(currentElement);
            iter.remove();
            iter.previous();
            iter.remove();
            iter.add(newElement);
            currentElement = newElement;
        }
    }

    public void addInterval(Object start, Object end) {
        this.addInterval(start, true, end, true);
    }

    public void addInterval(Object start, boolean incStart, Object end, boolean incEnd) {
        this.addIntervalInternal(start, incStart, end, incEnd);
        this.canonicalize();
    }

    private void addIntervalInternal(Object start, boolean incStart, Object end, boolean incEnd) {
        this.intervals.add(new Interval(start, incStart, end, incEnd));
    }

    public void removeInterval(Object start, boolean incStart, Object end, boolean incEnd) {
        this.removeIntervalInternal(start, incStart, end, incEnd);
        this.canonicalize();
    }

    private void removeIntervalInternal(Object start, boolean incStart, Object end, boolean incEnd) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        Interval toRemove = new Interval(start, incStart, end, incEnd);
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.overlaps(toRemove)) continue;
            iter.remove();
            if (this.valueSpace.compare(start, curr.start()) > 0) {
                iter.add(new Interval(curr.start(), curr.incStart(), start, !incStart));
                if (this.valueSpace.compare(end, curr.end()) >= 0) continue;
                iter.add(new Interval(end, !incEnd, curr.end(), curr.incEnd()));
                continue;
            }
            if (this.valueSpace.compare(end, curr.end()) >= 0) continue;
            iter.add(new Interval(end, !incEnd, curr.end(), curr.incEnd()));
        }
    }

    public void addIntervalList(GenericIntervalList il) {
        for (Interval i : il.intervals) {
            this.addIntervalInternal(i.start(), i.incStart(), i.end(), i.incEnd());
        }
        this.canonicalize();
    }

    public void removeIntervalList(GenericIntervalList il) {
        for (Interval i : il.intervals) {
            this.removeIntervalInternal(i.start(), i.incStart(), i.end(), i.incEnd());
        }
        this.canonicalize();
    }

    public void restrictToInterval(Object start, boolean incStart, Object end, boolean incEnd) {
        this.restrictToInterval(new Interval(start, incStart, end, incEnd));
    }

    public void restrictToInterval(Interval i) {
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (curr.overlaps(i)) {
                iter.set(curr.restrictTo(i));
                continue;
            }
            iter.remove();
        }
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.intervals).iterator();
    }

    public boolean equals(Object o) {
        if (o instanceof GenericIntervalList) {
            GenericIntervalList il = (GenericIntervalList)o;
            return ((Object)this.intervals).equals(il.intervals);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.intervals).hashCode();
    }

    public String toString() {
        return this.intervals.toString();
    }

    public boolean contains(Object value) {
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (!curr.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(int n) {
        int size = this.intervals.size();
        if (size > 0) {
            Interval i;
            int iCount;
            Interval first = (Interval)this.intervals.get(0);
            boolean firstInfinite = first.count() == -1;
            Interval last = (Interval)this.intervals.get(size - 1);
            boolean lastInfinite = size > 1 && last.count() == -1;
            ListIterator iter = this.intervals.listIterator();
            if (firstInfinite) {
                iter.next();
            }
            while (iter.hasNext() && (iCount = (i = (Interval)iter.next()).count()) != -1) {
                if (iCount <= n) {
                    n -= i.count();
                    continue;
                }
                int index = i.incStart ? n : n + 1;
                Object result = this.valueSpace.succ(i.start(), index);
                return result;
            }
            if (firstInfinite) {
                if (lastInfinite) {
                    int choose = n % 2;
                    n = (int)Math.floor((double)n / 2.0);
                    if (choose == 0) {
                        return this.valueSpace.succ(first.end(), -n);
                    }
                    return this.valueSpace.succ(last.start(), n);
                }
                if (!this.valueSpace.isInfinite(first.start())) {
                    return this.valueSpace.succ(first.start(), n);
                }
                if (!this.valueSpace.isInfinite(first.end())) {
                    return this.valueSpace.succ(first.end(), -n);
                }
                if (n == 0) {
                    return this.valueSpace.getMidValue();
                }
                int choose = n % 2;
                n = (int)Math.floor((double)n / 2.0);
                if (choose == 0) {
                    return this.valueSpace.succ(this.valueSpace.getMidValue(), -n);
                }
                return this.valueSpace.succ(this.valueSpace.getMidValue(), n);
            }
            this.valueSpace.succ(last.start(), n);
        }
        throw new InternalReasonerException("This interval does not have " + n + " values");
    }

    public class Interval
    implements Comparable {
        private final Object start;
        private final boolean incStart;
        private final Object end;
        private final boolean incEnd;

        public Interval(Object start, boolean incStart, Object end, boolean incEnd) {
            int cmp = GenericIntervalList.this.valueSpace.compare(end, start);
            if (cmp < 0) {
                throw new IllegalArgumentException("Interval end is less than start " + end + " < " + start);
            }
            if (cmp == 0 && !incStart && !incEnd) {
                throw new IllegalArgumentException("Cannot create empty interval (" + start + ", " + end + ")");
            }
            this.start = start;
            this.incStart = incStart;
            this.end = end;
            this.incEnd = incEnd;
        }

        public Object start() {
            return this.start;
        }

        public boolean incStart() {
            return this.incStart;
        }

        public Object end() {
            return this.end;
        }

        public boolean incEnd() {
            return this.incEnd;
        }

        public int count() {
            int count = GenericIntervalList.this.valueSpace.count(this.start, this.end);
            if (count != -1) {
                if (!this.incStart) {
                    --count;
                }
                if (!this.incEnd) {
                    --count;
                }
            }
            return count;
        }

        private boolean overlaps(Interval i) {
            if (GenericIntervalList.this.valueSpace.compare(this.start, i.start) <= 0) {
                int cmp = GenericIntervalList.this.valueSpace.compare(i.start, this.end);
                return cmp <= 0 && (cmp != 0 || i.incStart && this.incEnd);
            }
            return i.overlaps(this);
        }

        private Interval merge(Interval i) {
            if (this.overlaps(i)) {
                boolean newIncEnd;
                Object newEnd;
                boolean newIncStart;
                Object newStart;
                int cmpStart = GenericIntervalList.this.valueSpace.compare(this.start, i.start);
                int cmpEnd = GenericIntervalList.this.valueSpace.compare(i.end, this.end);
                if (cmpStart < 0) {
                    newStart = this.start;
                    newIncStart = this.incStart;
                } else if (cmpStart == 0) {
                    newStart = this.start;
                    newIncStart = this.incStart || i.incStart;
                } else {
                    newStart = i.start;
                    newIncStart = i.incStart;
                }
                if (cmpEnd < 0) {
                    newEnd = this.end;
                    newIncEnd = this.incEnd;
                } else if (cmpEnd == 0) {
                    newEnd = this.end;
                    newIncEnd = this.incEnd || i.incEnd;
                } else {
                    newEnd = i.end;
                    newIncEnd = i.incEnd;
                }
                return new Interval(newStart, newIncStart, newEnd, newIncEnd);
            }
            throw new IllegalArgumentException();
        }

        private Interval restrictTo(Interval i) {
            boolean newIncEnd;
            Object newEnd;
            boolean newIncStart;
            Object newStart;
            if (!this.overlaps(i)) {
                throw new IllegalArgumentException();
            }
            int cmpStart = GenericIntervalList.this.valueSpace.compare(this.start, i.start);
            int cmpEnd = GenericIntervalList.this.valueSpace.compare(i.end, this.end);
            if (cmpStart > 0) {
                newStart = this.start;
                newIncStart = this.incStart;
            } else if (cmpStart == 0) {
                newStart = this.start;
                newIncStart = this.incStart && i.incStart;
            } else {
                newStart = i.start;
                newIncStart = i.incStart;
            }
            if (cmpEnd > 0) {
                newEnd = this.end;
                newIncEnd = this.incEnd;
            } else if (cmpEnd == 0) {
                newEnd = this.end;
                newIncEnd = this.incEnd && i.incEnd;
            } else {
                newEnd = i.end;
                newIncEnd = i.incEnd;
            }
            return new Interval(newStart, newIncStart, newEnd, newIncEnd);
        }

        public int compareTo(Object o) {
            Interval i = (Interval)o;
            if (GenericIntervalList.this.valueSpace.compare(this.start, i.start) < 0) {
                return -1;
            }
            if (GenericIntervalList.this.valueSpace.compare(this.start, i.start) > 0) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof Interval) {
                Interval i = (Interval)o;
                if (i == this) {
                    return true;
                }
                return this.start.equals(i.start) && this.end.equals(i.end);
            }
            return false;
        }

        public boolean contains(Object value) {
            int cmpStart = GenericIntervalList.this.valueSpace.compare(this.start, value);
            int cmpEnd = GenericIntervalList.this.valueSpace.compare(value, this.end);
            return (cmpStart < 0 || cmpStart == 0 && this.incStart) && (cmpEnd < 0 || cmpEnd == 0 && this.incEnd);
        }

        public int hashCode() {
            int hashCode = 11;
            hashCode = 37 * hashCode + this.start.hashCode();
            hashCode = 37 * hashCode + (this.incStart ? 1231 : 1237);
            hashCode = 37 * hashCode + this.end.hashCode();
            hashCode = 37 * hashCode + (this.incEnd ? 1231 : 1237);
            return hashCode;
        }

        public String toString() {
            return (this.incStart ? "[" : "(") + this.start + " - " + this.end + (this.incEnd ? "]" : ")");
        }
    }
}

