/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.FlattenningIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorUtils {
    private static final Iterator<Object> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static final <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> Set<T> toSet(Iterator<T> i) {
        HashSet<T> set = new HashSet<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> List<T> toList(Iterator<T> i) {
        ArrayList<T> set = new ArrayList<T>();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return set;
    }

    public static <T> Iterator<T> flatten(Iterator<? extends Iterable<T>> iterator) {
        return new FlattenningIterator(iterator);
    }

    public static <T> Iterator<T> iterator(T[] elements) {
        return new ArrayIterator<T>(elements, elements.length);
    }

    public static <T> Iterator<T> iterator(T[] elements, int size) {
        return new ArrayIterator<T>(elements, size);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] array;
        private int size;
        private int curr = 0;

        public ArrayIterator(E[] array, int size) {
            this.array = array;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.curr != this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.curr++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

