/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import aterm.Visitor;
import aterm.pure.PureFactory;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jjtraveler.VisitFailure;

class ATermWriter
extends Visitor {
    private static char[] TOBASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    PrintStream stream;
    int position;
    Map table;
    int next_abbrev;

    ATermWriter(OutputStream stream) {
        this.stream = new PrintStream(stream);
    }

    public OutputStream getStream() {
        return this.stream;
    }

    private void emitAbbrev(int abbrev) {
        this.stream.print('#');
        ++this.position;
        StringBuffer buf = new StringBuffer();
        if (abbrev == 0) {
            buf.append(TOBASE64[0]);
        }
        while (abbrev > 0) {
            buf.append(TOBASE64[abbrev % 64]);
            abbrev /= 64;
        }
        String txt = buf.reverse().toString();
        this.stream.print(txt);
        this.position += txt.length();
    }

    public void visitChild(ATerm child) throws VisitFailure {
        int length;
        ATermList annos;
        Integer abbrev;
        if (this.table != null && (abbrev = (Integer)this.table.get(child)) != null) {
            this.emitAbbrev(abbrev);
            return;
        }
        int start = this.position++;
        if (child.getType() == 4) {
            this.stream.print('[');
        }
        this.visit(child);
        if (child.getType() == 4) {
            this.stream.print(']');
            ++this.position;
        }
        if (!(annos = child.getAnnotations()).isEmpty()) {
            this.stream.print('{');
            ++this.position;
            this.visit(annos);
            this.stream.print('}');
            ++this.position;
        }
        if (this.table != null && (length = this.position - start) > PureFactory.abbrevSize(this.next_abbrev)) {
            Integer key = new Integer(this.next_abbrev++);
            this.table.put(child, key);
        }
    }

    public void visitAppl(ATermAppl appl) throws VisitFailure {
        AFun fun = appl.getAFun();
        String name = fun.toString();
        this.stream.print(name);
        this.position += name.length();
        if (fun.getArity() > 0 || name.equals("")) {
            this.stream.print('(');
            ++this.position;
            int i = 0;
            while (i < fun.getArity()) {
                if (i != 0) {
                    this.stream.print(',');
                    ++this.position;
                }
                this.visitChild(appl.getArgument(i));
                ++i;
            }
            this.stream.print(')');
            ++this.position;
        }
    }

    public void visitList(ATermList list) throws VisitFailure {
        while (!list.isEmpty()) {
            this.visitChild(list.getFirst());
            list = list.getNext();
            if (list.isEmpty()) continue;
            this.stream.print(',');
            ++this.position;
        }
    }

    public void visitPlaceholder(ATermPlaceholder ph) throws VisitFailure {
        this.stream.print('<');
        ++this.position;
        this.visitChild(ph.getPlaceholder());
        this.stream.print('>');
        ++this.position;
    }

    public void visitInt(ATermInt i) throws VisitFailure {
        String txt = String.valueOf(i.getInt());
        this.stream.print(txt);
        this.position += txt.length();
    }

    public void visitReal(ATermReal r) throws VisitFailure {
        String txt = String.valueOf(r.getReal());
        this.stream.print(txt);
        this.position += txt.length();
    }

    public void visitBlob(ATermBlob blob) throws VisitFailure {
        String txt = String.valueOf(String.valueOf(blob.getBlobSize())) + "#" + String.valueOf(blob.hashCode());
        this.stream.print(txt);
        this.position += txt.length();
    }

    public void initializeSharing() {
        this.table = new HashMap();
    }
}

