/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.el.Trigger;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConceptInfo {
    public static final Logger logger = Logger.getLogger(ConceptInfo.class.getName());
    private ATermAppl concept;
    private Set<Trigger> triggers;
    private MultiValueMap<ATermAppl, ConceptInfo> successors;
    private MultiValueMap<ATermAppl, ConceptInfo> predecessors;
    private Set<ConceptInfo> superClasses;
    private List<ConceptInfo> subClasses;

    public ConceptInfo(ATermAppl c, boolean storeSuccessors, boolean storeSubClasses) {
        this.concept = c;
        this.superClasses = CollectionUtils.makeSet();
        this.subClasses = storeSubClasses ? new ArrayList() : null;
        this.successors = storeSuccessors ? new MultiValueMap() : null;
        this.predecessors = new MultiValueMap();
        this.triggers = storeSubClasses ? null : new HashSet();
    }

    public boolean addSuccessor(ATermAppl p, ConceptInfo ci) {
        if (ci.predecessors.add(p, this)) {
            if (this.successors != null) {
                this.successors.add(p, ci);
            }
            return true;
        }
        return false;
    }

    public boolean addSuperClass(ConceptInfo sup) {
        return this.addSuperClass(sup, false);
    }

    public boolean addSuperClass(ConceptInfo sup, boolean indirect) {
        if (this.superClasses.add(sup)) {
            if (this.subClasses != null && !indirect) {
                sup.subClasses.add(this);
            }
            return true;
        }
        return false;
    }

    public boolean addTrigger(Trigger trigger) {
        return this.triggers.add(trigger);
    }

    public boolean equals(Object obj) {
        return obj instanceof ConceptInfo && ((ConceptInfo)obj).concept == this.concept;
    }

    public ATermAppl getConcept() {
        return this.concept;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getSuccessors() {
        return this.successors;
    }

    public MultiValueMap<ATermAppl, ConceptInfo> getPredecessors() {
        return this.predecessors;
    }

    public Set<ConceptInfo> getSuperClasses() {
        return this.superClasses;
    }

    public Collection<ConceptInfo> getSubClasses() {
        return this.subClasses;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public boolean hasSuccessor(ATermAppl p, ConceptInfo ci) {
        return ci.predecessors.contains(p, this);
    }

    public int hashCode() {
        return this.concept.hashCode();
    }

    public boolean hasSuperClass(ConceptInfo ci) {
        return this.superClasses.contains(ci);
    }

    public String toString() {
        return this.concept.toString();
    }
}

