/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lib;

import com.hp.hpl.jena.sparql.lib.Cache;
import com.hp.hpl.jena.sparql.lib.CacheSet;
import com.hp.hpl.jena.sparql.lib.CacheStats;
import com.hp.hpl.jena.sparql.lib.cache.CacheLRU;
import com.hp.hpl.jena.sparql.lib.cache.CacheSetLRU;
import com.hp.hpl.jena.sparql.lib.cache.CacheSetSync;
import com.hp.hpl.jena.sparql.lib.cache.CacheSimple;
import com.hp.hpl.jena.sparql.lib.cache.CacheStatsAtomic;
import com.hp.hpl.jena.sparql.lib.cache.CacheSync;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFactory {
    public static <Key, Value> Cache<Key, Value> createCache(int maxSize) {
        return CacheFactory.createCache(0.75f, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createCache(float loadFactor, int maxSize) {
        return new CacheLRU(0.75f, maxSize);
    }

    public static <Key, Value> Cache<Key, Value> createSimpleCache(int size) {
        return new CacheSimple(size);
    }

    public static <Key, Value> CacheStats<Key, Value> createStats(Cache<Key, Value> cache) {
        if (cache instanceof CacheStats) {
            return (CacheStats)cache;
        }
        return new CacheStatsAtomic<Key, Value>(cache);
    }

    public static <Key, Value> Cache<Key, Value> createSync(Cache<Key, Value> cache) {
        if (cache instanceof CacheSync) {
            return cache;
        }
        return new CacheSync<Key, Value>(cache);
    }

    public static <Obj> CacheSet<Obj> createCacheSet(int size) {
        return new CacheSetLRU(size);
    }

    public static <Obj> CacheSet<Obj> createSync(CacheSet<Obj> cache) {
        if (cache instanceof CacheSetSync) {
            return cache;
        }
        return new CacheSetSync<Obj>(cache);
    }
}

