/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.lib.iterator.Iter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    static NumberFormat integerFormat = NumberFormat.getNumberInstance();
    static DateFormat dateTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static DecimalFormat decimalFormat = new DecimalFormat("#,##0.0");
    private static Pattern p = Pattern.compile("http:[^ \n]*[#/]([^/ \n]*)");

    public static String join(String sep, String[] a) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return a[0];
        }
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            if (sep != null) {
                sbuff.append(sep);
            }
            sbuff.append(a[i]);
        }
        return sbuff.toString();
    }

    public static String join(String sep, List<String> a) {
        return StringUtils.join(sep, a.toArray(new String[0]));
    }

    public static int strCompare(String s1, String s2) {
        int x = s1.compareTo(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new ARQInternalErrorException("String comparison failure");
    }

    public static int strCompareIgnoreCase(String s1, String s2) {
        int x = s1.compareToIgnoreCase(s2);
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        if (x == 0) {
            return 0;
        }
        throw new ARQInternalErrorException("String comparison failure");
    }

    public static byte[] asUTF8bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ARQInternalErrorException("UTF-8 not supported!");
        }
    }

    public static String str(Object x) {
        if (x == null) {
            return "<null>";
        }
        return x.toString();
    }

    public static String str(long v) {
        return integerFormat.format(v);
    }

    public static String str(Date date2) {
        return dateTimeFormat.format(date2);
    }

    public static String str(float value) {
        return decimalFormat.format(value);
    }

    public static String str(double value) {
        return decimalFormat.format(value);
    }

    public static boolean contains(String str1, String str2) {
        return str1.indexOf(str2) >= 0;
    }

    public static String printAbbrev(Object obj) {
        if (obj == null) {
            return "<null>";
        }
        String x = obj.toString();
        return p.matcher(x).replaceAll("::$1");
    }

    public static <T> String printAbbrevList(List<T> objs) {
        String x = Iter.asString(objs, "\n");
        return StringUtils.printAbbrev(x);
    }
}

