/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIInstance
extends EIResource
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static final EIEntity WFStateEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState"), "Workflow state");
    private static final EIEntity WFOwnerEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner"), "Workflow owner");
    private static final EIEntity CreatedEntity = EIEntity.create(EIURI.create("http://purl.org/dc/terms/created"), "Creation date");
    private EIEntity instanceType;
    private EIClass instanceClass;
    private List<EIEntity> otherEITypes;
    private Map<EIEntity, Set<EIURI>> objectProperties = new HashMap<EIEntity, Set<EIURI>>();
    private Map<EIEntity, Set<String>> datatypeProperties = new HashMap<EIEntity, Set<String>>();
    private Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties = new HashMap<EIEntity, Set<EIURI>>();
    private Map<EIEntity, Set<String>> nonOntologyLiteralProperties = new HashMap<EIEntity, Set<String>>();
    private Map<EIEntity, EIURI> readOnlyResourceProperties;
    private Map<EIEntity, String> readOnlyLiteralProperties;
    private Map<EIEntity, List<EIClass>> ranges = new HashMap<EIEntity, List<EIClass>>();

    private EIInstance() {
    }

    private EIInstance(EIEntity instanceType, EIEntity instanceEntity) {
        super(instanceEntity);
        this.instanceType = instanceType;
    }

    public static EIInstance create(EIEntity instanceType, EIEntity instanceEntity) {
        return new EIInstance(instanceType, instanceEntity);
    }

    public EIClass getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(EIClass instanceClass) {
        this.instanceClass = instanceClass;
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public EIEntity getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(EIEntity instanceType) {
        this.instanceType = instanceType;
    }

    public EIURI getWFState() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFStateEntity)) {
            EIURI state = this.readOnlyResourceProperties.get(WFStateEntity);
            return state;
        }
        return null;
    }

    public void setWFState(EIURI state) {
        this.setReadOnlyResourceProperty(WFStateEntity, state);
    }

    public EIURI getWFOwner() {
        if (this.readOnlyResourceProperties == null) {
            return null;
        }
        if (this.readOnlyResourceProperties.containsKey(WFOwnerEntity)) {
            EIURI state = this.readOnlyResourceProperties.get(WFOwnerEntity);
            return state;
        }
        return null;
    }

    public void setWFOwner(EIURI ownerUri) {
        this.setReadOnlyResourceProperty(WFOwnerEntity, ownerUri);
    }

    public String getCreationDate() {
        if (this.readOnlyLiteralProperties == null) {
            return null;
        }
        if (this.readOnlyLiteralProperties.containsKey(CreatedEntity)) {
            String created = this.readOnlyLiteralProperties.get(CreatedEntity);
            return created;
        }
        return null;
    }

    public void setCreationDate(String date2) {
        this.setReadOnlyLiteralProperty(CreatedEntity, date2);
    }

    public void setRangeList(EIEntity entity, List<EIClass> rangeList) {
        this.ranges.put(entity, rangeList);
    }

    public List<EIClass> getRangeList(EIEntity entity) {
        return this.ranges.get(entity);
    }

    public Map<EIEntity, List<EIClass>> getAllRanges() {
        return this.ranges;
    }

    @Deprecated
    public void setObjectProperties(Map<EIEntity, Set<EIURI>> objectProperties) {
        this.objectProperties = objectProperties;
    }

    public Map<EIEntity, Set<EIURI>> getObjectProperties() {
        return this.objectProperties;
    }

    public void addObjectProperty(EIEntity property, EIURI value) {
        Set<EIURI> pValues = this.objectProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.objectProperties.put(property, pValues);
        }
        pValues.add(value);
    }

    public Set<EIURI> getObjectProperty(EIEntity property) {
        return this.objectProperties.get(property);
    }

    public void replaceObjectPropertyValue(EIEntity property, EIURI oldValue, EIURI newValue) {
        Set<EIURI> pValues = this.objectProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.objectProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        if (newValue != null) {
            pValues.add(newValue);
        }
    }

    public void replaceObjectPropertyAllValues(EIEntity property, Set<EIURI> values) {
        this.objectProperties.put(property, values);
    }

    @Deprecated
    public void setDatatypeProperties(Map<EIEntity, Set<String>> datatypeProperties) {
        this.datatypeProperties = datatypeProperties;
    }

    public Map<EIEntity, Set<String>> getDatatypeProperties() {
        return this.datatypeProperties;
    }

    public void addDatattypeProperty(EIEntity property, String value) {
        Set<String> pValues = this.datatypeProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.add(value);
    }

    public Set<String> getDatatypeProperty(EIEntity property) {
        return this.datatypeProperties.get(property);
    }

    public void replaceDatatypePropertyValue(EIEntity property, String oldValue, String newValue) {
        Set<String> pValues = this.datatypeProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.datatypeProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        pValues.add(newValue);
    }

    public void replaceDatatypePropertyAllValues(EIEntity property, Set<String> values) {
        this.datatypeProperties.put(property, values);
    }

    @Deprecated
    public void setNonOntologyResourceProperties(Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties) {
        this.nonOntologyResourceProperties = nonOntologyResourceProperties;
    }

    public Map<EIEntity, Set<EIURI>> getNonOntologyResourceProperties() {
        return this.nonOntologyResourceProperties;
    }

    public void addNonOntologyResourceProperty(EIEntity property, EIURI resource) {
        Set<EIURI> pValues = this.nonOntologyResourceProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.add(resource);
    }

    public Set<EIURI> getNonOntologyResourceProperty(EIEntity property) {
        return this.nonOntologyResourceProperties.get(property);
    }

    public void replaceNonOntologyResourcePropertyValue(EIEntity property, EIURI oldValue, EIURI newValue) {
        Set<EIURI> pValues = this.nonOntologyResourceProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<EIURI>();
            this.nonOntologyResourceProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        pValues.add(newValue);
    }

    public void replaceNonOntologyResourcePropertyAllValues(EIEntity property, Set<EIURI> values) {
        this.nonOntologyResourceProperties.put(property, values);
    }

    @Deprecated
    public void setNonOntologyLiteralProperties(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
        this.nonOntologyLiteralProperties = nonOntologyLiteralProperties;
    }

    public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
        return this.nonOntologyLiteralProperties;
    }

    public void addNonOntologyLiteralProperty(EIEntity property, String literal) {
        Set<String> pValues = this.nonOntologyLiteralProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.add(literal);
    }

    public Set<String> getNonOntologyLiteralProperty(EIEntity property) {
        return this.nonOntologyLiteralProperties.get(property);
    }

    public void replaceNonOntologyLiteralProperty(EIEntity property, String oldValue, String newValue) {
        Set<String> pValues = this.nonOntologyLiteralProperties.get(property);
        if (pValues == null) {
            pValues = new HashSet<String>();
            this.nonOntologyLiteralProperties.put(property, pValues);
        }
        pValues.remove(oldValue);
        pValues.add(newValue);
    }

    public void replaceNonOntologyLiteralPropertyAllValues(EIEntity property, Set<String> values) {
        this.datatypeProperties.put(property, values);
    }

    public void addEIType(EIEntity eiType) {
        if (eiType == null) {
            return;
        }
        if (this.otherEITypes == null) {
            this.otherEITypes = new ArrayList<EIEntity>();
        }
        this.otherEITypes.add(eiType);
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.otherEITypes = eiTypes;
    }

    public List<EIEntity> getOtherEITypes() {
        if (this.otherEITypes == null) {
            return Collections.emptyList();
        }
        return this.otherEITypes;
    }

    public Map<EIEntity, EIURI> getReadOnlyResourceProperties() {
        if (this.readOnlyResourceProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyResourceProperties;
    }

    public void setReadOnlyResourceProperties(Map<EIEntity, EIURI> readOnlyResourceProperties) {
        this.readOnlyResourceProperties = readOnlyResourceProperties;
    }

    public void setReadOnlyResourceProperty(EIEntity property, EIURI value) {
        if (this.readOnlyResourceProperties == null) {
            this.readOnlyResourceProperties = new HashMap<EIEntity, EIURI>();
        }
        this.readOnlyResourceProperties.put(property, value);
    }

    public Map<EIEntity, String> getReadOnlyLiteralProperties() {
        if (this.readOnlyLiteralProperties == null) {
            return Collections.emptyMap();
        }
        return this.readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperties(Map<EIEntity, String> readOnlyLiteralProperties) {
        this.readOnlyLiteralProperties = readOnlyLiteralProperties;
    }

    public void setReadOnlyLiteralProperty(EIEntity property, String value) {
        if (this.readOnlyLiteralProperties == null) {
            this.readOnlyLiteralProperties = new HashMap<EIEntity, String>();
        }
        this.readOnlyLiteralProperties.put(property, value);
    }

    public int compareTo(Object o) {
        if (!(o instanceof EIInstance)) {
            return 0;
        }
        return this.getEntity().getLabel().compareToIgnoreCase(((EIInstance)o).getEntity().getLabel());
    }

    @Override
    public String toString() {
        return this.instanceType.toString() + " : " + this.getEntity().toString();
    }
}

