/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.IEEEDoubleType;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.RestrictedFloatingPointDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDouble
implements Datatype<Double> {
    private static final XSDDouble instance;
    private static final Logger log;
    private final RestrictedFloatingPointDatatype<Double> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double");

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!((Object)input.getArgument(2)).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            Double f = DatatypeConverter.parseDouble((String)lexicalForm);
            String canonicalForm = DatatypeConverter.printDouble((double)f);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.name);
        }
        catch (NumberFormatException e2) {
            log.severe(String.format("Number format exception (%s) cause while parsing double %s", e2.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (IEEEDoubleType.getInstance().isInstance(value)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble((double)IEEEDoubleType.getInstance().cast(value)), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!((Object)literal.getArgument(2)).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return DatatypeConverter.parseDouble((String)lexicalForm);
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    static {
        log = Logger.getLogger(XSDDouble.class.getCanonicalName());
        instance = new XSDDouble();
    }
}

