/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingKey;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterNullIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterSingleton;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryIterGroup
extends QueryIterPlainWrapper {
    public QueryIterGroup(QueryIterator qIter, VarExprList groupVars, List<E_Aggregator> aggregators, ExecutionContext execCxt) {
        super(null, execCxt);
        Iterator<Binding> iter = QueryIterGroup.calc(qIter, groupVars, aggregators, execCxt);
        this.setIterator(iter);
    }

    private static Iterator<Binding> calc(QueryIterator iter, VarExprList groupVars, List<E_Aggregator> aggregators, ExecutionContext execCxt) {
        HashMap<BindingKey, Binding> buckets = new HashMap<BindingKey, Binding>();
        while (iter.hasNext()) {
            Binding b = iter.nextBinding();
            BindingKey key = QueryIterGroup.genKey(groupVars, b, execCxt);
            if (!buckets.containsKey(key)) {
                buckets.put(key, key.getBinding());
            }
            if (aggregators == null) continue;
            for (E_Aggregator agg : aggregators) {
                agg.getAggregator().accumulate(key, b, execCxt);
            }
        }
        if (buckets.isEmpty()) {
            boolean valueExists = false;
            BindingMap binding = new BindingMap();
            if (aggregators != null) {
                for (E_Aggregator agg : aggregators) {
                    Var v = agg.asVar();
                    Node value = agg.getAggregator().getValueEmpty();
                    if (value == null) continue;
                    binding.add(v, value);
                    valueExists = true;
                }
            }
            if (valueExists) {
                return new QueryIterSingleton(binding, execCxt);
            }
            return new QueryIterNullIterator(execCxt);
        }
        if (aggregators != null) {
            for (BindingKey key : buckets.keySet()) {
                Binding binding = (Binding)buckets.get(key);
                for (E_Aggregator agg : aggregators) {
                    Var v = agg.asVar();
                    Node value = agg.getAggregator().getValue(key);
                    if (value == null) continue;
                    binding.add(v, value);
                }
            }
        }
        return buckets.values().iterator();
    }

    private static BindingKey genKey(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        return new BindingKey(QueryIterGroup.copyProject(vars, binding, execCxt));
    }

    private static Binding copyProject(VarExprList vars, Binding binding, ExecutionContext execCxt) {
        BindingMap x = new BindingMap();
        for (Var var : vars.getVars()) {
            Node node = vars.get(var, binding, execCxt);
            if (node == null) continue;
            x.add(var, node);
        }
        return x;
    }
}

