/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVars;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExprNode
implements Expr {
    @Override
    public boolean isSatisfied(Binding binding, FunctionEnv funcEnv) {
        try {
            NodeValue v = this.eval(binding, funcEnv);
            boolean b = XSDFuncOp.booleanEffectiveValue(v);
            return b;
        }
        catch (ExprEvalException ex) {
            return false;
        }
    }

    public boolean isExpr() {
        return true;
    }

    public final Expr getExpr() {
        return this;
    }

    @Override
    public abstract NodeValue eval(Binding var1, FunctionEnv var2);

    @Override
    public Set<Var> getVarsMentioned() {
        return ExprVars.getVarsMentioned(this);
    }

    @Override
    public void varsMentioned(Collection<Var> acc) {
        ExprVars.varsMentioned(acc, this);
    }

    public Set<String> getVarNamesMentioned() {
        return ExprVars.getVarNamesMentioned(this);
    }

    public void varNamesMentioned(Collection<String> acc) {
        ExprVars.varNamesMentioned(acc, this);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public final Expr copySubstitute(Binding binding) {
        return this.copySubstitute(binding, false);
    }

    @Override
    public final Expr deepCopy() {
        return this.copySubstitute(null, false);
    }

    @Override
    public abstract Expr copySubstitute(Binding var1, boolean var2);

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public String getVarName() {
        return null;
    }

    @Override
    public ExprVar getExprVar() {
        return null;
    }

    @Override
    public Var asVar() {
        return null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public NodeValue getConstant() {
        return null;
    }

    @Override
    public boolean isFunction() {
        return false;
    }

    @Override
    public ExprFunction getFunction() {
        return null;
    }

    public boolean isGraphPttern() {
        return false;
    }

    public Op getGraphPttern() {
        return null;
    }

    public String toString() {
        return ExprUtils.fmtSPARQL(this);
    }
}

