/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIResource;
import org.eaglei.model.EIURI;

public class EIInstanceMinimal
extends EIResource
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private static final EIEntity WFStateEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState"), "Workflow state");
    private static final EIEntity WFOwnerEntity = EIEntity.create(EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner"), "Workflow owner");
    private static final EIEntity CreatedEntity = EIEntity.create(EIURI.create("http://purl.org/dc/terms/created"), "Creation date");
    private EIEntity instanceType;
    private List<EIEntity> otherEITypes;
    private EIURI WFState;
    private String created;
    private EIURI owner;

    private EIInstanceMinimal() {
    }

    private EIInstanceMinimal(EIEntity instanceType, EIEntity instanceEntity) {
        super(instanceEntity);
        this.instanceType = instanceType;
    }

    public static EIInstanceMinimal create(EIEntity instanceType, EIEntity instanceEntity) {
        return new EIInstanceMinimal(instanceType, instanceEntity);
    }

    public void addEIType(EIEntity eiType) {
        if (eiType == null) {
            return;
        }
        if (this.otherEITypes == null) {
            this.otherEITypes = new ArrayList<EIEntity>();
        }
        this.otherEITypes.add(eiType);
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.otherEITypes = eiTypes;
    }

    public List<EIEntity> getOtherEITypes() {
        if (this.otherEITypes == null) {
            return Collections.emptyList();
        }
        return this.otherEITypes;
    }

    public EIURI getInstanceURI() {
        return this.getEntity().getURI();
    }

    public String getInstanceLabel() {
        return this.getEntity().getLabel();
    }

    public EIEntity getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(EIEntity instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public String toString() {
        return this.instanceType.toString() + " : " + this.getEntity().toString();
    }

    public EIURI getWFState() {
        return this.WFState;
    }

    public void setWFState(EIURI state) {
        this.WFState = state;
    }

    public EIURI getWFOwner() {
        return this.owner;
    }

    public void setWFOwner(EIURI ownerUri) {
        this.owner = ownerUri;
    }

    public String getCreationDate() {
        return this.created;
    }

    public void setCreationDate(String date2) {
        this.created = date2;
    }

    public int compareTo(Object o) {
        if (!(o instanceof EIInstanceMinimal)) {
            return 0;
        }
        return this.getEntity().getLabel().compareToIgnoreCase(((EIInstanceMinimal)o).getEntity().getLabel());
    }
}

