/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryParameters;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;

public class QueryResultsImpl
implements QueryResults {
    private Query query;
    private QueryParameters parameters;
    private List results;

    public QueryResultsImpl(Query query2) {
        this.query = query2;
        this.parameters = query2.getQueryParameters();
        this.results = new ArrayList();
    }

    public void add(QueryResultBinding binding) {
        this.results.add(this.process(binding));
    }

    public boolean contains(QueryResultBinding binding) {
        return this.results.contains(this.process(binding));
    }

    public QueryResultBinding get(int index) {
        return (QueryResultBinding)this.results.get(index);
    }

    public int size() {
        return this.results.size();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public Query getQuery() {
        return this.query;
    }

    public List getResultVars() {
        return this.query.getResultVars();
    }

    public TableData toTable() {
        return this.toTable(false);
    }

    public TableData toTable(boolean formatHTML) {
        List resultVars = this.query.getResultVars();
        ArrayList<String> colNames = new ArrayList<String>(resultVars.size());
        for (int i = 0; i < resultVars.size(); ++i) {
            ATermAppl var = (ATermAppl)resultVars.get(i);
            colNames.add(QueryUtils.getVarName(var));
        }
        StringWriter sw = new StringWriter();
        PrintWriter formatter = new PrintWriter(sw);
        ATermManchesterSyntaxRenderer renderer = new ATermManchesterSyntaxRenderer();
        renderer.setWriter(formatter);
        TableData table = new TableData(colNames);
        for (int i = 0; i < this.size(); ++i) {
            QueryResultBinding binding = this.get(i);
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < resultVars.size(); ++j) {
                sw.getBuffer().setLength(0);
                ATermAppl var = (ATermAppl)resultVars.get(j);
                ATermAppl val = binding.getValue(var);
                if (val != null) {
                    renderer.visit(val);
                    list.add(sw.toString());
                    continue;
                }
                list.add("<<unbound>>");
            }
            table.add(list);
        }
        return table;
    }

    public String toString() {
        return this.toTable().toString();
    }

    private QueryResultBinding process(QueryResultBinding binding) {
        if (this.parameters == null) {
            return binding;
        }
        int numOfVars = this.query.getResultVars().size();
        for (Map.Entry<ATermAppl, ATermAppl> entry : this.parameters.entrySet()) {
            ATermAppl var = entry.getKey();
            ATermAppl value = entry.getValue();
            if (numOfVars != 0 && !this.query.getResultVars().contains(var)) continue;
            binding.setValue(var, value);
        }
        return binding;
    }
}

