/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import shared.SharedObject;
import shared.SharedObjectWithID;

public class SharedObjectFactory {
    protected int logSize;
    protected int hashMask;
    protected Entry[] table;
    private int[] tableSize;
    private int minThreshold;
    private int maxThreshold;
    private float loadFactor;
    private int[] usedId;
    private int maxId;
    private int minId;
    private int indexId;
    private int currentId;
    private int nbCall = 0;
    private int nbFoundReference = 0;
    private int nbFoundExactReference = 0;
    private int nbAdd = 0;
    private int nbRemoved = 0;
    private int nbProjectionCollision = 0;
    private int nbHashingCollision = 0;
    private int nbSwapEntry = 0;
    private int nbIdRegeneration = 0;
    private boolean cleanupDone = false;

    public SharedObjectFactory() {
        this(10);
    }

    public SharedObjectFactory(int initialLogSize) {
        this.logSize = initialLogSize;
        this.hashMask = this.hashMask();
        this.table = new Entry[this.hashSize()];
        this.tableSize = new int[this.hashSize()];
        this.loadFactor = 3.0f;
        this.maxThreshold = (int)((float)this.hashSize() * this.loadFactor);
        this.minThreshold = 0;
        this.maxId = Integer.MAX_VALUE;
        this.currentId = this.minId = Integer.MIN_VALUE;
        this.indexId = 0;
        this.usedId = new int[1];
        this.usedId[0] = this.maxId;
    }

    private int hashSize(int n) {
        return 1 << n;
    }

    private int hashSize() {
        return this.hashSize(this.logSize);
    }

    private int hashMask() {
        return this.hashSize() - 1;
    }

    private int hashKey(int key) {
        return key & this.hashMask;
    }

    protected void decreaseCapacity() {
        int oldLogSize = this.logSize;
        this.logSize -= 2;
        this.hashMask = this.hashMask();
        this.maxThreshold = (int)((float)this.hashSize() * this.loadFactor);
        this.minThreshold = this.maxThreshold / 10;
        this.rehash(this.hashSize(oldLogSize));
    }

    protected void increaseCapacity() {
        int oldLogSize = this.logSize++;
        this.hashMask = this.hashMask();
        this.maxThreshold = (int)((float)this.hashSize() * this.loadFactor);
        this.minThreshold = this.maxThreshold / 10;
        this.rehash(this.hashSize(oldLogSize));
    }

    /*
     * Unable to fully structure code
     */
    protected void rehash(int oldCapacity) {
        oldMap = this.table;
        this.table = new Entry[this.hashSize()];
        this.tableSize = new int[this.hashSize()];
        i = oldCapacity;
        while (i-- > 0) {
            old = oldMap[i];
            ** GOTO lbl20
            {
                old = old.next;
                ++this.nbRemoved;
                do {
                    if (old != null && old.get() == null) continue block1;
                    if (old == null) continue;
                    e = old;
                    old = old.next;
                    index = this.hashKey(e.get().hashCode());
                    e.next = this.table[index];
                    this.table[index] = e;
                    v0 = index;
                    this.tableSize[v0] = this.tableSize[v0] + 1;
lbl20:
                    // 3 sources

                } while (old != null);
            }
        }
        oldMap = null;
    }

    public void cleanup() {
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e2 = tab[i];
            Entry prev = null;
            while (e2 != null) {
                if (e2.get() == null) {
                    if (prev != null) {
                        prev.next = e2.next;
                    } else {
                        tab[i] = e2.next;
                    }
                    ++this.nbRemoved;
                    int n = i;
                    this.tableSize[n] = this.tableSize[n] - 1;
                } else {
                    prev = e2;
                }
                e2 = e2.next;
            }
        }
    }

    public String toString() {
        Entry[] tab = this.table;
        String s = "";
        s = String.valueOf(s) + "table_size            = " + this.table.length + "\n";
        s = String.valueOf(s) + "#call                 = " + this.nbCall + "\n";
        s = String.valueOf(s) + "nbFoundReference      = " + this.nbFoundReference + "\n";
        s = String.valueOf(s) + "nbFoundExactReference = " + this.nbFoundExactReference + "\n";
        s = String.valueOf(s) + "#BuiltObject          = " + this.nbAdd + "\n";
        s = String.valueOf(s) + "#RemovedReference     = " + this.nbRemoved + "\n";
        s = String.valueOf(s) + "#ID Regeneration      = " + this.nbIdRegeneration + "\n";
        double repartition = 0.0;
        double n = this.nbAdd - this.nbRemoved;
        double m = tab.length;
        int idx = 0;
        while (idx < tab.length) {
            double bj = this.tableSize[idx];
            repartition += bj * (1.0 + bj) / 2.0;
            ++idx;
        }
        s = String.valueOf(s) + "#element              = " + (int)n + " [" + (this.nbAdd - this.nbRemoved) + "]\n";
        double bestRepartition = n / (2.0 * m) * (n + 2.0 * m - 1.0);
        s = String.valueOf(s) + "repartition           = " + repartition / bestRepartition + "\n";
        s = String.valueOf(s) + "#lookup/build         = " + (double)(this.nbFoundReference + this.nbAdd) / (double)this.nbCall + "\n";
        s = String.valueOf(s) + "projectionCollision   = " + this.nbProjectionCollision + "\n";
        s = String.valueOf(s) + "hashingCollision      = " + this.nbHashingCollision + "\n";
        s = String.valueOf(s) + "swapEntry             = " + this.nbSwapEntry + "\n";
        int emptyEntry = 0;
        int usedSlot = 0;
        int idx2 = 0;
        while (idx2 < tab.length) {
            if (tab[idx2] != null) {
                usedSlot = 0;
                Entry e2 = tab[idx2];
                while (e2 != null) {
                    if (e2.get() != null) {
                        ++usedSlot;
                    }
                    e2 = e2.next;
                }
            } else {
                ++emptyEntry;
            }
            ++idx2;
        }
        s = String.valueOf(s) + "used = " + (tab.length - emptyEntry) + "\tempty = " + emptyEntry;
        return s;
    }

    public SharedObject build(SharedObject prototype) {
        SharedObject foundObj;
        ++this.nbCall;
        Entry[] tab = this.table;
        int hash = prototype.hashCode();
        int index = this.hashKey(hash);
        Entry e2 = tab[index];
        Entry prev = null;
        while (e2 != null) {
            foundObj = (SharedObject)e2.get();
            if (foundObj == null) {
                if (prev != null) {
                    prev.next = e2.next;
                    e2.clear();
                } else {
                    tab[index] = e2.next;
                    e2.clear();
                }
                ++this.nbRemoved;
                int n = index;
                this.tableSize[n] = this.tableSize[n] - 1;
            } else {
                ++this.nbFoundReference;
                if (prototype.equivalent(foundObj)) {
                    ++this.nbFoundExactReference;
                    if (prev != null && e2.value - tab[index].value > 5) {
                        ++this.nbSwapEntry;
                        prev.next = e2.next;
                        e2.next = tab[index];
                        tab[index] = e2;
                    }
                    ++e2.value;
                    return foundObj;
                }
                ++this.nbProjectionCollision;
                if (foundObj.hashCode() == hash) {
                    ++this.nbHashingCollision;
                }
                prev = e2;
            }
            e2 = e2.next;
        }
        int count = this.nbAdd - this.nbRemoved;
        if (count >= this.maxThreshold) {
            if (!this.cleanupDone) {
                this.cleanupDone = true;
                System.gc();
                this.cleanup();
            } else {
                this.cleanupDone = false;
                this.increaseCapacity();
                tab = this.table;
                index = this.hashKey(hash);
            }
        }
        foundObj = prototype.duplicate();
        if (prototype instanceof SharedObjectWithID) {
            ((SharedObjectWithID)foundObj).setUniqueIdentifier(this.getFreshId());
        }
        tab[index] = new Entry(foundObj, tab[index]);
        ++this.nbAdd;
        int n = index;
        this.tableSize[n] = this.tableSize[n] + 1;
        return foundObj;
    }

    private int getFreshId() {
        block2: {
            if (this.currentId < this.usedId[this.indexId]) {
                return this.currentId++;
            }
            do {
                ++this.indexId;
                if (this.indexId >= this.usedId.length) break block2;
            } while (++this.currentId >= this.usedId[this.indexId]);
            return this.currentId++;
        }
        this.regenerate();
        return this.getFreshId();
    }

    private void regenerate() {
        ++this.nbIdRegeneration;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.table.length) {
            Entry e2 = this.table[i];
            while (e2 != null) {
                if (e2.get() instanceof SharedObjectWithID) {
                    list.add(new Integer(((SharedObjectWithID)e2.get()).getUniqueIdentifier()));
                }
                e2 = e2.next;
            }
            ++i;
        }
        list.add(new Integer(this.maxId));
        int newSize = list.size();
        if (newSize >= this.maxId - this.minId) {
            System.exit(1);
        }
        this.usedId = new int[newSize];
        int i2 = 0;
        while (i2 < newSize) {
            this.usedId[i2] = (Integer)list.get(i2);
            ++i2;
        }
        Arrays.sort(this.usedId);
        this.indexId = 0;
        this.currentId = this.minId;
    }

    private static class Entry
    extends WeakReference {
        protected Entry next;
        protected int value = 0;

        public Entry(Object object, Entry next) {
            super(object);
            this.next = next;
        }
    }
}

