/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.ModuleExtractorPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    public static final Logger log = Logger.getLogger(AbstractModuleExtractor.class.getName());
    private Set<OWLAxiom> additions = new HashSet<OWLAxiom>();
    private Set<OWLClass> allClasses = new HashSet<OWLClass>();
    private OWLOntology axiomOntology = null;
    private MultiValueMap<OWLAxiom, OWLEntity> axiomEntities = new MultiValueMap();
    private Set<OWLAxiom> deletions = new HashSet<OWLAxiom>();
    protected MultiValueMap<OWLEntity, OWLAxiom> entityAxioms = new MultiValueMap();
    private LocalityEvaluator localityEvaluator = null;
    protected MultiValueMap<OWLEntity, OWLEntity> modules = null;
    private boolean nonLocalAxioms = false;
    private Timers timers = new Timers();
    private static final String MODULE_EXTRACTOR_AXIOMS_FILE_NAME = "ModuleExtractorAxioms";
    private static final String MODULE_EXTRACTOR_MODULES_FILE_NAME = "ModuleExtractorModules";

    public AbstractModuleExtractor() {
        this((LocalityEvaluator)new SyntacticLocalityEvaluator(LocalityClass.BOTTOM_BOTTOM));
    }

    public AbstractModuleExtractor(LocalityEvaluator localityEvaluator) {
        this.localityEvaluator = localityEvaluator;
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (this.axiomEntities.containsKey(axiom)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding " + axiom);
        }
        this.deletions.remove(axiom);
        this.additions.add(axiom);
    }

    @Override
    public boolean canUpdate() {
        return this.modules != null && !this.nonLocalAxioms;
    }

    private void checkNonLocalAxiom(OWLAxiom axiom) {
        if (!axiom.isLogicalAxiom()) {
            return;
        }
        if (this.canUpdate() && !this.isLocal(axiom, Collections.<OWLEntity>emptySet())) {
            log.warning("*** Non-local axiom: " + axiom);
            this.nonLocalAxioms = true;
        }
    }

    @Override
    public void deleteAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (!this.axiomEntities.containsKey(axiom)) {
            if (this.additions.remove(axiom) && log.isLoggable(Level.FINE)) {
                log.fine("Deleted axiom from add queue before processing " + axiom);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting " + axiom);
        }
        this.additions.remove(axiom);
        this.deletions.add(axiom);
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this.modules;
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> extractModules() {
        Timer timer = this.timers.startTimer("extractModules");
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
        this.extractModuleSignatures(this.allClasses);
        timer.stop();
        return this.modules;
    }

    protected abstract void extractModuleSignatures(Set<? extends OWLEntity> var1);

    private Set<OWLEntity> getAffectedRoots(OWLAxiom axiom, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<OWLEntity> roots = new HashSet<OWLEntity>();
        HashSet<TaxonomyNode<OWLClass>> visited = new HashSet<TaxonomyNode<OWLClass>>();
        visited.add(taxonomy.getBottom());
        this.getAffectedRoots(axiom, taxonomy.getTop(), roots, add, visited);
        if (!add && roots.isEmpty()) {
            for (OWLClass unsat : taxonomy.getEquivalents(OWL.Nothing)) {
                Set signature = (Set)this.modules.get(unsat);
                if (signature == null || !signature.containsAll(this.getSignature(axiom))) continue;
                roots.add((OWLEntity)unsat);
            }
        }
        return roots;
    }

    private void getAffectedRoots(OWLAxiom axiom, TaxonomyNode<OWLClass> node, Set<OWLEntity> effects, boolean add, Set<TaxonomyNode<OWLClass>> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        OWLEntity entity = (OWLEntity)node.getName();
        Set signature = (Set)this.modules.get(entity);
        boolean outdated = false;
        if (signature == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removed entity " + entity);
            }
        } else {
            outdated = add ? !this.isLocal(axiom, signature) : signature.containsAll(this.getSignature(axiom));
        }
        if (outdated) {
            effects.addAll(node.getEquivalents());
        } else {
            for (TaxonomyNode<OWLClass> next : node.getSubs()) {
                this.getAffectedRoots(axiom, next, effects, add, visited);
            }
        }
    }

    @Override
    public Set<OWLAxiom> getAxioms(OWLEntity entity) {
        Set<OWLAxiom> axioms = (Set<OWLAxiom>)this.entityAxioms.get(entity);
        if (axioms == null) {
            axioms = Collections.emptySet();
        }
        return axioms;
    }

    @Override
    public OWLOntology getModule(OWLEntity entity) {
        return this.getModuleFromSignature((Set)this.modules.get(entity));
    }

    protected Set<OWLAxiom> getModuleAxioms(Set<OWLEntity> signature) {
        HashSet referenced = new HashSet();
        HashSet<OWLEntity> augmentedSig = new HashSet<OWLEntity>(signature);
        augmentedSig.add((OWLEntity)OWL.Thing);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> candidates = new HashSet<OWLAxiom>();
        for (OWLEntity e2 : signature) {
            candidates.addAll(this.getAxioms(e2));
        }
        for (OWLAxiom axiom : candidates) {
            Set sigAxiom = (Set)this.axiomEntities.get(axiom);
            if (!augmentedSig.containsAll(sigAxiom) || this.isLocal(axiom, signature)) continue;
            axioms.add(axiom);
            referenced.addAll(sigAxiom);
        }
        HashSet<OWLEntity> notReferenced = new HashSet<OWLEntity>(signature);
        notReferenced.removeAll(referenced);
        for (OWLEntity e3 : notReferenced) {
            if (this.entityAxioms.get(e3) == null) continue;
            axioms.add((OWLAxiom)OWL.declaration(e3));
        }
        return axioms;
    }

    @Override
    public OWLOntology getModuleFromSignature(Set<OWLEntity> signature) {
        Set<OWLAxiom> moduleAxioms = this.getModuleAxioms(signature);
        return OWL.Ontology(moduleAxioms);
    }

    protected Set<OWLEntity> getSignature(OWLAxiom axiom) {
        return (Set)this.axiomEntities.get(axiom);
    }

    @Override
    public boolean isChanged() {
        return !this.additions.isEmpty() || !this.deletions.isEmpty() || this.nonLocalAxioms;
    }

    protected boolean isLocal(OWLAxiom axiom, Set<OWLEntity> signature) {
        return this.localityEvaluator.isLocal(axiom, signature);
    }

    @Override
    public void addOntologies(Set<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            this.addOntology(ontology);
        }
    }

    @Override
    public void addOntology(OWLOntology ontology) {
        for (OWLAxiom axiom : ontology.getAxioms()) {
            this.addAxiom(axiom);
        }
    }

    private void processAdditions() {
        for (OWLAxiom axiom : this.additions) {
            Set<OWLEntity> signature = OntologyUtils.getSignature(axiom);
            this.axiomEntities.put(axiom, signature);
            for (OWLEntity entity : signature) {
                this.entityAxioms.add(entity, axiom);
                if (!(entity instanceof OWLClass)) continue;
                OWLClass cls = (OWLClass)entity;
                this.allClasses.add(cls);
            }
        }
    }

    private void processDeletions() {
        for (OWLAxiom axiom : this.deletions) {
            Set entities = (Set)this.axiomEntities.remove(axiom);
            for (OWLEntity entity : entities) {
                this.entityAxioms.remove(entity, axiom);
                if (this.entityAxioms.containsKey(entity)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove " + entity + " which is not mentioned anymore");
                }
                this.allClasses.remove(entity);
                this.modules.remove(entity);
            }
        }
    }

    private Set<OWLEntity> updateEffectedModules(Set<OWLAxiom> axioms, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<Object> affectedRoots = new HashSet<Object>();
        HashSet<Object> affected = new HashSet<Object>();
        HashSet<OWLEntity> effects = new HashSet<OWLEntity>();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Update modules for " + (add ? "additions" : "deletions"));
        }
        affectedRoots.addAll(this.allClasses);
        affectedRoots.removeAll(this.modules.keySet());
        for (OWLAxiom oWLAxiom : axioms) {
            affectedRoots.addAll(this.getAffectedRoots(oWLAxiom, taxonomy, add));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected roots " + affectedRoots);
        }
        for (OWLEntity oWLEntity : affectedRoots) {
            affected.add(oWLEntity);
            if (!(oWLEntity instanceof OWLClass) || !taxonomy.contains((OWLClass)oWLEntity)) continue;
            affected.addAll(taxonomy.getFlattenedSubs((OWLClass)oWLEntity, false));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected entities " + affected);
        }
        for (OWLEntity oWLEntity : affected) {
            this.modules.remove(oWLEntity);
        }
        this.extractModuleSignatures(affected);
        for (OWLEntity oWLEntity : affected) {
            Set module = (Set)this.modules.get(oWLEntity);
            if (module == null) {
                String msg = "No module for " + oWLEntity;
                log.log(Level.SEVERE, msg, new RuntimeException(msg));
            }
            effects.addAll(module);
        }
        return effects;
    }

    @Override
    public Set<OWLEntity> updateModules(Taxonomy<OWLClass> taxonomy, boolean add) throws UnsupportedOperationException {
        Timer timer = this.timers.startTimer("updateModules");
        if (!this.canUpdate()) {
            throw new UnsupportedOperationException("Modules cannot be updated!");
        }
        Set<OWLEntity> effects = null;
        if (add) {
            this.processAdditions();
            effects = this.updateEffectedModules(this.additions, taxonomy, add);
            this.additions.clear();
        } else {
            effects = this.updateEffectedModules(this.deletions, taxonomy, add);
            this.processDeletions();
            this.deletions.clear();
        }
        timer.stop();
        return effects;
    }

    @Override
    public Timers getTimers() {
        return this.timers;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return Collections.unmodifiableSet(this.axiomEntities.keySet());
    }

    @Override
    public OWLOntology getAxiomOntology() {
        if (null == this.axiomOntology) {
            this.axiomOntology = OWL.Ontology(this.axiomEntities.keySet());
        }
        return this.axiomOntology;
    }

    @Override
    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this.entityAxioms.keySet());
    }

    public void resetModules() {
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
    }

    @Override
    public void save(ZipOutputStream outputStream) throws IOException, IllegalStateException {
        if (!this.additions.isEmpty() || !this.deletions.isEmpty()) {
            throw new IllegalStateException("The module extractor contains unapplied changes to the modules, and therefore cannot be saved.");
        }
        ZipEntry axiomsEntry = new ZipEntry(MODULE_EXTRACTOR_AXIOMS_FILE_NAME);
        outputStream.putNextEntry(axiomsEntry);
        ModuleExtractorPersistence.saveAxioms(this.axiomEntities.keySet(), new UncloseableOutputStream(outputStream));
        ZipEntry modulesEntry = new ZipEntry(MODULE_EXTRACTOR_MODULES_FILE_NAME);
        outputStream.putNextEntry(modulesEntry);
        ModuleExtractorPersistence.saveModules(this.modules, new UncloseableOutputStream(outputStream));
        outputStream.flush();
    }

    @Override
    public void load(ZipInputStream inputStream) throws IOException, IllegalArgumentException {
        this.resetModules();
        ZipEntry zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_AXIOMS_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_AXIOMS_FILE_NAME));
        }
        this.axiomOntology = ModuleExtractorPersistence.loadAxiomOntology(inputStream);
        Set axioms = this.axiomOntology.getAxioms();
        this.additions.addAll(axioms);
        this.processAdditions();
        this.additions.clear();
        zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_MODULES_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_MODULES_FILE_NAME));
        }
        this.modules = ModuleExtractorPersistence.loadModules(inputStream);
    }
}

