/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.datetime;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.datetime.RestrictedTimelineDatatype;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTimelineDatatype
extends AbstractBaseDatatype<XMLGregorianCalendar> {
    private final QName schemaType;

    public AbstractTimelineDatatype(ATermAppl name, QName schemaType) {
        super(name);
        this.schemaType = schemaType;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        XMLGregorianCalendar c = this.getValue(input);
        String canonicalForm = c.toXMLFormat();
        if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)value;
            if (!this.schemaType.equals(c.getXMLSchemaType())) {
                throw new IllegalArgumentException();
            }
            return ATermUtils.makeTypedLiteral(c.toXMLFormat(), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public XMLGregorianCalendar getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            XMLGregorianCalendar c = RestrictedTimelineDatatype.getDatatypeFactory().newXMLGregorianCalendar(lexicalForm);
            if (!this.schemaType.equals(c.getXMLSchemaType())) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return c;
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
        catch (IllegalStateException e3) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

