/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEDoubleType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDatatype;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDouble
extends AbstractBaseDatatype<Double> {
    private static final XSDDouble instance = new XSDDouble();
    private final RestrictedFloatingPointDatatype<Double> dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double"));
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Double f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printDouble((double)f);
        if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Double) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble((double)((Double)value)), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            return DatatypeConverter.parseDouble((String)lexicalForm);
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

