/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.format;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;

public class SimpleLintFormat
implements LintFormat {
    private static final int CLASSES_LIMIT = 6;

    public String format(Lint lint) {
        Set<OWLClass> participatingClasses = lint.getParticipatingClasses();
        Set<OWLClassAxiom> participatingAxioms = lint.getParticipatingAxioms();
        if ((participatingClasses == null || participatingClasses.isEmpty()) && (participatingAxioms == null || participatingAxioms.isEmpty())) {
            return "";
        }
        Severity severity = lint.getSeverity();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(" - ");
        if (severity != null) {
            strBuilder.append(severity).append(' ');
        }
        if (participatingClasses != null && !participatingClasses.isEmpty()) {
            Iterator<OWLClass> it = participatingClasses.iterator();
            for (int i = 0; it.hasNext() && i < 6; ++i) {
                OWLClass participatingClass = it.next();
                strBuilder.append(participatingClass).append(' ');
            }
            if (participatingClasses.size() > 6) {
                strBuilder.append("... and ");
                strBuilder.append(participatingClasses.size() - 6);
                strBuilder.append(" more.");
            }
            strBuilder.append('\n');
        } else if (participatingAxioms != null && !participatingAxioms.isEmpty()) {
            for (OWLClassAxiom axiom : participatingAxioms) {
                strBuilder.append(axiom).append('\n');
            }
        }
        return strBuilder.toString();
    }
}

