/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryExecutionBase;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutionFactory {
    private QueryExecutionFactory() {
    }

    public static QueryExecution create(Query query2) {
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.make(query2);
    }

    public static QueryExecution create(String queryStr) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr));
    }

    public static QueryExecution create(String queryStr, Syntax syntax) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax));
    }

    public static QueryExecution create(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset);
    }

    public static QueryExecution create(String queryStr, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr), dataset);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.make(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset);
    }

    public static QueryExecution create(Query query2, FileManager fm) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (fm != null) {
            qe.setFileManager(fm);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), fm);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, FileManager fm) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), fm);
    }

    public static QueryExecution create(Query query2, Model model) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.make(query2, new DatasetImpl(model));
    }

    public static QueryExecution create(String queryStr, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model);
    }

    public static QueryExecution create(String queryStr, Syntax lang, Model model) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, lang), model);
    }

    public static QueryExecution create(Query query2, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), initialBinding);
    }

    public static QueryExecution create(Query query2, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(query2, (Dataset)new DataSourceImpl(model), initialBinding);
    }

    public static QueryExecution create(String queryStr, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        QueryExecutionFactory.checkArg(model);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), model, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Model model, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), model, initialBinding);
    }

    public static QueryExecution create(Query query2, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(query2);
        QueryExecution qe = QueryExecutionFactory.make(query2, dataset);
        if (initialBinding != null) {
            qe.setInitialBinding(initialBinding);
        }
        return qe;
    }

    public static QueryExecution create(String queryStr, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr), dataset, initialBinding);
    }

    public static QueryExecution create(String queryStr, Syntax syntax, Dataset dataset, QuerySolution initialBinding) {
        QueryExecutionFactory.checkArg(queryStr);
        return QueryExecutionFactory.create(QueryExecutionFactory.makeQuery(queryStr, syntax), dataset, initialBinding);
    }

    public static QueryExecution sparqlService(String service, String query2) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2));
    }

    public static QueryExecution sparqlService(String service, String query2, String defaultGraph) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2), defaultGraph);
    }

    public static QueryExecution sparqlService(String service, String query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.sparqlService(service, QueryFactory.create(query2), defaultGraphURIs, namedGraphURIs);
    }

    public static QueryExecution sparqlService(String service, Query query2) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        return QueryExecutionFactory.createServiceRequest(service, query2);
    }

    public static QueryExecution sparqlService(String service, Query query2, List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query2);
        if (defaultGraphURIs != null) {
            qe.setDefaultGraphURIs(defaultGraphURIs);
        }
        if (namedGraphURIs != null) {
            qe.setNamedGraphURIs(namedGraphURIs);
        }
        return qe;
    }

    public static QueryExecution sparqlService(String service, Query query2, String defaultGraph) {
        QueryExecutionFactory.checkNotNull(service, "URL for service is null");
        QueryExecutionFactory.checkArg(query2);
        QueryEngineHTTP qe = QueryExecutionFactory.createServiceRequest(service, query2);
        qe.addDefaultGraph(defaultGraph);
        return qe;
    }

    public static QueryEngineHTTP createServiceRequest(String service, Query query2) {
        QueryEngineHTTP qe = new QueryEngineHTTP(service, query2);
        return qe;
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input, Context context) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, context);
    }

    public static Plan createPlan(String queryStr, Graph graph) {
        return QueryExecutionFactory.createPlan(QueryFactory.create(queryStr), graph);
    }

    public static Plan createPlan(String queryStr, DatasetGraph dataset) {
        return QueryExecutionFactory.createPlan(QueryFactory.create(queryStr), dataset);
    }

    public static Plan createPlan(Query query2, Graph graph) {
        return QueryExecutionFactory.makePlan(query2, new DataSourceGraphImpl(graph), null, null);
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset) {
        return QueryExecutionFactory.makePlan(query2, dataset, null, null);
    }

    public static Plan createPlan(Query query2, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.makePlan(query2, dataset, input, null);
    }

    public static Plan createPlan(Element pattern, Graph graph) {
        return QueryExecutionFactory.createPlan(QueryExecutionFactory.toQuery(pattern), graph);
    }

    public static Plan createPlan(Element pattern, DatasetGraph dataset) {
        return QueryExecutionFactory.createPlan(QueryExecutionFactory.toQuery(pattern), dataset, null);
    }

    public static Plan createPlan(Element pattern, DatasetGraph dataset, Binding input) {
        return QueryExecutionFactory.createPlan(QueryExecutionFactory.toQuery(pattern), dataset, input);
    }

    private static Query toQuery(Element pattern) {
        Query query2 = QueryFactory.make();
        query2.setQueryPattern(pattern);
        query2.setQuerySelectType();
        query2.setQueryResultStar(true);
        return query2;
    }

    private static Plan makePlan(Query query2, DatasetGraph dataset, Binding input, Context context) {
        QueryEngineFactory f;
        if (context == null) {
            context = new Context(ARQ.getContext());
        }
        if (input == null) {
            input = BindingRoot.create();
        }
        if ((f = QueryExecutionFactory.findFactory(query2, dataset, context)) == null) {
            return null;
        }
        return f.create(query2, dataset, input, context);
    }

    private static Query makeQuery(String queryStr) {
        return QueryFactory.create(queryStr);
    }

    private static Query makeQuery(String queryStr, Syntax syntax) {
        return QueryFactory.create(queryStr, syntax);
    }

    private static QueryExecution make(Query query2) {
        return QueryExecutionFactory.make(query2, null);
    }

    private static QueryExecution make(Query query2, Dataset dataset) {
        return QueryExecutionFactory.make(query2, dataset, null);
    }

    private static QueryExecution make(Query query2, Dataset dataset, Context context) {
        QueryEngineFactory f;
        query2.validate();
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        DatasetGraph dsg = null;
        if (dataset != null) {
            dsg = dataset.asDatasetGraph();
        }
        if ((f = QueryExecutionFactory.findFactory(query2, dsg, context)) == null) {
            ALog.warn(QueryExecutionFactory.class, "Failed to find a QueryEngineFactory for query: " + query2);
            return null;
        }
        return new QueryExecutionBase(query2, dataset, context, f);
    }

    private static QueryEngineFactory findFactory(Query query2, DatasetGraph dataset, Context context) {
        return QueryEngineRegistry.get().find(query2, dataset, context);
    }

    private static void checkNotNull(Object obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkArg(Model model) {
        QueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String queryStr) {
        QueryExecutionFactory.checkNotNull(queryStr, "Query string is null");
    }

    private static void checkArg(Query query2) {
        QueryExecutionFactory.checkNotNull(query2, "Query is null");
    }
}

