/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletVisitor
implements OWLObjectVisitor {
    private static final long serialVersionUID = 8211773146996997500L;
    public static Logger log = Logger.getLogger(PelletVisitor.class.getName());
    private KnowledgeBase kb;
    private ATermAppl term;
    private AtomDObject swrlDObject;
    private AtomIObject swrlIObject;
    private RuleAtom swrlAtom;
    private ProgressMonitor monitor;
    private boolean addAxioms;
    private boolean reloadRequired;
    private Set<OWLAxiom> unsupportedAxioms;
    private MultiValueMap<OWLObjectProperty, OWLObjectPropertyAxiom> compositePropertyAxioms;
    private Set<OWLObjectProperty> simpleProperties;

    public PelletVisitor(KnowledgeBase kb) {
        this.kb = kb;
        this.clear();
    }

    public void clear() {
        this.unsupportedAxioms = new HashSet<OWLAxiom>();
        this.compositePropertyAxioms = new MultiValueMap();
        this.simpleProperties = new HashSet<OWLObjectProperty>();
    }

    private void addUnsupportedAxiom(OWLAxiom axiom) {
        if (!PelletOptions.IGNORE_UNSUPPORTED_AXIOMS) {
            throw new UnsupportedFeatureException("Axiom: " + axiom);
        }
        if (this.unsupportedAxioms.add(axiom)) {
            log.warning("Ignoring unsupported axiom: " + axiom);
        }
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return Collections.unmodifiableSet(this.unsupportedAxioms);
    }

    private OWLObjectProperty getNamedProperty(OWLObjectPropertyExpression ope) {
        if (ope.isAnonymous()) {
            return this.getNamedProperty(((OWLObjectPropertyInverse)ope).getInverse());
        }
        return ope.asOWLObjectProperty();
    }

    private void addSimpleProperty(OWLObjectPropertyExpression ope) {
        if (!this.addAxioms) {
            return;
        }
        OWLObjectProperty prop = this.getNamedProperty(ope);
        this.simpleProperties.add(prop);
        prop.accept((OWLObjectVisitor)this);
        Role role = this.kb.getRBox().getRole(this.term);
        role.setForceSimple(true);
    }

    void verify() {
        for (Map.Entry entry : this.compositePropertyAxioms.entrySet()) {
            OWLObjectProperty nonSimpleProperty = (OWLObjectProperty)entry.getKey();
            if (!this.simpleProperties.contains(nonSimpleProperty)) continue;
            Set axioms = (Set)entry.getValue();
            for (OWLObjectPropertyAxiom axiom : axioms) {
                this.addUnsupportedAxiom((OWLAxiom)axiom);
            }
            ATermAppl name = ATermUtils.makeTermAppl(nonSimpleProperty.getURI().toString());
            Role role = this.kb.getRBox().getRole(name);
            role.removeSubRoleChains();
        }
    }

    public void setAddAxiom(boolean addAxioms) {
        this.addAxioms = addAxioms;
    }

    public boolean isReloadRequired() {
        return this.reloadRequired;
    }

    public ATermAppl result() {
        return this.term;
    }

    public void reset() {
        this.term = null;
        this.reloadRequired = false;
    }

    public void visit(OWLClass c) {
        this.term = c.isOWLThing() ? ATermUtils.TOP : (c.isOWLNothing() ? ATermUtils.BOTTOM : ATermUtils.makeTermAppl(c.getURI().toString()));
        if (this.addAxioms) {
            this.kb.addClass(this.term);
        }
    }

    public void visit(OWLIndividual ind) {
        this.term = ind.isAnonymous() ? ATermUtils.makeBnode(ind.getURI().toString()) : ATermUtils.makeTermAppl(ind.getURI().toString());
        if (this.addAxioms) {
            this.kb.addIndividual(this.term);
        }
    }

    public void visit(OWLObjectProperty prop) {
        if (prop.equals(OWL.topObjectProperty)) {
            this.term = ATermUtils.TOP_OBJECT_PROPERTY;
        } else if (prop.equals(OWL.bottomObjectProperty)) {
            this.term = ATermUtils.BOTTOM_OBJECT_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(prop.getURI().toString());
            if (this.addAxioms) {
                this.kb.addObjectProperty(this.term);
            }
        }
    }

    public void visit(OWLObjectPropertyInverse propInv) {
        propInv.getInverse().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeInv(p);
    }

    public void visit(OWLDataProperty prop) {
        if (prop.equals(OWL.topDataProperty)) {
            this.term = ATermUtils.TOP_DATA_PROPERTY;
        } else if (prop.equals(OWL.bottomDataProperty)) {
            this.term = ATermUtils.BOTTOM_DATA_PROPERTY;
        } else {
            this.term = ATermUtils.makeTermAppl(prop.getURI().toString());
            if (this.addAxioms) {
                this.kb.addDatatypeProperty(this.term);
            }
        }
    }

    public void visit(OWLTypedConstant constant) {
        String lexicalValue = constant.getLiteral();
        constant.getDataType().accept((OWLObjectVisitor)this);
        ATermAppl datatype = this.term;
        this.term = ATermUtils.makeTypedLiteral(lexicalValue, datatype.toString());
    }

    public void visit(OWLUntypedConstant constant) {
        String lexicalValue = constant.getLiteral();
        String lang = constant.getLang();
        this.term = lang != null ? ATermUtils.makePlainLiteral(lexicalValue, lang) : ATermUtils.makePlainLiteral(lexicalValue);
    }

    public void visit(OWLDataType ocdt) {
        this.term = ATermUtils.makeTermAppl(ocdt.getURI().toString());
        this.kb.addDatatype(this.term);
    }

    public void visit(OWLObjectIntersectionOf and) {
        Set operands = and.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDescription desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeAnd(setOfTerms);
    }

    public void visit(OWLObjectUnionOf or) {
        Set operands = or.getOperands();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLDescription desc : operands) {
            desc.accept((OWLObjectVisitor)this);
            terms[size++] = this.term;
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectComplementOf not2) {
        OWLDescription desc = not2.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot(this.term);
    }

    public void visit(OWLObjectOneOf enumeration) {
        Set operands = enumeration.getIndividuals();
        ATerm[] terms = new ATerm[operands.size()];
        int size = 0;
        for (OWLIndividual ind : operands) {
            ind.accept((OWLObjectVisitor)this);
            terms[size++] = ATermUtils.makeValue(this.term);
        }
        ATermList setOfTerms = size > 0 ? ATermUtils.toSet(terms, size) : ATermUtils.EMPTY_LIST;
        this.term = ATermUtils.makeOr(setOfTerms);
    }

    public void visit(OWLObjectSomeRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLObjectAllRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLObjectValueRestriction restriction) {
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        this.term = ATermUtils.makeHasValue(p, ind);
    }

    public void visit(OWLObjectExactCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLObjectMaxCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLObjectMinCardinalityRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDescription)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataExactCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeCard(p, n, desc);
    }

    public void visit(OWLDataMaxCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMax((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLDataMinCardinalityRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        int n = restriction.getCardinality();
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl desc = this.term;
        this.term = ATermUtils.makeMin((ATerm)p, n, (ATerm)desc);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set descriptions = axiom.getDescriptions();
        int size = descriptions.size();
        if (size > 1) {
            ATermAppl[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLDescription desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            Arrays.sort(terms, 0, size, Comparators.termComparator);
            ATermAppl c1 = terms[0];
            for (int i = 1; i < terms.length; ++i) {
                ATermAppl c2 = terms[i];
                if (this.addAxioms) {
                    this.kb.addEquivalentClass(c1, c2);
                    continue;
                }
                ATermAppl sameAxiom = ATermUtils.makeEqClasses(c1, c2);
                boolean bl = this.reloadRequired = !this.kb.removeAxiom(sameAxiom);
                if (!this.reloadRequired) continue;
                return;
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        Set descriptions = axiom.getDescriptions();
        int size = descriptions.size();
        if (size > 1) {
            ATerm[] terms = new ATermAppl[size];
            int index = 0;
            for (OWLDescription desc : descriptions) {
                desc.accept((OWLObjectVisitor)this);
                terms[index++] = this.term;
            }
            ATermList list = ATermUtils.toSet(terms, size);
            if (this.addAxioms) {
                this.kb.addDisjointClasses(list);
            } else {
                this.reloadRequired = !this.kb.removeAxiom(ATermUtils.makeDisjoints(list));
            }
        }
    }

    public void visit(OWLSubClassAxiom axiom) {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        ATermAppl c1 = this.term;
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        ATermAppl c2 = this.term;
        if (this.addAxioms) {
            this.kb.addSubClass(c1, c2);
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub(c1, c2);
            this.reloadRequired = !this.kb.removeAxiom(subAxiom);
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int size = axiom.getProperties().size();
        OWLObjectPropertyExpression[] props = new OWLObjectPropertyExpression[size];
        axiom.getProperties().toArray(props);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                props[i].accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                props[j].accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        int size = axiom.getProperties().size();
        OWLDataPropertyExpression[] props = new OWLDataPropertyExpression[size];
        axiom.getProperties().toArray(props);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                props[i].accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                props[j].accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addEquivalentProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        if (axiom.getIndividuals().size() == 2) {
            Iterator iter = axiom.getIndividuals().iterator();
            ((OWLIndividual)iter.next()).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            ((OWLIndividual)iter.next()).accept((OWLObjectVisitor)this);
            ATermAppl i2 = this.term;
            this.kb.addDifferent(i1, i2);
        } else {
            ATerm[] terms = new ATermAppl[axiom.getIndividuals().size()];
            int i = 0;
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept((OWLObjectVisitor)this);
                terms[i++] = this.term;
            }
            this.kb.addAllDifferent(ATermUtils.makeList(terms));
        }
    }

    public void visit(OWLSameIndividualsAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Iterator eqs = axiom.getIndividuals().iterator();
        if (eqs.hasNext()) {
            ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
            ATermAppl i1 = this.term;
            while (eqs.hasNext()) {
                ((OWLIndividual)eqs.next()).accept((OWLObjectVisitor)this);
                ATermAppl i2 = this.term;
                this.kb.addSame(i1, i2);
            }
        }
    }

    public void visit(OWLDataOneOf enumeration) {
        ATermList ops = ATermUtils.EMPTY_LIST;
        for (OWLConstant value : enumeration.getValues()) {
            value.accept((OWLObjectVisitor)this);
            ops = ops.insert(ATermUtils.makeValue(this.result()));
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLDataAllRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues(p, c);
    }

    public void visit(OWLDataSomeRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)restriction.getFiller()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues(p, c);
    }

    public void visit(OWLDataValueRestriction restriction) {
        ((OWLDataPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLConstant)restriction.getValue()).accept((OWLObjectVisitor)this);
        ATermAppl dv = this.term;
        this.term = ATermUtils.makeHasValue(p, dv);
    }

    public void visit(OWLOntology ont) {
        for (OWLAxiom axiom : ont.getAxioms()) {
            this.monitor.incrementProgress();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Load " + axiom);
            }
            axiom.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLObjectSelfRestriction restriction) {
        this.addSimpleProperty((OWLObjectPropertyExpression)restriction.getProperty());
        ((OWLObjectPropertyExpression)restriction.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.term = ATermUtils.makeSelf(p);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] disjs = axiom.getProperties().toArray();
        for (int i = 0; i < disjs.length - 1; ++i) {
            OWLObjectProperty prop1 = (OWLObjectProperty)disjs[i];
            this.addSimpleProperty((OWLObjectPropertyExpression)prop1);
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLObjectProperty prop2 = (OWLObjectProperty)disjs[j];
                this.addSimpleProperty((OWLObjectPropertyExpression)prop2);
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        Object[] disjs = axiom.getProperties().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDataProperty desc1 = (OWLDataProperty)disjs[i];
                OWLDataProperty desc2 = (OWLDataProperty)disjs[j];
                desc1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                desc2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                this.kb.addDisjointProperty(p1, p2);
            }
        }
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty(axiom.getSuperProperty()), (OWLObjectPropertyAxiom)axiom);
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl prop = this.result();
        List propChain = axiom.getPropertyChain();
        ATermList chain = ATermUtils.EMPTY_LIST;
        for (int i = propChain.size() - 1; i >= 0; --i) {
            ((OWLObjectPropertyExpression)propChain.get(i)).accept((OWLObjectVisitor)this);
            chain = chain.insert(this.result());
        }
        this.kb.addSubProperty(chain, prop);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        ATermList classes = ATermUtils.EMPTY_LIST;
        for (OWLDescription desc : axiom.getDescriptions()) {
            desc.accept((OWLObjectVisitor)this);
            classes = classes.insert(this.result());
        }
        this.kb.addDisjointClasses(classes);
        this.kb.addEquivalentClass(c, ATermUtils.makeOr(classes));
    }

    public void visit(OWLDataComplementOf node) {
        node.getDataRange().accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot(this.term);
    }

    public void visit(OWLDataRangeRestriction node) {
        node.getDataRange().accept((OWLObjectVisitor)this);
        ATermAppl baseDatatype = this.term;
        ArrayList<ATermAppl> restrictions = new ArrayList<ATermAppl>();
        for (OWLDataRangeFacetRestriction restr : node.getFacetRestrictions()) {
            restr.accept((OWLObjectVisitor)this);
            if (this.term != null) {
                restrictions.add(this.term);
                continue;
            }
            log.warning("Unrecognized facet " + restr.getFacet());
            return;
        }
        if (restrictions.isEmpty()) {
            log.warning("A data range is defined without facet restrictions " + node);
        } else {
            this.term = ATermUtils.makeRestrictedDatatype(baseDatatype, restrictions.toArray(new ATermAppl[restrictions.size()]));
        }
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addAsymmetricProperty(p);
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addReflexiveProperty(p);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addDomain(p, c);
        } else {
            this.reloadRequired = !this.kb.removeDomain(p, c);
        }
    }

    public void visit(OWLImportsDeclaration axiom) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring imports declaration: " + axiom);
        }
    }

    public void visit(OWLAxiomAnnotationAxiom axiom) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring axiom annotation: " + axiom);
        }
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        axiom.getDomain().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addDomain(p, c);
        } else {
            this.reloadRequired = !this.kb.removeDomain(p, c);
        }
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLConstant)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addNegatedPropertyValue(p, s, o);
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDescription)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addRange(p, c);
        } else {
            this.reloadRequired = !this.kb.removeRange(p, c);
        }
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLObjectSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sub = this.term;
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl sup = this.term;
        this.kb.addSubProperty(sub, sup);
    }

    public void visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLEntityAnnotationAxiom axiom) {
        ((OWLEntity)axiom.getSubject()).accept((OWLObjectVisitor)this);
        ATermAppl s = this.term;
        URI uri = axiom.getAnnotation().getAnnotationURI();
        ATermAppl p = ATermUtils.makeTermAppl(uri.toASCIIString());
        this.kb.addAnnotationProperty(p);
        axiom.getAnnotation().accept((OWLObjectVisitor)this);
        ATermAppl o = this.term;
        this.kb.addAnnotation(s, p, o);
    }

    public void visit(OWLOntologyAnnotationAxiom axiom) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ignoring ontology annotation: " + axiom);
        }
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addSymmetricProperty(p);
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        if (this.addAxioms) {
            this.kb.addRange(p, c);
        } else {
            this.reloadRequired = !this.kb.removeRange(p, c);
        }
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addFunctionalProperty(p);
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        axiom.getDescription().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.kb.addType(ind, c);
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getSubject().accept((OWLObjectVisitor)this);
        ATermAppl subj = this.term;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl pred = this.term;
        ((OWLConstant)axiom.getObject()).accept((OWLObjectVisitor)this);
        ATermAppl obj = this.term;
        this.kb.addPropertyValue(pred, subj, obj);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.compositePropertyAxioms.add(this.getNamedProperty((OWLObjectPropertyExpression)axiom.getProperty()), (OWLObjectPropertyAxiom)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addTransitiveProperty(p);
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addIrreflexiveProperty(p);
    }

    public void visit(OWLDataSubPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addSubProperty(p1, p2);
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        this.addSimpleProperty((OWLObjectPropertyExpression)axiom.getProperty());
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        this.kb.addInverseFunctionalProperty(p);
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        this.kb.addInverseProperty(p1, p2);
    }

    public void visit(OWLDataRangeFacetRestriction node) {
        Facet facet = Facet.Registry.get(ATermUtils.makeTermAppl(node.getFacet().getURI().toString()));
        if (facet != null) {
            OWLTypedConstant facetValue = node.getFacetValue();
            facetValue.accept((OWLObjectVisitor)this);
            this.term = ATermUtils.makeFacetRestriction(facet.getName(), this.term);
        }
    }

    public void visit(OWLObjectAnnotation a) {
        ((OWLIndividual)a.getAnnotationValue()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLConstantAnnotation a) {
        ((OWLConstant)a.getAnnotationValue()).accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLRule rule) {
        if (!PelletOptions.DL_SAFE_RULES) {
            return;
        }
        if (!this.addAxioms) {
            this.reloadRequired = true;
            return;
        }
        List<RuleAtom> head = this.parseAtomList(rule.getHead());
        List<RuleAtom> body = this.parseAtomList(rule.getBody());
        if (head == null || body == null) {
            this.addUnsupportedAxiom((OWLAxiom)rule);
            return;
        }
        URI uri = rule.getURI();
        ATermAppl name = uri == null ? null : (rule.isAnonymous() ? ATermUtils.makeBnode(uri.toString()) : ATermUtils.makeTermAppl(uri.toString()));
        Rule pelletRule = new Rule(name, head, body);
        this.kb.addRule(pelletRule);
    }

    private List<RuleAtom> parseAtomList(Set<SWRLAtom> atomList) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        for (SWRLAtom atom : atomList) {
            atom.accept((OWLObjectVisitor)this);
            if (this.swrlAtom == null) {
                return null;
            }
            atoms.add(this.swrlAtom);
        }
        return atoms;
    }

    public void visit(SWRLClassAtom atom) {
        OWLDescription c = (OWLDescription)atom.getPredicate();
        SWRLAtomIObject v = (SWRLAtomIObject)atom.getArgument();
        v.accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        c.accept((OWLObjectVisitor)this);
        this.swrlAtom = new ClassAtom(this.term, subj);
    }

    public void visit(SWRLDataRangeAtom atom) {
        ((OWLDataRange)atom.getPredicate()).accept((OWLObjectVisitor)this);
        ((SWRLAtomDObject)atom.getArgument()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DataRangeAtom(this.term, this.swrlDObject);
    }

    public void visit(SWRLObjectPropertyAtom atom) {
        if (((OWLObjectPropertyExpression)atom.getPredicate()).isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        ((OWLObjectPropertyExpression)atom.getPredicate()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new IndividualPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLDataValuedPropertyAtom atom) {
        if (((OWLDataPropertyExpression)atom.getPredicate()).isAnonymous()) {
            this.swrlAtom = null;
            return;
        }
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomDObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomDObject obj = this.swrlDObject;
        ((OWLDataPropertyExpression)atom.getPredicate()).accept((OWLObjectVisitor)this);
        this.swrlAtom = new DatavaluedPropertyAtom(this.term, subj, obj);
    }

    public void visit(SWRLSameAsAtom atom) {
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new SameIndividualAtom(subj, obj);
    }

    public void visit(SWRLDifferentFromAtom atom) {
        ((SWRLAtomIObject)atom.getFirstArgument()).accept((OWLObjectVisitor)this);
        AtomIObject subj = this.swrlIObject;
        ((SWRLAtomIObject)atom.getSecondArgument()).accept((OWLObjectVisitor)this);
        AtomIObject obj = this.swrlIObject;
        this.swrlAtom = new DifferentIndividualsAtom(subj, obj);
    }

    public void visit(SWRLBuiltInAtom atom) {
        ArrayList<AtomDObject> arguments = new ArrayList<AtomDObject>(atom.getAllArguments().size());
        for (SWRLAtomDObject swrlArg : atom.getArguments()) {
            swrlArg.accept((OWLObjectVisitor)this);
            arguments.add(this.swrlDObject);
        }
        this.swrlAtom = new BuiltInAtom(((SWRLBuiltInsVocabulary)atom.getPredicate()).getURI().toString(), arguments);
    }

    public void visit(SWRLAtomDVariable dvar) {
        this.swrlDObject = new AtomDVariable(dvar.getURI().toString());
    }

    public void visit(SWRLAtomIVariable ivar) {
        this.swrlIObject = new AtomIVariable(ivar.getURI().toString());
    }

    public void visit(SWRLAtomIndividualObject iobj) {
        iobj.getIndividual().accept((OWLObjectVisitor)this);
        this.swrlIObject = new AtomIConstant(this.term);
    }

    public void visit(SWRLAtomConstantObject cons) {
        cons.getConstant().accept((OWLObjectVisitor)this);
        this.swrlDObject = new AtomDConstant(this.term);
    }

    public ProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

