/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLRational;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLReal
extends AbstractBaseDatatype<Number> {
    private static final OWLReal instance = new OWLReal();
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());

    public static OWLReal getInstance() {
        return instance;
    }

    private OWLReal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#real"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(input);
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Rational) {
            return OWLRational.getInstance().getLiteral(value);
        }
        if (value instanceof Number) {
            try {
                return XSDDecimal.getInstance().getLiteral(value);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        throw new InvalidLiteralException(this.getName(), lexicalForm);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

