/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.expressivity;

import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expressivity {
    private boolean hasNegation = false;
    private boolean hasAllValues = false;
    private boolean hasDisjointClasses = false;
    private boolean hasInverse = false;
    private boolean hasFunctionality = false;
    private boolean hasCardinality = false;
    private boolean hasCardinalityQ = false;
    private boolean hasFunctionalityD = false;
    private boolean hasCardinalityD = false;
    private boolean hasTransitivity = false;
    private boolean hasRoleHierarchy = false;
    private boolean hasReflexivity = false;
    private boolean hasIrreflexivity = false;
    private boolean hasDisjointRoles = false;
    private boolean hasAsymmetry = false;
    private boolean hasComplexSubRoles = false;
    private boolean hasDatatype = false;
    private boolean hasUserDefinedDatatype = false;
    private boolean hasKeys = false;
    private boolean hasDomain = false;
    private boolean hasRange = false;
    private boolean hasIndividual = false;
    private Set<ATermAppl> nominals = new HashSet<ATermAppl>();

    public Expressivity() {
    }

    public Expressivity(Expressivity other) {
        this.hasNegation = other.hasNegation;
        this.hasAllValues = other.hasAllValues;
        this.hasDisjointClasses = other.hasDisjointClasses;
        this.hasInverse = other.hasInverse;
        this.hasFunctionality = other.hasFunctionality;
        this.hasCardinality = other.hasCardinality;
        this.hasCardinalityQ = other.hasCardinalityQ;
        this.hasFunctionalityD = other.hasFunctionalityD;
        this.hasCardinalityD = other.hasCardinalityD;
        this.hasTransitivity = other.hasTransitivity;
        this.hasRoleHierarchy = other.hasRoleHierarchy;
        this.hasReflexivity = other.hasReflexivity;
        this.hasIrreflexivity = other.hasIrreflexivity;
        this.hasDisjointRoles = other.hasDisjointRoles;
        this.hasAsymmetry = other.hasAsymmetry;
        this.hasComplexSubRoles = other.hasComplexSubRoles;
        this.hasDatatype = other.hasDatatype;
        this.hasKeys = other.hasKeys;
        this.hasDomain = other.hasDomain;
        this.hasRange = other.hasRange;
        this.hasIndividual = other.hasIndividual;
        this.nominals = new HashSet<ATermAppl>(other.nominals);
    }

    public boolean isEL() {
        return !this.hasNegation && !this.hasAllValues && !this.hasInverse && !this.hasFunctionality && !this.hasCardinality && !this.hasCardinalityQ && !this.hasFunctionalityD && !this.hasCardinalityD && !this.hasIrreflexivity && !this.hasDisjointRoles && !this.hasAsymmetry && !this.hasDatatype && !this.hasKeys && !this.hasIndividual && this.nominals.isEmpty();
    }

    public String toString() {
        String dl = "";
        if (this.isEL()) {
            dl = "EL";
            if (this.hasComplexSubRoles || this.hasReflexivity || this.hasDomain || this.hasRange || this.hasDisjointClasses) {
                dl = dl + "+";
            } else if (this.hasRoleHierarchy) {
                dl = dl + "H";
            }
        } else {
            dl = "AL";
            if (this.hasNegation) {
                dl = "ALC";
            }
            if (this.hasTransitivity) {
                dl = dl + "R+";
            }
            if (dl.equals("ALCR+")) {
                dl = "S";
            }
            if (this.hasComplexSubRoles) {
                dl = "SR";
            } else if (this.hasRoleHierarchy) {
                dl = dl + "H";
            }
            if (this.hasNominal()) {
                dl = dl + "O";
            }
            if (this.hasInverse) {
                dl = dl + "I";
            }
            if (this.hasCardinalityQ) {
                dl = dl + "Q";
            } else if (this.hasCardinality) {
                dl = dl + "N";
            } else if (this.hasFunctionality) {
                dl = dl + "F";
            }
            if (this.hasDatatype) {
                dl = this.hasKeys ? dl + "(Dk)" : dl + "(D)";
            }
        }
        return dl;
    }

    public boolean hasNegation() {
        return this.hasNegation;
    }

    public void setHasNegation(boolean v) {
        this.hasNegation = v;
    }

    public boolean hasAllValues() {
        return this.hasAllValues;
    }

    public void setHasAllValues(boolean v) {
        this.hasAllValues = v;
    }

    public boolean hasDisjointClasses() {
        return this.hasDisjointClasses;
    }

    public void setHasDisjointClasses(boolean v) {
        this.hasDisjointClasses = v;
    }

    public boolean hasInverse() {
        return this.hasInverse;
    }

    public void setHasInverse(boolean v) {
        this.hasInverse = v;
    }

    public boolean hasFunctionality() {
        return this.hasFunctionality;
    }

    public void setHasFunctionality(boolean v) {
        this.hasFunctionality = v;
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public void setHasCardinality(boolean v) {
        this.hasCardinality = v;
    }

    public boolean hasCardinalityQ() {
        return this.hasCardinalityQ;
    }

    public void setHasCardinalityQ(boolean v) {
        this.hasCardinalityQ = v;
    }

    public boolean hasFunctionalityD() {
        return this.hasFunctionalityD;
    }

    public void setHasFunctionalityD(boolean v) {
        this.hasFunctionalityD = v;
    }

    public boolean hasCardinalityD() {
        return this.hasCardinalityD;
    }

    public void setHasCardinalityD(boolean v) {
        this.hasCardinalityD = v;
    }

    public boolean hasTransitivity() {
        return this.hasTransitivity;
    }

    public void setHasTransitivity(boolean v) {
        this.hasTransitivity = v;
    }

    public boolean hasRoleHierarchy() {
        return this.hasRoleHierarchy;
    }

    public void setHasRoleHierarchy(boolean v) {
        this.hasRoleHierarchy = v;
    }

    public boolean hasReflexivity() {
        return this.hasReflexivity;
    }

    public void setHasReflexivity(boolean v) {
        this.hasReflexivity = v;
    }

    public boolean hasIrreflexivity() {
        return this.hasIrreflexivity;
    }

    public void setHasIrreflexivity(boolean v) {
        this.hasIrreflexivity = v;
    }

    public boolean hasDisjointRoles() {
        return this.hasDisjointRoles;
    }

    public void setHasDisjointRoles(boolean v) {
        this.hasDisjointRoles = v;
    }

    public boolean hasAntiSymmmetry() {
        return this.hasAsymmetry;
    }

    public boolean hasAsymmmetry() {
        return this.hasAsymmetry;
    }

    public void setHasAntiSymmetry(boolean v) {
        this.hasAsymmetry = v;
    }

    public void setHasAsymmetry(boolean v) {
        this.hasAsymmetry = v;
    }

    public boolean hasComplexSubRoles() {
        return this.hasComplexSubRoles;
    }

    public void setHasComplexSubRoles(boolean v) {
        this.hasComplexSubRoles = v;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public void setHasDatatype(boolean v) {
        this.hasDatatype = v;
    }

    public boolean hasUserDefinedDatatype() {
        return this.hasUserDefinedDatatype;
    }

    public void setHasUserDefinedDatatype(boolean v) {
        if (v) {
            this.setHasDatatype(true);
        }
        this.hasUserDefinedDatatype = v;
    }

    public boolean hasKeys() {
        return this.hasKeys;
    }

    public void setHasKeys(boolean v) {
        this.hasKeys = v;
    }

    public boolean hasDomain() {
        return this.hasDomain;
    }

    public void setHasDomain(boolean v) {
        this.hasDomain = v;
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public void setHasRange(boolean v) {
        this.hasRange = v;
    }

    public boolean hasIndividual() {
        return this.hasIndividual;
    }

    public void setHasIndividual(boolean v) {
        this.hasIndividual = v;
    }

    public boolean hasNominal() {
        return !this.nominals.isEmpty();
    }

    public Set<ATermAppl> getNominals() {
        return this.nominals;
    }

    public void addNominal(ATermAppl n) {
        this.nominals.add(n);
    }
}

