/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class NumberToLiteralVisitor
implements NumericVisitor {
    private ABox abox;
    private Literal result;

    public NumberToLiteralVisitor(ABox abox) {
        this.abox = abox;
    }

    private void argCheck(Number[] args) {
        if (args.length != 1) {
            throw new InternalReasonerException("Wrong number of arguments to visitor.");
        }
    }

    public Literal getLiteral() {
        return this.result;
    }

    private void setLiteral(Number arg, String typeURI) {
        this.result = this.abox.addLiteral(ATermUtils.makeTypedLiteral(arg.toString(), typeURI));
    }

    public void visit(BigDecimal[] args) {
        this.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#decimal");
    }

    public void visit(BigInteger[] args) {
        this.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#integer");
    }

    public void visit(Double[] args) {
        this.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#double");
    }

    public void visit(Float[] args) {
        this.argCheck(args);
        this.setLiteral(args[0], "http://www.w3.org/2001/XMLSchema#float");
    }
}

