/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.EIValueRestriction;
import org.eaglei.model.jena.EagleIOntUtils;
import org.eaglei.services.InstitutionRegistry;

public class JenaEIOntModel
implements EIOntModel {
    protected static final Log logger = LogFactory.getLog(JenaEIOntModel.class);
    private final OntModel jenaOntModel;
    private final String version;
    private final AnnotationProperty inPropertyGroup;
    private final AnnotationProperty inClassGroup;
    private final Resource dataModelExclude;
    private final Map<String, List<String>> mapPropURIToDomainConstraints;
    private final Map<String, List<String>> mapPropURIToRangeConstraints;
    private final AnnotationProperty eiPreferredDefinition;
    private final AnnotationProperty obiDefinition;
    private InstitutionRegistry institutionRegistry;
    private final List<Property> prefLabelProperties = new ArrayList<Property>();
    private final Property iaoAltTerm;
    private final HashMap<EIURI, List<EIEntity>> mapClassIdToTypeLabels = new HashMap();
    private final List<OntClass> listTopLevelOntClasses;
    private final Set<String> setTopLevelURIs;
    private final List<EIClass> listTopLevelEIClasses;
    private final Set<String> setNonResourceBaseURIs;
    private final List<EIClass> listNonResourceBaseEIClasses;
    private final Property functionProperty;
    private final HashMap<String, EIClass> mapURIStrToEIClass = new HashMap();
    private final HashMap<String, Map<String, EIValueRestriction>> mapURIStrToRestrictionMap = new HashMap();

    protected JenaEIOntModel(OntModel jenaOntModel) {
        this.jenaOntModel = jenaOntModel;
        this.version = jenaOntModel.getOntology("http://purl.org/eagle-i/app-ext/").getVersionInfo();
        logger.info("eagle-i ontology version: " + this.version);
        this.inPropertyGroup = jenaOntModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/inPropertyGroup");
        this.inClassGroup = jenaOntModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/inClassGroup");
        this.dataModelExclude = jenaOntModel.getResource("http://eagle-i.org/ont/app/1.0/PropertyGroup/dataModelExclude");
        this.eiPreferredDefinition = jenaOntModel.getAnnotationProperty("http://eagle-i.org/ont/app/1.0/preferredDefinition");
        this.obiDefinition = jenaOntModel.getAnnotationProperty("http://purl.obolibrary.org/obo/IAO_0000115");
        this.mapPropURIToDomainConstraints = new HashMap<String, List<String>>();
        Property domainConstraint = jenaOntModel.getProperty("http://eagle-i.org/ont/app/1.0/domainConstraint");
        List domainConstrainedStatements = jenaOntModel.listStatements((Resource)null, domainConstraint, (RDFNode)null).toList();
        for (Statement stmt : domainConstrainedStatements) {
            Resource constraintSubject = stmt.getSubject();
            String propURI = constraintSubject.getURI();
            List<String> constraintList = this.mapPropURIToDomainConstraints.get(propURI);
            if (constraintList == null) {
                constraintList = new ArrayList<String>();
                this.mapPropURIToDomainConstraints.put(propURI, constraintList);
            }
            String domainURI = stmt.getString();
            constraintList.add(domainURI);
        }
        this.mapPropURIToRangeConstraints = new HashMap<String, List<String>>();
        Property rangeConstraint = jenaOntModel.getProperty("http://eagle-i.org/ont/app/1.0/rangeConstraint");
        List rangeConstrainedStatements = jenaOntModel.listStatements((Resource)null, rangeConstraint, (RDFNode)null).toList();
        for (Statement stmt : rangeConstrainedStatements) {
            Resource constraintSubject = stmt.getSubject();
            String propURI = constraintSubject.getURI();
            List<String> constraintList = this.mapPropURIToRangeConstraints.get(propURI);
            if (constraintList == null) {
                constraintList = new ArrayList<String>();
                this.mapPropURIToRangeConstraints.put(propURI, constraintList);
            }
            String rangeURI = stmt.getString();
            constraintList.add(rangeURI);
        }
        this.functionProperty = jenaOntModel.getProperty("http://purl.obolibrary.org/obo/OBI_0000306");
        Property eiPrefLabel = jenaOntModel.getProperty("http://eagle-i.org/ont/app/1.0/preferredLabel");
        Property iaoPrefTerm = jenaOntModel.getProperty("http://purl.obolibrary.org/obo/IAO_0000111");
        this.prefLabelProperties.add(eiPrefLabel);
        this.prefLabelProperties.add(iaoPrefTerm);
        this.prefLabelProperties.add(RDFS.label);
        this.iaoAltTerm = jenaOntModel.getProperty("http://purl.obolibrary.org/obo/IAO_0000118");
        logger.info("initializing resource class lists...");
        long start = System.currentTimeMillis();
        List<List<OntClass>> listClassesInGroup = this.getResourceLists();
        this.listTopLevelOntClasses = listClassesInGroup.get(0);
        this.setTopLevelURIs = new HashSet<String>(this.listTopLevelOntClasses.size());
        TreeMap<String, EIClass> tmClasses = new TreeMap<String, EIClass>();
        for (OntClass ontClass : this.listTopLevelOntClasses) {
            this.setTopLevelURIs.add(ontClass.getURI());
            EIClass eiClass = this.createClass(ontClass);
            tmClasses.put(eiClass.getEntity().getLabel().toLowerCase(), eiClass);
        }
        this.listTopLevelEIClasses = new ArrayList(tmClasses.values());
        List<OntClass> listNonResourceOntClasses = listClassesInGroup.get(1);
        this.listNonResourceBaseEIClasses = new ArrayList<EIClass>(listNonResourceOntClasses.size());
        this.setNonResourceBaseURIs = new HashSet<String>(listNonResourceOntClasses.size());
        for (OntClass ontClass : listNonResourceOntClasses) {
            this.setNonResourceBaseURIs.add(ontClass.getURI());
            EIClass eiClass = this.createClass(ontClass);
            this.listNonResourceBaseEIClasses.add(eiClass);
        }
        logger.info("resource class lists initialized: " + (System.currentTimeMillis() - start));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public OntModel getOntModel() {
        return this.jenaOntModel;
    }

    private List<List<OntClass>> getResourceLists() {
        ArrayList<List<OntClass>> result = new ArrayList<List<OntClass>>(2);
        List<OntClass> resourceList = EagleIOntUtils.getClassesInGroup(this.jenaOntModel, "http://eagle-i.org/ont/app/1.0/ClassGroup/resourceRoot");
        if (resourceList != null) {
            result.add(resourceList);
        } else assert (false) : "TODO";
        resourceList = this.getResourceListFromCache("/rootNonResourceList.txt");
        if (resourceList != null) {
            result.add(resourceList);
        } else {
            result.add(new ArrayList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OntClass> getResourceListFromCache(String path) {
        ArrayList<OntClass> arrayList;
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(is));
            String list = br.readLine();
            if (list == null) {
                List<OntClass> list2 = null;
                return list2;
            }
            String[] uriStrings = list.split(",");
            ArrayList<OntClass> listOntClass = new ArrayList<OntClass>(uriStrings.length);
            for (String uri : uriStrings) {
                listOntClass.add(this.getOntologyClass(uri));
            }
            arrayList = listOntClass;
        }
        catch (Exception e2) {
            logger.error(e2);
            List<OntClass> list = null;
            return list;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e3) {}
        }
        return arrayList;
    }

    public List<EIEntity> getTypeEntities(EIURI classId) {
        assert (classId != null);
        List<EIEntity> results = this.mapClassIdToTypeLabels.get(classId);
        if (results != null) {
            return results;
        }
        results = new ArrayList<EIEntity>();
        EIClass root = this.getClass(classId);
        this.getTypeLabelsInternal(root, results);
        this.mapClassIdToTypeLabels.put(classId, results);
        return results;
    }

    private void getTypeLabelsInternal(EIClass c, List<EIEntity> results) {
        results.add(c.getEntity());
        if (c.hasSubClass()) {
            List<EIClass> subclasses = this.getSubClasses(c.getEntity().getURI());
            for (EIClass subclass : subclasses) {
                this.getTypeLabelsInternal(subclass, results);
            }
        }
    }

    @Override
    public boolean isModelClassURI(String uri) {
        OntClass c = this.getOntologyClass(uri);
        if (c == null) {
            return false;
        }
        if (this.isResource(c)) {
            return true;
        }
        return this.isNonResource(c);
    }

    @Override
    public List<EIClass> getTopLevelClasses() {
        return this.listTopLevelEIClasses;
    }

    @Override
    public List<EIClass> getNonResourceBaseClasses() {
        return this.listNonResourceBaseEIClasses;
    }

    public void setInstitutionRegistry(InstitutionRegistry institutionRegistry) {
        this.institutionRegistry = institutionRegistry;
    }

    @Override
    public EIClass getClass(EIURI uri) {
        assert (uri != null);
        return this.getClass(uri.toString());
    }

    protected EIClass getClass(String uri) {
        OntClass ontClass = this.getOntologyClass(uri);
        if (ontClass == null) {
            return null;
        }
        return this.createClass(ontClass);
    }

    private EIClass createClass(OntClass ontClass) {
        assert (ontClass != null);
        EIClass result = this.mapURIStrToEIClass.get(ontClass.getURI());
        if (result != null) {
            return result;
        }
        EIURI uri = EIURI.create(ontClass.getURI());
        String label = this.getPreferredLabel(uri);
        boolean hasSuperClass = this.hasSuperClass(ontClass);
        boolean hasSubClass = this.hasSubClass(ontClass);
        boolean hasProperties = true;
        boolean isEagleIResource = this.isResource(ontClass);
        if (!isEagleIResource) {
            // empty if block
        }
        EIEntity entity = EIEntity.create(uri, label);
        List<OntClass> listEquivOntClasses = ontClass.listEquivalentClasses().toList();
        ArrayList<EIEquivalentClass> listEquivalentClasses = null;
        boolean isInferred = false;
        if (listEquivOntClasses.size() > 1) {
            listEquivalentClasses = new ArrayList<EIEquivalentClass>(listEquivOntClasses.size() - 1);
            for (OntClass equivOntClass : listEquivOntClasses) {
                if (ontClass.getURI().equals(equivOntClass.getURI())) continue;
                if (equivOntClass.isIntersectionClass()) {
                    boolean hasFunctionRestriction = false;
                    String equivClassURI = null;
                    ArrayList<EIClass> listEquivalentToClasses = new ArrayList<EIClass>();
                    IntersectionClass intersectionClass = equivOntClass.asIntersectionClass();
                    for (OntClass ontClass2 : intersectionClass.listOperands().toList()) {
                        if (ontClass2.isRestriction()) {
                            Restriction r = ontClass2.asRestriction();
                            hasFunctionRestriction = r.onProperty(this.functionProperty);
                            continue;
                        }
                        if (ontClass2.isUnionClass()) {
                            UnionClass uc = ontClass2.asUnionClass();
                            RDFList members = uc.getOperands();
                            for (int i = 0; i < members.size(); ++i) {
                                RDFNode n = members.get(i);
                                assert (n instanceof Resource);
                                String eiClassURI = ((Resource)n).getURI();
                                if (eiClassURI == null) {
                                    logger.warn("Unexpected equivalent class construct in: " + entity + ", union member has a null URI");
                                    continue;
                                }
                                assert (!eiClassURI.equals(OWL.Thing.getURI()));
                                EIClass ec = this.getClass(eiClassURI);
                                listEquivalentToClasses.add(ec);
                            }
                            continue;
                        }
                        if (!(ontClass2 instanceof Resource)) {
                            logger.warn("Unexpected equivalent class construct in: " + entity + ", intersection operand is not a Resource");
                            continue;
                        }
                        equivClassURI = ontClass2.getURI();
                        if (equivClassURI != null) continue;
                        logger.warn("Unexpected equivalent class construct in: " + entity + ", Resource intersection operand has null URI");
                    }
                    if (listEquivalentToClasses.size() > 0) {
                        listEquivalentClasses.add(new EIEquivalentClass(null, listEquivalentToClasses));
                        logger.info(entity + " : Has equivalent classes: " + listEquivalentToClasses);
                    }
                    if (!hasFunctionRestriction) continue;
                    isInferred = true;
                    logger.info("Inferred class: " + entity);
                    continue;
                }
                logger.warn("Unexpected equivalent class construct in: " + ontClass.getURI() + ", not an intersection");
            }
        }
        boolean hasEquivalentClass = listEquivalentClasses != null ? listEquivalentClasses.size() > 0 : false;
        result = new EIClass(entity, isInferred, hasProperties, hasSubClass, hasSuperClass, hasEquivalentClass, isEagleIResource);
        result.setEquivalentClasses(listEquivalentClasses);
        this.mapURIStrToEIClass.put(ontClass.getURI(), result);
        return result;
    }

    private Map<String, EIValueRestriction> getRestrictions(String classURIStr) {
        Map<String, EIValueRestriction> mapValueRestrictions = this.mapURIStrToRestrictionMap.get(classURIStr);
        if (mapValueRestrictions != null) {
            return mapValueRestrictions;
        }
        mapValueRestrictions = new HashMap<String, EIValueRestriction>();
        OntClass ontClass = this.getOntologyClass(classURIStr);
        this.computeAllRestrictions(ontClass, mapValueRestrictions);
        this.mapURIStrToRestrictionMap.put(classURIStr, mapValueRestrictions);
        return mapValueRestrictions;
    }

    private Map<String, EIValueRestriction> computeAllRestrictions(OntClass ontClass, Map<String, EIValueRestriction> mapValueRestrictions) {
        for (OntClass ontSuperClass : ontClass.listSuperClasses().toList()) {
            if (ontSuperClass.isRestriction()) {
                Restriction r = ontSuperClass.asRestriction();
                this.parseRestriction(ontClass.getURI(), r, mapValueRestrictions);
                continue;
            }
            String parentClassURIStr = ontSuperClass.getURI();
            if (parentClassURIStr == null) continue;
            Map<String, EIValueRestriction> parentRestrictionMap = this.getRestrictions(parentClassURIStr);
            mapValueRestrictions.putAll(parentRestrictionMap);
        }
        List<OntClass> listEquivOntClasses = ontClass.listEquivalentClasses().toList();
        for (OntClass equivOntClass : listEquivOntClasses) {
            if (!equivOntClass.isIntersectionClass()) continue;
            IntersectionClass intersectionClass = equivOntClass.asIntersectionClass();
            String equivClassURI = null;
            Restriction r = null;
            for (OntClass ontClass2 : intersectionClass.listOperands().toList()) {
                if (ontClass2.isRestriction()) {
                    r = ontClass2.asRestriction();
                    continue;
                }
                if (!(ontClass2 instanceof Resource)) {
                    logger.warn("Unexpected equivalent class construct in: " + ontClass.getURI() + ", intersection operand is not a Resource");
                    continue;
                }
                equivClassURI = ontClass2.getURI();
                if (equivClassURI != null) continue;
                logger.warn("Unexpected equivalent class construct in: " + ontClass.getURI() + ", Resource intersection operand has null URI");
            }
            if (equivClassURI == null || r == null || !this.isSubClass(equivClassURI, ontClass.getURI())) continue;
            this.parseRestriction(ontClass.getURI(), r, mapValueRestrictions);
        }
        return mapValueRestrictions;
    }

    private void parseRestriction(String classURIStr, Restriction r, Map<String, EIValueRestriction> mapValueRestrictions) {
        OntProperty ontProperty = r.getOnProperty();
        String propertyURI = ontProperty.getURI();
        if (propertyURI == null) {
            logger.warn(classURIStr + " : Restriction's onProperty property uri is null");
            return;
        }
        String valueRestrictionURI = null;
        EIClass valueEIClass = null;
        EIValueRestriction valueRestriction = null;
        if (r.isAllValuesFromRestriction()) {
            AllValuesFromRestriction allRestrict = r.asAllValuesFromRestriction();
            Resource valueResource = allRestrict.getAllValuesFrom();
            valueRestrictionURI = valueResource.getURI();
            if (!(valueResource instanceof OntClass)) {
                logger.warn(classURIStr + " : Unable to handle all values data range restriction on property " + propertyURI);
                return;
            }
            valueEIClass = this.getClass(valueRestrictionURI);
            valueRestriction = new EIValueRestriction(EIValueRestriction.Type.ALL_VALUES, valueRestrictionURI, valueEIClass);
        } else if (r.isHasValueRestriction()) {
            HasValueRestriction hasRestrict = r.asHasValueRestriction();
            RDFNode node = hasRestrict.getHasValue();
            if (!(node instanceof Resource)) {
                logger.warn(classURIStr + " : Unsupported restriction value type. HAS VALUE restriction:  Prop: " + propertyURI + "  Value: " + ((Object)node).toString());
                return;
            }
            valueRestrictionURI = ((Resource)node).getURI();
            valueRestriction = new EIValueRestriction(EIValueRestriction.Type.HAS_VALUE, valueRestrictionURI, null);
        } else if (r.isSomeValuesFromRestriction()) {
            SomeValuesFromRestriction someRestrict = r.asSomeValuesFromRestriction();
            Resource valueResource = someRestrict.getSomeValuesFrom();
            valueRestrictionURI = valueResource.getURI();
            if (!(valueResource instanceof OntClass)) {
                logger.warn(classURIStr + " : Unable to handle all values data range restriction on property " + propertyURI);
                return;
            }
            valueEIClass = this.getClass(valueRestrictionURI);
            valueRestriction = new EIValueRestriction(EIValueRestriction.Type.SOME_VALUES, valueRestrictionURI, valueEIClass);
        }
        if (valueRestrictionURI == null && valueRestriction == null) {
            logger.warn(classURIStr + " : Unable to handle restriction on property " + propertyURI);
            return;
        }
        mapValueRestrictions.put(propertyURI, valueRestriction);
    }

    private EIProperty createProperty(OntProperty ontProperty) {
        EIProperty result = null;
        EIURI uri = EIURI.create(ontProperty.getURI());
        String label = this.getPreferredLabel(uri);
        EIEntity entity = EIEntity.create(uri, label);
        if (ontProperty.isObjectProperty()) {
            ArrayList<EIClass> listRangeClasses = new ArrayList<EIClass>();
            List<String> rangeConstraints = this.mapPropURIToRangeConstraints.get(ontProperty.getURI());
            if (rangeConstraints != null) {
                for (String rangeURI : rangeConstraints) {
                    EIClass eIClass = this.getClass(rangeURI);
                    this.addObjectPropertyRangeClass(listRangeClasses, eIClass);
                }
            } else {
                List<? extends OntResource> listRange = ontProperty.listRange().toList();
                for (OntResource ontResource : listRange) {
                    OntClass rangeOntClass = (OntClass)ontResource;
                    if (rangeOntClass.isUnionClass()) {
                        UnionClass uc = rangeOntClass.asUnionClass();
                        RDFList members = uc.getOperands();
                        for (int i = 0; i < members.size(); ++i) {
                            String rangeURI;
                            RDFNode rangeNode = members.get(i);
                            if (!(rangeNode instanceof Resource) || (rangeURI = ((Resource)rangeNode).getURI()).equals(OWL.Thing.getURI())) continue;
                            EIClass rangeClass = this.getClass(rangeURI);
                            this.addObjectPropertyRangeClass(listRangeClasses, rangeClass);
                        }
                        continue;
                    }
                    if (rangeOntClass.getURI().equals(OWL.Thing.getURI())) continue;
                    EIClass rangeClass = this.createClass(rangeOntClass);
                    this.addObjectPropertyRangeClass(listRangeClasses, rangeClass);
                }
            }
            if (listRangeClasses.size() > 0) {
                result = new EIObjectProperty(entity, listRangeClasses);
            } else {
                assert (false) : "Unable to determine range for object property " + entity.toString();
                result = new EIDatatypeProperty(entity, null);
            }
        } else if (ontProperty.isDatatypeProperty()) {
            String typeLabel = null;
            OntResource rangeResource = ontProperty.getRange();
            if (rangeResource != null) {
                typeLabel = rangeResource.getLocalName();
            }
            result = new EIDatatypeProperty(entity, typeLabel);
        }
        Set<String> setAnnotationValueURI = this.getPropertyAnnotations(ontProperty);
        result.setAnnotations(setAnnotationValueURI);
        return result;
    }

    private void addObjectPropertyRangeClass(List<EIClass> listRangeClasses, EIClass rangeClassToAdd) {
        if (rangeClassToAdd.hasEquivalentClass()) {
            for (EIEquivalentClass equivalentClass : rangeClassToAdd.getEquivalentClasses()) {
                for (EIClass equivalentToClass : equivalentClass.getEquivalentTo()) {
                    listRangeClasses.add(equivalentToClass);
                }
            }
        } else {
            listRangeClasses.add(rangeClassToAdd);
        }
    }

    private boolean hasSuperClass(OntClass ontClass) {
        boolean hasSuperClass = !this.isResourceBaseClass(ontClass) && !this.isNonResourceBaseClass(ontClass);
        return hasSuperClass;
    }

    @Override
    public List<EIClass> getSuperClasses(EIURI classId) {
        EIClass eiClass = this.getClass(classId);
        if (eiClass == null) {
            return Collections.emptyList();
        }
        if (!eiClass.hasSuperClass()) {
            return Collections.emptyList();
        }
        List<EIClass> result = eiClass.getSuperClasses();
        if (result != null) {
            return result;
        }
        result = new ArrayList<EIClass>();
        EIClass childClass = this.getClass(classId);
        while (childClass.hasSuperClass()) {
            EIClass parentClass = this.getSuperClass(childClass);
            assert (parentClass != null) : "getSuperClasses: " + classId + "   childClass has null parentClass: " + childClass.getEntity();
            result.add(parentClass);
            childClass = parentClass;
        }
        eiClass.setSuperClasses(result);
        return result;
    }

    @Override
    public EIClass getSuperClass(EIClass eiClass) {
        assert (eiClass != null);
        if (!eiClass.hasSuperClass()) {
            logger.debug("getSuperClass() called on class for which hasSuperClass() is false: " + eiClass.getEntity().toString());
            return null;
        }
        EIClass parentEIClass = eiClass.getSuperClass();
        if (parentEIClass != null) {
            return parentEIClass;
        }
        String uri = eiClass.getEntity().getURI().toString();
        if (this.isResourceBaseClass(uri)) {
            return null;
        }
        if (this.isNonResourceBaseClass(uri)) {
            return null;
        }
        OntClass childClass = this.getOntologyClass(uri);
        ExtendedIterator<OntClass> itrSuperClasses = childClass.listSuperClasses(true);
        while (itrSuperClasses.hasNext()) {
            OntClass parentClass = (OntClass)itrSuperClasses.next();
            String parentURI = parentClass.getURI();
            if (parentURI == null || OWL.Thing.getURI().equals(parentURI)) continue;
            parentEIClass = this.getClass(parentClass.getURI());
            eiClass.setSuperClass(parentEIClass);
            return parentEIClass;
        }
        return null;
    }

    private boolean isResource(OntClass ontClass) {
        if (this.isResourceBaseClass(ontClass)) {
            return true;
        }
        for (OntClass c : this.listTopLevelOntClasses) {
            if (!c.hasSubClass(ontClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonResource(OntClass ontClass) {
        if (this.isNonResourceBaseClass(ontClass)) {
            return true;
        }
        for (String strURI : this.setNonResourceBaseURIs) {
            OntClass c = this.getOntologyClass(strURI);
            if (!c.hasSubClass(ontClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isResourceBaseClass(OntClass ontClass) {
        return this.isResourceBaseClass(ontClass.getURI());
    }

    private boolean isResourceBaseClass(String uri) {
        return this.setTopLevelURIs.contains(uri);
    }

    private boolean isNonResourceBaseClass(OntClass ontClass) {
        return this.isNonResourceBaseClass(ontClass.getURI());
    }

    private boolean isNonResourceBaseClass(String uri) {
        return this.setNonResourceBaseURIs.contains(uri);
    }

    private boolean hasSubClass(OntClass ontClass) {
        ExtendedIterator<OntClass> itrSubClasses = ontClass.listSubClasses(true);
        while (itrSubClasses.hasNext()) {
            OntClass childClass = (OntClass)itrSubClasses.next();
            if (childClass == null || childClass.getURI() == null) continue;
            return !childClass.getURI().equals(OWL.Nothing.getURI());
        }
        return false;
    }

    public boolean isSubClass(EIURI ancestorURI, EIURI descendentURI) {
        return this.isSubClass(ancestorURI.toString(), descendentURI.toString());
    }

    public boolean isSubClass(String ancestorURI, String descendentURI) {
        OntClass ancestorOntClass = this.getOntologyClass(ancestorURI);
        OntClass descendentOntClass = this.getOntologyClass(descendentURI);
        return ancestorOntClass.hasSubClass(descendentOntClass);
    }

    @Override
    public List<EIClass> getSubClasses(EIURI classId) {
        EIClass eiClass = this.getClass(classId);
        if (eiClass == null) {
            return Collections.emptyList();
        }
        if (!eiClass.hasSubClass()) {
            logger.debug("getSubClasses() called on class for which hasSubClass() is false: " + eiClass.getEntity().toString());
            return new ArrayList<EIClass>();
        }
        List<EIClass> result = eiClass.getSubClasses();
        if (result != null) {
            return result;
        }
        OntClass parentClass = this.getOntologyClass(classId.toString());
        result = this.getSubClasses(parentClass);
        eiClass.setSubClasses(result);
        return result;
    }

    OntClass getOntologyClass(String strURI) {
        return this.jenaOntModel.getOntClass(strURI);
    }

    private List<EIClass> getSubClasses(OntClass ontClass) {
        TreeMap<String, EIClass> tmSubClasses = new TreeMap<String, EIClass>();
        ExtendedIterator<OntClass> itrSubClasses = ontClass.listSubClasses(true);
        while (itrSubClasses.hasNext()) {
            OntClass childClass = (OntClass)itrSubClasses.next();
            if (childClass == null || childClass.getURI() == null || childClass.getURI().equals(OWL.Nothing.getURI())) continue;
            EIClass eiChildClass = this.createClass(childClass);
            tmSubClasses.put(eiChildClass.getEntity().getLabel().toLowerCase(), eiChildClass);
        }
        ArrayList<EIClass> listSubClasses = new ArrayList<EIClass>(tmSubClasses.values());
        return listSubClasses;
    }

    @Override
    public List<EIEquivalentClass> getEquivalentClasses(EIURI classId) {
        EIClass eiClass = this.getClass(classId);
        assert (eiClass != null);
        return eiClass.getEquivalentClasses();
    }

    @Override
    public List<EIProperty> getProperties(EIURI classId) {
        return this.getProperties(classId, null);
    }

    public List<EIProperty> getProperties(EIURI classId, String groupURI) {
        EIClass eiClass = this.getClass(classId);
        assert (eiClass != null);
        if (!eiClass.hasProperty()) {
            logger.debug("getProperties() called on class for which hasProperty() is false: " + eiClass.getEntity().toString());
            return new ArrayList<EIProperty>();
        }
        List<EIProperty> result = eiClass.getProperties();
        if (result != null) {
            return result;
        }
        OntClass ontClass = this.getOntologyClass(classId.toString());
        result = this.getProperties(ontClass, groupURI);
        this.setValueRestriction(result, eiClass);
        TreeSet<EIProperty> tsProperties = new TreeSet<EIProperty>(new EIPropertyComparator());
        tsProperties.addAll(result);
        result = new ArrayList<EIProperty>(tsProperties);
        eiClass.setProperties(result);
        return result;
    }

    private void setValueRestriction(List<EIProperty> propertyList, EIClass eiClass) {
        Map<String, EIValueRestriction> mapValueRestrictions = this.getRestrictions(eiClass.getEntity().getURI().toString());
        for (EIProperty eiProp : propertyList) {
            eiProp.setValueRestriction(mapValueRestrictions.get(eiProp.getEntity().getURI().toString()));
        }
    }

    private List<EIProperty> getProperties(OntClass ontClass, String groupURI) {
        ArrayList<EIProperty> listProperties = new ArrayList<EIProperty>();
        ExtendedIterator<OntProperty> itrProperties = ontClass.listDeclaredProperties();
        while (itrProperties.hasNext()) {
            try {
                EIProperty property;
                OntProperty ontProperty;
                Object o = itrProperties.next();
                if (!(o instanceof OntProperty) || (ontProperty = (OntProperty)o).isAnnotationProperty() || ontProperty.hasProperty((Property)this.inPropertyGroup, this.dataModelExclude)) continue;
                List<String> domainConstraints = this.mapPropURIToDomainConstraints.get(ontProperty.getURI());
                if (domainConstraints != null) {
                    boolean withinConstraint = false;
                    for (String domainRootURI : domainConstraints) {
                        if (domainRootURI.equals(ontClass.getURI())) {
                            withinConstraint = true;
                            break;
                        }
                        OntClass domainRootOntClass = this.getOntologyClass(domainRootURI);
                        if (!domainRootOntClass.hasSubClass(ontClass)) continue;
                        withinConstraint = true;
                        break;
                    }
                    if (!withinConstraint) continue;
                }
                if ((property = this.createProperty(ontProperty)) == null) continue;
                listProperties.add(property);
            }
            catch (ConversionException ex) {}
        }
        return listProperties;
    }

    @Override
    public List<String> getClassDefinitions(List<EIURI> classURIs) {
        ArrayList<String> results = new ArrayList<String>(classURIs.size());
        for (EIURI classURI : classURIs) {
            String def = this.getClassDefinition(classURI);
            results.add(def);
        }
        return results;
    }

    @Override
    public String getClassDefinition(EIURI classURI) {
        OntClass ontClass = this.getOntologyClass(classURI.toString());
        if (ontClass == null) {
            return null;
        }
        String def = null;
        RDFNode defNode = ontClass.getPropertyValue(this.eiPreferredDefinition);
        if (defNode != null) {
            def = ((Literal)defNode).getString();
        }
        if (def == null && (defNode = ontClass.getPropertyValue(this.obiDefinition)) != null) {
            def = ((Literal)defNode).getString();
        }
        return def;
    }

    @Override
    public List<Set<String>> getClassAnnotations(List<EIURI> classURIs) {
        ArrayList<Set<String>> results = new ArrayList<Set<String>>(classURIs.size());
        for (EIURI classURI : classURIs) {
            Set<String> annos = this.getClassAnnotations(classURI);
            results.add(annos);
        }
        return results;
    }

    public Set<String> getClassAnnotations(EIURI classURI) {
        EIClass eiClass = this.getClass(classURI);
        if (eiClass == null) {
            return null;
        }
        Set<String> setAnnotationValueURI = eiClass.getAnnotations();
        if (setAnnotationValueURI == null) {
            OntClass ontClass = this.getOntologyClass(eiClass.getEntity().getURI().toString());
            setAnnotationValueURI = this.getClassAnnotations(ontClass);
            eiClass.setAnnotations(setAnnotationValueURI);
        }
        return setAnnotationValueURI;
    }

    private Set<String> getClassAnnotations(OntClass ontClass) {
        HashSet<String> setAnnotationValueURI = new HashSet<String>();
        StmtIterator classGroupStatements = ontClass.listProperties(this.inClassGroup);
        while (classGroupStatements.hasNext()) {
            Statement stmt = (Statement)classGroupStatements.next();
            RDFNode o = stmt.getObject();
            setAnnotationValueURI.add(((Resource)o).getURI());
        }
        return setAnnotationValueURI;
    }

    @Override
    public String getPreferredLabel(EIURI uri) {
        assert (uri != null);
        Resource resource = this.jenaOntModel.getResource(uri.toString());
        if (resource == null) {
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        for (Property prop : this.prefLabelProperties) {
            JenaEIOntModel.getLiteralsForProperty(resource, prop, labels, null);
            if (labels.size() <= 0) continue;
            return (String)labels.get(0);
        }
        return null;
    }

    public List<Property> getPrefLabelProperties() {
        return this.prefLabelProperties;
    }

    @Override
    public List<String> getLabels(EIURI uri) {
        assert (uri != null);
        Resource resource = this.jenaOntModel.getResource(uri.toString());
        if (resource == null) {
            return Collections.emptyList();
        }
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> labelsLower = new ArrayList<String>();
        for (Property prop : this.prefLabelProperties) {
            JenaEIOntModel.getLiteralsForProperty(resource, prop, labels, labelsLower);
        }
        JenaEIOntModel.getLiteralsForProperty(resource, this.iaoAltTerm, labels, labelsLower);
        return labels;
    }

    public static void getLiteralsForProperty(Resource r, Property p, List<String> values, List<String> valuesLower) {
        StmtIterator it = r.listProperties(p);
        while (it.hasNext()) {
            String value;
            Statement stmt = (Statement)it.next();
            RDFNode node = stmt.getObject();
            if (!node.isLiteral() || (value = ((Literal)node).getLexicalForm()) == null || (value = value.trim()).isEmpty()) continue;
            if (values.size() > 0) {
                value = value.replace('_', ' ');
            }
            if (valuesLower != null) {
                String valueLower = value.toLowerCase();
                if (valuesLower.contains(valueLower)) continue;
                values.add(value);
                valuesLower.add(valueLower);
                continue;
            }
            values.add(value);
        }
    }

    @Override
    public List<String> getPropertyDefinitions(List<EIURI> propertyURIs) {
        ArrayList<String> results = new ArrayList<String>(propertyURIs.size());
        for (EIURI propertyURI : propertyURIs) {
            String def = this.getPropertyDefinition(propertyURI);
            results.add(def);
        }
        return results;
    }

    @Override
    public String getPropertyDefinition(EIURI propertyURI) {
        String def = null;
        OntProperty ontProperty = this.jenaOntModel.getOntProperty(propertyURI.toString());
        RDFNode defNode = ontProperty.getPropertyValue(this.eiPreferredDefinition);
        if (defNode != null) {
            def = ((Literal)defNode).getString();
        }
        return def;
    }

    private Set<String> getPropertyAnnotations(OntProperty ontProperty) {
        HashSet<String> setAnnotationValueURI = new HashSet<String>();
        StmtIterator propGroupStatements = ontProperty.listProperties(this.inPropertyGroup);
        while (propGroupStatements.hasNext()) {
            Statement stmt = (Statement)propGroupStatements.next();
            RDFNode o = stmt.getObject();
            setAnnotationValueURI.add(((Resource)o).getURI());
        }
        return setAnnotationValueURI;
    }

    @Override
    public void traverseDataModel(List<EIOntModel.Visitor> visitors) {
        logger.info("Start traversal of data model");
        HashSet<EIClass> setChecked = new HashSet<EIClass>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        try {
            for (EIClass top : this.listTopLevelEIClasses) {
                this.traverseDataModel(top, setChecked, stack, visitors);
            }
        }
        catch (Throwable e2) {
            logger.error("Unexpected error.  Stack: \r\n" + this.generateStackTrace(stack));
            throw new RuntimeException(e2);
        }
        logger.info("Traversal of data model complete");
    }

    private void traverseDataModel(EIClass c, Set<EIClass> setChecked, Deque<String> stack, List<EIOntModel.Visitor> visitors) {
        if (setChecked.contains(c)) {
            return;
        }
        stack.addLast("CLASS: " + c.toString());
        for (EIOntModel.Visitor v : visitors) {
            v.visit(c, stack);
        }
        setChecked.add(c);
        if (c.hasProperty()) {
            List<EIProperty> properties = this.getProperties(c.getEntity().getURI());
            for (EIProperty prop : properties) {
                stack.addLast("PROP: " + prop.toString());
                for (EIOntModel.Visitor v : visitors) {
                    v.visit(prop, stack);
                }
                if (prop instanceof EIObjectProperty) {
                    List<EIClass> objPropClassList = ((EIObjectProperty)prop).getRangeList();
                    for (EIClass objPropClass : objPropClassList) {
                        if (objPropClass == null) continue;
                        this.traverseDataModel(objPropClass, setChecked, stack, visitors);
                    }
                }
                stack.removeLast();
            }
        }
        if (c.hasSubClass()) {
            List<EIClass> subclasses = this.getSubClasses(c.getEntity().getURI());
            for (EIClass subclass : subclasses) {
                stack.addLast("SUBCLASS");
                this.traverseDataModel(subclass, setChecked, stack, visitors);
                stack.removeLast();
            }
        }
        stack.removeLast();
    }

    @Override
    public String generateStackTrace(Deque<String> stack) {
        StringBuilder buf = new StringBuilder();
        for (String item : stack) {
            buf.append(item);
            buf.append("\r\n");
        }
        return buf.toString();
    }

    private class EIPropertyComparator
    implements Comparator<EIProperty> {
        private EIPropertyComparator() {
        }

        @Override
        public int compare(EIProperty o1, EIProperty o2) {
            if (o1.getValueRestriction() != null && o2.getValueRestriction() == null) {
                return -1;
            }
            if (o1.getValueRestriction() == null && o2.getValueRestriction() != null) {
                return 1;
            }
            int result = o1.getEntity().getLabel().toLowerCase().compareTo(o2.getEntity().getLabel().toLowerCase());
            if (result == 0) {
                result = o1.getEntity().getURI().toString().compareTo(o2.getEntity().getURI().toString());
            }
            return result;
        }
    }
}

