/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.OntBuilder;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.BuiltinTerm;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.PelletGraphListener;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.SimpleUnion;
import org.mindswap.pellet.jena.graph.converter.AxiomConverter;
import org.mindswap.pellet.jena.graph.loader.DefaultGraphLoader;
import org.mindswap.pellet.jena.graph.loader.GraphLoader;
import org.mindswap.pellet.jena.graph.query.GraphQueryHandler;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletInfGraph
extends BaseInfGraph
implements InfGraph {
    public static final Logger log = Logger.getLogger(PelletInfGraph.class.getName());
    private static final Triple INCONCISTENCY_TRIPLE = Triple.create(OWL.Thing.asNode(), RDFS.subClassOf.asNode(), OWL.Nothing.asNode());
    private GraphLoader loader;
    protected KnowledgeBase kb;
    private ModelExtractor extractor;
    private PelletGraphListener graphListener;
    private Graph deductionsGraph;
    private boolean autoDetectChanges;

    public PelletInfGraph(KnowledgeBase kb, PelletReasoner pellet, GraphLoader loader) {
        this(kb, Factory.createDefaultGraph(), pellet, loader);
    }

    public PelletInfGraph(Graph graph, PelletReasoner pellet, GraphLoader loader) {
        this(new KnowledgeBase(), graph, pellet, loader);
    }

    private PelletInfGraph(KnowledgeBase kb, Graph graph, PelletReasoner pellet, GraphLoader loader) {
        super(graph, pellet);
        this.kb = kb;
        this.loader = loader;
        this.extractor = new ModelExtractor(kb);
        this.extractor.setSelector(ModelExtractor.StatementType.ALL_PROPERTY_STATEMENTS);
        this.graphListener = new PelletGraphListener(graph, kb);
        loader.setKB(kb);
        this.loadSchema();
        this.rebind();
    }

    public GraphLoader attachTemporaryGraph(Graph tempGraph) {
        GraphLoader savedLoader = this.loader;
        SimpleUnion unionGraph = (SimpleUnion)savedLoader.getGraph();
        unionGraph.addGraph(tempGraph);
        this.loader = new DefaultGraphLoader();
        this.loader.setGraph(unionGraph);
        this.loader.setKB(this.kb);
        this.loader.preprocess();
        return savedLoader;
    }

    public void detachTemporaryGraph(Graph tempGraph, GraphLoader savedLoader) {
        SimpleUnion unionGraph = (SimpleUnion)this.loader.getGraph();
        unionGraph.removeGraph(tempGraph);
        this.loader = savedLoader;
    }

    @Override
    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        this.prepare();
        GraphLoader savedLoader = this.attachTemporaryGraph(param);
        ExtendedIterator<Triple> result = this.graphBaseFind(subject, property, object);
        this.detachTemporaryGraph(param, savedLoader);
        return result;
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder finder) {
        this.prepare();
        Node subject = pattern.getSubject();
        Node predicate = pattern.getPredicate();
        Node object = pattern.getObject();
        ExtendedIterator<Triple> i = GraphQueryHandler.findTriple(this.kb, this.loader, subject, predicate, object);
        if (finder != null) {
            TriplePattern tp = new TriplePattern(subject, predicate, object);
            i = i.andThen(finder.find(tp));
        }
        return UniqueExtendedIterator.create(i);
    }

    @Override
    public Graph getSchemaGraph() {
        return ((PelletReasoner)this.getReasoner()).getSchema();
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared && (!this.autoDetectChanges || !this.graphListener.isChanged());
    }

    private void loadSchema() {
        Graph schema = this.getSchemaGraph();
        if (schema != null) {
            this.loader.setGraph(schema);
            this.loader.load();
        }
    }

    private void load() {
        Set<Graph> changedGraphs;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loading triples");
        }
        if ((changedGraphs = this.graphListener.getChangedGraphs()) == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Clearing the KB and reloading");
            }
            this.clear();
            this.loadSchema();
            changedGraphs = this.graphListener.getLeafGraphs();
        }
        for (Graph subG : changedGraphs) {
            this.loader.setGraph(subG);
            this.loader.load();
        }
        this.loader.setGraph(new SimpleUnion(this.graphListener.getLeafGraphs()));
        this.graphListener.reset();
        this.deductionsGraph = null;
    }

    @Override
    public void prepare() {
        this.prepare(true);
    }

    public void prepare(boolean doConsistencyCheck) {
        if (this.isPrepared()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing PelletInfGraph...");
        }
        this.load();
        this.kb.prepare();
        if (doConsistencyCheck) {
            this.kb.isConsistent();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("done.");
        }
        this.isPrepared = true;
    }

    public boolean isConsistent() {
        this.prepare();
        return this.kb.isConsistent();
    }

    public boolean isClassified() {
        return this.isPrepared && this.kb.isClassified();
    }

    public boolean isRealized() {
        return this.isPrepared && this.kb.isRealized();
    }

    public void classify() {
        this.prepare();
        this.kb.classify();
    }

    public void realize() {
        this.prepare();
        this.kb.realize();
    }

    @Override
    public Graph getDeductionsGraph() {
        if (!PelletOptions.RETURN_DEDUCTIONS_GRAPH) {
            return null;
        }
        this.classify();
        if (this.deductionsGraph == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Realizing PelletInfGraph...");
            }
            this.kb.realize();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Extract model...");
            }
            Model extractedModel = this.extractor.extractModel();
            this.deductionsGraph = extractedModel.getGraph();
            if (log.isLoggable(Level.FINE)) {
                log.fine("done.");
            }
        }
        return this.deductionsGraph;
    }

    @Override
    protected boolean graphBaseContains(Triple pattern) {
        if (this.getRawGraph().contains(pattern)) {
            return true;
        }
        return this.containsTriple(pattern);
    }

    public boolean entails(Triple pattern) {
        this.prepare();
        if (this.isSyntaxTriple(pattern)) {
            return true;
        }
        if (this.isBnodeTypeQuery(pattern)) {
            return !this.containsTriple(Triple.create(pattern.getObject(), RDFS.subClassOf.asNode(), OWL.Nothing.asNode()));
        }
        return this.containsTriple(pattern);
    }

    public Model explainInconsistency() {
        return this.explainTriple(INCONCISTENCY_TRIPLE);
    }

    public Model explain(Statement stmt) {
        return this.explainTriple(stmt.asTriple());
    }

    public Model explain(Resource s, Property p, RDFNode o) {
        return this.explainTriple(Triple.create(s.asNode(), p.asNode(), o.asNode()));
    }

    private Model explainTriple(Triple triple) {
        Graph explanation = this.explain(triple);
        return explanation == null ? null : ModelFactory.createModelForGraph(explanation);
    }

    public Graph explain(Triple pattern) {
        if (!pattern.equals(INCONCISTENCY_TRIPLE)) {
            if (!pattern.isConcrete()) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("Triple patterns with variables cannot be epxlained: " + pattern);
                }
                return null;
            }
            if (this.isSyntaxTriple(pattern)) {
                if (log.isLoggable(Level.WARNING)) {
                    log.warning("Syntax triples cannot be explained: " + pattern);
                }
                return null;
            }
        }
        this.prepare();
        Graph explanationGraph = Factory.createDefaultGraph();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explain " + pattern);
        }
        if (PelletInfGraph.checkEntailment(this, pattern, true)) {
            Set<ATermAppl> explanation = this.kb.getExplanationSet();
            if (log.isLoggable(Level.FINER)) {
                log.finer("Explanation " + PelletInfGraph.formatAxioms(explanation));
            }
            Set<ATermAppl> prunedExplanation = this.pruneExplanation(pattern, explanation);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Pruned " + PelletInfGraph.formatAxioms(prunedExplanation));
            }
            AxiomConverter converter = new AxiomConverter(this.kb, explanationGraph);
            for (ATermAppl axiom : prunedExplanation) {
                converter.convert(axiom);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Explanation " + explanationGraph);
        }
        return explanationGraph;
    }

    private Set<ATermAppl> pruneExplanation(Triple pattern, Set<ATermAppl> explanation) {
        HashSet<ATermAppl> prunedExplanation = new HashSet<ATermAppl>(explanation);
        OntBuilder builder = new OntBuilder(this.kb);
        for (ATermAppl axiom : explanation) {
            prunedExplanation.remove(axiom);
            KnowledgeBase copyKB = builder.build(prunedExplanation);
            PelletInfGraph copyGraph = new PelletInfGraph(copyKB, (PelletReasoner)this.getReasoner(), this.loader);
            if (!PelletInfGraph.checkEntailment(copyGraph, pattern, false)) {
                prunedExplanation.add(axiom);
                continue;
            }
            if (!log.isLoggable(Level.FINER)) continue;
            log.finer("Prune from explanation " + ATermUtils.toString(axiom));
        }
        return prunedExplanation;
    }

    private static boolean checkEntailment(PelletInfGraph pellet, Triple pattern, boolean withExplanation) {
        boolean doExplanation = pellet.getKB().doExplanation();
        pellet.getKB().setDoExplanation(withExplanation);
        boolean entailed = false;
        entailed = pattern.equals(INCONCISTENCY_TRIPLE) ? !pellet.isConsistent() : pellet.containsTriple(pattern);
        pellet.getKB().setDoExplanation(doExplanation);
        return entailed;
    }

    private static String formatAxioms(Set<ATermAppl> axioms) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (ATermAppl axiom : axioms) {
            sb.append(ATermUtils.toString(axiom));
            sb.append(",");
        }
        if (axioms.isEmpty()) {
            sb.append(']');
        } else {
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    protected boolean containsTriple(Triple pattern) {
        this.prepare();
        Node subject = pattern.getSubject();
        Node predicate = pattern.getPredicate();
        Node object = pattern.getObject();
        return GraphQueryHandler.containsTriple(this.kb, this.loader, subject, predicate, object);
    }

    private boolean isSyntaxTriple(Triple t) {
        BuiltinTerm builtin = BuiltinTerm.find(t.getPredicate());
        if (builtin != null) {
            if (builtin.isSyntax()) {
                return true;
            }
            if (BuiltinTerm.isExpression(builtin) && (t.getSubject().isBlank() || t.getObject().isBlank())) {
                return true;
            }
            if (builtin.equals((Object)BuiltinTerm.RDF_type)) {
                builtin = BuiltinTerm.find(t.getObject());
                return builtin != null && builtin.isSyntax();
            }
        }
        return false;
    }

    private boolean isBnodeTypeQuery(Triple t) {
        return t.getSubject().isBlank() && t.getPredicate().equals(RDF.type.asNode()) && (BuiltinTerm.find(t.getObject()) == null || t.getObject().equals(OWL.Thing.asNode()) || t.getObject().equals(OWL.Nothing.asNode()));
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.isPrepared = false;
    }

    @Override
    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.isPrepared = false;
    }

    @Override
    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport report = new StandardValidityReport();
        this.kb.setDoExplanation(true);
        boolean consistent = this.kb.isConsistent();
        this.kb.setDoExplanation(false);
        if (!consistent) {
            report.add(true, "KB is inconsistent!", this.kb.getExplanation());
        } else {
            for (ATermAppl c : this.kb.getUnsatisfiableClasses()) {
                String name = JenaUtils.makeGraphNode(c).toString();
                report.add(false, "Unsatisfiable class", name);
            }
        }
        return report;
    }

    private void clear() {
        this.kb.clear();
        this.loader.clear();
    }

    @Override
    public void close() {
        super.close();
        if (this.deductionsGraph != null) {
            this.deductionsGraph.close();
            this.deductionsGraph = null;
        }
        this.clear();
        this.graphListener.dispose();
        this.graphListener = null;
        this.kb = null;
    }

    public GraphLoader getLoader() {
        return this.loader;
    }

    public boolean isAutoDetectChanges() {
        return this.autoDetectChanges;
    }

    public void setAutoDetectChanges(boolean autoDetectChanges) {
        this.autoDetectChanges = autoDetectChanges;
    }
}

