/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.InputStream;
import junit.framework.TestCase;
import org.eaglei.model.EIEntity;
import org.eaglei.network.actions.DummyDataQueryAction;
import org.eaglei.network.actions.QueryTestUtils;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.services.InstitutionRegistry;
import org.spin.node.actions.QueryAction;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class DummyDataQueryActionTest
extends TestCase {
    private InstitutionRegistry institutionRegistry;

    protected void setUp() throws Exception {
        InputStream is = ClassLoader.getSystemResource("network-test.properties").openStream();
        System.getProperties().load(is);
        is.close();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("services-config.xml");
        this.institutionRegistry = (InstitutionRegistry)context.getBean(InstitutionRegistry.class);
    }

    public void testPerform() throws Exception {
        EIEntity university = this.institutionRegistry.getInstitution();
        DummyDataQueryAction action = new DummyDataQueryAction(university.getLabel(), university.getURI().toString());
        SearchRequest request = QueryTestUtils.searchRequestForUniversity(university);
        QueryTestUtils.doPerformTest((QueryAction<SearchRequest>)action, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitViaSystemProps() throws Exception {
        EIEntity university = this.institutionRegistry.getInstitution();
        String oldURI = System.getProperty(DummyDataQueryAction.PropNames.InstitutionURI.propKey);
        String oldLabel = System.getProperty(DummyDataQueryAction.PropNames.InstitutionLabel.propKey);
        try {
            DummyDataQueryAction dummyDataQueryAction;
            try {
                System.clearProperty(DummyDataQueryAction.PropNames.InstitutionURI.propKey);
                System.clearProperty(DummyDataQueryAction.PropNames.InstitutionLabel.propKey);
                dummyDataQueryAction = new DummyDataQueryAction();
                DummyDataQueryActionTest.fail((String)"Should have thrown if no config object was passed in, and config values were NOT provided as sys props");
            }
            catch (Throwable expected) {
                // empty catch block
            }
            System.setProperty(DummyDataQueryAction.PropNames.InstitutionURI.propKey, university.getURI().toString());
            System.setProperty(DummyDataQueryAction.PropNames.InstitutionLabel.propKey, university.getLabel());
            dummyDataQueryAction = new DummyDataQueryAction();
        }
        finally {
            if (oldURI == null) {
                System.clearProperty(DummyDataQueryAction.PropNames.InstitutionURI.propKey);
            } else {
                System.setProperty(DummyDataQueryAction.PropNames.InstitutionURI.propKey, oldURI);
            }
            if (oldLabel == null) {
                System.clearProperty(DummyDataQueryAction.PropNames.InstitutionLabel.propKey);
            } else {
                System.setProperty(DummyDataQueryAction.PropNames.InstitutionLabel.propKey, oldLabel);
            }
        }
    }
}

