/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilderBase;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public class IndexBuilderNode
extends IndexBuilderBase {
    public IndexBuilderNode() {
    }

    public IndexBuilderNode(IndexWriter existingWriter) {
        super(existingWriter);
    }

    public IndexBuilderNode(File fileDir) {
        super(fileDir);
    }

    public IndexBuilderNode(String fileDir) {
        super(fileDir);
    }

    public void index(RDFNode rdfNode, String indexStr) {
        try {
            Document doc = new Document();
            LARQ.store(doc, rdfNode.asNode());
            LARQ.index(doc, indexStr);
            this.getIndexWriter().addDocument(doc);
        }
        catch (IOException ex) {
            throw new ARQLuceneException("index", ex);
        }
    }

    public void index(RDFNode rdfNode, Reader indexStream) {
        try {
            Document doc = new Document();
            LARQ.store(doc, rdfNode.asNode());
            LARQ.index(doc, indexStream);
            this.getIndexWriter().addDocument(doc);
        }
        catch (IOException ex) {
            throw new ARQLuceneException("index", ex);
        }
    }

    public void index(Node node, String indexStr) {
        try {
            Document doc = new Document();
            LARQ.store(doc, node);
            LARQ.index(doc, indexStr);
            this.getIndexWriter().addDocument(doc);
        }
        catch (IOException ex) {
            throw new ARQLuceneException("index", ex);
        }
    }

    public void index(Node node, Reader indexStream) {
        try {
            Document doc = new Document();
            LARQ.store(doc, node);
            LARQ.index(doc, indexStream);
            this.getIndexWriter().addDocument(doc);
        }
        catch (IOException ex) {
            throw new ARQLuceneException("index", ex);
        }
    }
}

