/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.Block;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;

class FastClassEmitter
extends ClassEmitter {
    private static final Signature CSTRUCT_CLASS = TypeUtils.parseConstructor("Class");
    private static final Signature METHOD_GET_INDEX = TypeUtils.parseSignature("int getIndex(String, Class[])");
    private static final Signature SIGNATURE_GET_INDEX = new Signature("getIndex", Type.INT_TYPE, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Signature CONSTRUCTOR_GET_INDEX = TypeUtils.parseSignature("int getIndex(Class[])");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(int, Object, Object[])");
    private static final Signature NEW_INSTANCE = TypeUtils.parseSignature("Object newInstance(int, Object[])");
    private static final Signature GET_MAX_INDEX = TypeUtils.parseSignature("int getMaxIndex()");
    private static final Signature GET_SIGNATURE_WITHOUT_RETURN_TYPE = TypeUtils.parseSignature("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = TypeUtils.parseType("net.sf.cglib.reflect.FastClass");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = TypeUtils.parseType("java.lang.reflect.InvocationTargetException");
    private static final Type[] INVOCATION_TARGET_EXCEPTION_ARRAY = new Type[]{INVOCATION_TARGET_EXCEPTION};
    private static final int TOO_MANY_METHODS = 100;

    public FastClassEmitter(ClassVisitor v, String className, Class type) {
        super(v);
        Type base = Type.getType(type);
        this.begin_class(46, 1, className, FAST_CLASS, null, "<generated>");
        CodeEmitter e2 = this.begin_method(1, CSTRUCT_CLASS, null);
        e2.load_this();
        e2.load_args();
        e2.super_invoke_constructor(CSTRUCT_CLASS);
        e2.return_value();
        e2.end_method();
        VisibilityPredicate vp = new VisibilityPredicate(type, false);
        List methods = ReflectUtils.addAllMethods(type, new ArrayList());
        CollectionUtils.filter(methods, vp);
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        ArrayList constructors = new ArrayList(Arrays.asList(type.getDeclaredConstructors()));
        CollectionUtils.filter(constructors, vp);
        this.emitIndexBySignature(methods);
        this.emitIndexByClassArray(methods);
        e2 = this.begin_method(1, CONSTRUCTOR_GET_INDEX, null);
        e2.load_args();
        List info = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        EmitUtils.constructor_switch(e2, info, new GetIndexCallback(e2, info));
        e2.end_method();
        e2 = this.begin_method(1, INVOKE, INVOCATION_TARGET_EXCEPTION_ARRAY);
        e2.load_arg(1);
        e2.checkcast(base);
        e2.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e2, methods, 2, base);
        e2.end_method();
        e2 = this.begin_method(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION_ARRAY);
        e2.new_instance(base);
        e2.dup();
        e2.load_arg(0);
        FastClassEmitter.invokeSwitchHelper(e2, constructors, 1, base);
        e2.end_method();
        e2 = this.begin_method(1, GET_MAX_INDEX, null);
        e2.push(methods.size() - 1);
        e2.return_value();
        e2.end_method();
        this.end_class();
    }

    private void emitIndexBySignature(List methods) {
        CodeEmitter e2 = this.begin_method(1, SIGNATURE_GET_INDEX, null);
        List signatures = CollectionUtils.transform(methods, new Transformer(){

            public Object transform(Object obj) {
                return ReflectUtils.getSignature((Method)obj).toString();
            }
        });
        e2.load_arg(0);
        e2.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        this.signatureSwitchHelper(e2, signatures);
        e2.end_method();
    }

    private void emitIndexByClassArray(List methods) {
        CodeEmitter e2 = this.begin_method(1, METHOD_GET_INDEX, null);
        if (methods.size() > 100) {
            List signatures = CollectionUtils.transform(methods, new Transformer(){

                public Object transform(Object obj) {
                    String s = ReflectUtils.getSignature((Method)obj).toString();
                    return s.substring(0, s.lastIndexOf(41) + 1);
                }
            });
            e2.load_args();
            e2.invoke_static(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(e2, signatures);
        } else {
            e2.load_args();
            List info = CollectionUtils.transform(methods, MethodInfoTransformer.getInstance());
            EmitUtils.method_switch(e2, info, new GetIndexCallback(e2, info));
        }
        e2.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter e2, final List signatures) {
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e2.push(signatures.indexOf(key));
                e2.return_value();
            }

            public void processDefault() {
                e2.push(-1);
                e2.return_value();
            }
        };
        EmitUtils.string_switch(e2, signatures.toArray(new String[signatures.size()]), 1, callback);
    }

    private static void invokeSwitchHelper(final CodeEmitter e2, List members, final int arg, final Type base) {
        final List info = CollectionUtils.transform(members, MethodInfoTransformer.getInstance());
        final Label illegalArg = e2.make_label();
        Block block = e2.begin_block();
        e2.process_switch(FastClassEmitter.getIntRange(info.size()), new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                MethodInfo method = (MethodInfo)info.get(key);
                Type[] types = method.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e2.load_arg(arg);
                    e2.aaload(i);
                    e2.unbox(types[i]);
                }
                e2.invoke(method, base);
                if (!TypeUtils.isConstructor(method)) {
                    e2.box(method.getSignature().getReturnType());
                }
                e2.return_value();
            }

            public void processDefault() {
                e2.goTo(illegalArg);
            }
        });
        block.end();
        EmitUtils.wrap_throwable(block, INVOCATION_TARGET_EXCEPTION);
        e2.mark(illegalArg);
        e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int length) {
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = i;
        }
        return range;
    }

    private static class GetIndexCallback
    implements ObjectSwitchCallback {
        private CodeEmitter e;
        private Map indexes = new HashMap();

        public GetIndexCallback(CodeEmitter e2, List methods) {
            this.e = e2;
            int index = 0;
            Iterator it = methods.iterator();
            while (it.hasNext()) {
                this.indexes.put(it.next(), new Integer(index++));
            }
        }

        public void processCase(Object key, Label end) {
            this.e.push((Integer)this.indexes.get(key));
            this.e.return_value();
        }

        public void processDefault() {
            this.e.push(-1);
            this.e.return_value();
        }
    }
}

