/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockReleaseFailedException;

class NativeFSLock
extends Lock {
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static HashSet<String> LOCK_HELD = new HashSet();

    public NativeFSLock(File lockDir, String lockFileName) {
        this.lockDir = lockDir;
        this.path = new File(lockDir, lockFileName);
    }

    private synchronized boolean lockExists() {
        return this.lock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean obtain() throws IOException {
        boolean markedHeld;
        String canonicalPath;
        block31: {
            HashSet<String> hashSet;
            boolean bl;
            block30: {
                if (this.lockExists()) {
                    return false;
                }
                if (!this.lockDir.exists()) {
                    if (!this.lockDir.mkdirs()) {
                        throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
                    }
                } else if (!this.lockDir.isDirectory()) {
                    throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
                }
                canonicalPath = this.path.getCanonicalPath();
                markedHeld = false;
                try {
                    HashSet<String> hashSet2 = LOCK_HELD;
                    synchronized (hashSet2) {
                        if (LOCK_HELD.contains(canonicalPath)) {
                            bl = false;
                            // MONITOREXIT @DISABLED, blocks:[0, 10, 29] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                            Object var15_7 = null;
                            if (!markedHeld) return bl;
                            if (this.lockExists()) return bl;
                            hashSet = LOCK_HELD;
                            break block30;
                        }
                        LOCK_HELD.add(canonicalPath);
                        markedHeld = true;
                    }
                    try {
                        this.f = new RandomAccessFile(this.path, "rw");
                    }
                    catch (IOException e2) {
                        this.failureReason = e2;
                        this.f = null;
                    }
                    if (this.f == null) break block31;
                    try {
                        block32: {
                            this.channel = this.f.getChannel();
                            try {
                                try {
                                    this.lock = this.channel.tryLock();
                                }
                                catch (IOException e3) {
                                    this.failureReason = e3;
                                    Object var7_14 = null;
                                    if (this.lock != null) break block32;
                                    try {
                                        this.channel.close();
                                        Object var9_18 = null;
                                        this.channel = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var9_19 = null;
                                        this.channel = null;
                                        throw throwable;
                                    }
                                }
                                Object var7_13 = null;
                                if (this.lock != null) break block32;
                            }
                            catch (Throwable throwable) {
                                Object var7_15 = null;
                                if (this.lock != null) throw throwable;
                                try {}
                                catch (Throwable throwable2) {
                                    Object var9_21 = null;
                                    this.channel = null;
                                    throw throwable2;
                                }
                                this.channel.close();
                                Object var9_20 = null;
                                this.channel = null;
                                throw throwable;
                            }
                            try {}
                            catch (Throwable throwable) {
                                Object var9_17 = null;
                                this.channel = null;
                                throw throwable;
                            }
                            this.channel.close();
                            Object var9_16 = null;
                            this.channel = null;
                        }
                        Object var11_26 = null;
                        if (this.channel != null) break block31;
                    }
                    catch (Throwable throwable) {
                        Object var11_27 = null;
                        if (this.channel != null) throw throwable;
                        try {
                            this.f.close();
                            Object var13_30 = null;
                            this.f = null;
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            Object var13_31 = null;
                            this.f = null;
                            throw throwable3;
                        }
                    }
                    try {}
                    catch (Throwable throwable) {
                        Object var13_29 = null;
                        this.f = null;
                        throw throwable;
                    }
                    this.f.close();
                    Object var13_28 = null;
                    this.f = null;
                    break block31;
                }
                catch (Throwable throwable) {
                    Object var15_9 = null;
                    if (!markedHeld) throw throwable;
                    if (this.lockExists()) throw throwable;
                    HashSet<String> hashSet3 = LOCK_HELD;
                    synchronized (hashSet3) {
                        if (!LOCK_HELD.contains(canonicalPath)) throw throwable;
                        LOCK_HELD.remove(canonicalPath);
                        throw throwable;
                    }
                }
            }
            synchronized (hashSet) {
                if (!LOCK_HELD.contains(canonicalPath)) return bl;
                LOCK_HELD.remove(canonicalPath);
                return bl;
            }
        }
        Object var15_8 = null;
        if (!markedHeld) return this.lockExists();
        if (this.lockExists()) return this.lockExists();
        HashSet<String> hashSet = LOCK_HELD;
        synchronized (hashSet) {
            if (!LOCK_HELD.contains(canonicalPath)) return this.lockExists();
            LOCK_HELD.remove(canonicalPath);
            return this.lockExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws IOException {
        if (this.lockExists()) {
            HashSet<String> hashSet;
            Object v1;
            try {
                this.lock.release();
                Object var2_1 = null;
                this.lock = null;
            }
            catch (Throwable throwable) {
                HashSet<String> hashSet2;
                Object v0;
                Object var2_2 = null;
                this.lock = null;
                try {
                    this.channel.close();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var4_6 = v0;
                this.channel = null;
                try {
                    this.f.close();
                    Object var6_9 = null;
                    this.f = null;
                    hashSet2 = LOCK_HELD;
                }
                catch (Throwable throwable3) {
                    Object var6_10 = null;
                    this.f = null;
                    HashSet<String> hashSet3 = LOCK_HELD;
                    synchronized (hashSet3) {
                        LOCK_HELD.remove(this.path.getCanonicalPath());
                    }
                    throw throwable3;
                }
                synchronized (hashSet2) {
                    LOCK_HELD.remove(this.path.getCanonicalPath());
                }
                throw throwable;
            }
            try {
                this.channel.close();
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var4_5 = v1;
            this.channel = null;
            try {
                this.f.close();
                Object var6_7 = null;
                this.f = null;
                hashSet = LOCK_HELD;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.f = null;
                HashSet<String> hashSet4 = LOCK_HELD;
                synchronized (hashSet4) {
                    LOCK_HELD.remove(this.path.getCanonicalPath());
                }
                throw throwable;
            }
            synchronized (hashSet) {
                LOCK_HELD.remove(this.path.getCanonicalPath());
            }
            if (!this.path.delete()) {
                throw new LockReleaseFailedException("failed to delete " + this.path);
            }
        }
    }

    public synchronized boolean isLocked() {
        if (this.lockExists()) {
            return true;
        }
        if (!this.path.exists()) {
            return false;
        }
        try {
            boolean obtained = this.obtain();
            if (obtained) {
                this.release();
            }
            return !obtained;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }
}

