/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.lucene.CompositeLuceneProvider;
import org.eaglei.search.provider.rdf.RepositoryHarvester;
import org.spin.tools.Util;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@Deprecated
public final class Shared {
    private static final Logger log = Logger.getLogger(Shared.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final Lock lock = new ReentrantLock();
    private static volatile boolean isProviderInitialized = false;
    private static volatile SearchProvider searchProvider;
    private static volatile EIOntModel ontModel;

    private Shared() {
    }

    static boolean isProviderInitialized() {
        return isProviderInitialized;
    }

    static void setIsProviderInitialized(boolean value) {
        isProviderInitialized = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EIOntModel getOntModel() {
        lock.lock();
        try {
            if (ontModel == null) {
                ApplicationContext context = Shared.getApplicationContext();
                Util.guardNotNull((Object)context);
                ontModel = context.getBean(EIOntModel.class);
            }
            EIOntModel eIOntModel = ontModel;
            return eIOntModel;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchProvider getSearchProvider() throws IOException {
        lock.lock();
        try {
            if (searchProvider == null) {
                ApplicationContext context = Shared.getApplicationContext();
                Util.guardNotNull((Object)context);
                SearchProvider provider = context.getBean("harvester", RepositoryHarvester.class);
                Util.guardNotNull((Object)provider);
                boolean shouldUseCentralIndex = Boolean.valueOf(System.getProperty("search.central.index"));
                if (shouldUseCentralIndex) {
                    searchProvider = provider;
                } else {
                    EIOntModel eagleiOntModel = context.getBean(EIOntModel.class);
                    Util.guardNotNull((Object)eagleiOntModel);
                    searchProvider = new CompositeLuceneProvider(eagleiOntModel, provider);
                }
                isProviderInitialized = false;
            }
            SearchProvider searchProvider = Shared.searchProvider;
            return searchProvider;
        }
        finally {
            lock.unlock();
        }
    }

    private static ApplicationContext getApplicationContext() {
        return new ClassPathXmlApplicationContext("query-action-config.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSearchProvider(SearchProvider provider) {
        lock.lock();
        try {
            searchProvider = provider;
            isProviderInitialized = false;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeProviderIfNecessary() throws IOException {
        lock.lock();
        try {
            if (!isProviderInitialized) {
                if (INFO) {
                    log.info("Initializing SearchProvider");
                }
                Shared.getSearchProvider().init();
                isProviderInitialized = true;
                if (INFO) {
                    log.info("Done initializing SearchProvider");
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static final class MagicStrings {
        public static final String SparqlSearchProvider = "sparqlSearchProvider";
        public static final String Harvester = "harvester";

        private MagicStrings() {
        }
    }
}

