/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProvider;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexUpdater;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;
import org.eaglei.search.provider.lucene.LuceneSearchProviderProperties;

public final class CompositeLuceneProvider
implements SearchProvider {
    private static final Log logger = LogFactory.getLog(CompositeLuceneProvider.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final EIOntModel eagleiOntModel;
    private final SearchProvider nestedProvider;
    private LuceneSearchProvider luceneWrapper;

    public CompositeLuceneProvider(EIOntModel eagleiOntModel, SearchProvider provider) {
        this.eagleiOntModel = eagleiOntModel;
        this.nestedProvider = provider;
    }

    @Override
    public void init() throws IOException {
        if (DEBUG) {
            logger.debug("Initializing nested provider for CompositeLuceneProvider");
        }
        this.nestedProvider.init();
        if (DEBUG) {
            logger.debug("Nested provider initialized");
        }
        Directory dir = LuceneSearchProviderProperties.getDirectory();
        Analyzer analyzer = LuceneSearchProviderProperties.getAnalyzer();
        LuceneSearchProviderIndexer indexer = new LuceneSearchProviderIndexer(this.eagleiOntModel, analyzer, dir);
        indexer.commit();
        this.luceneWrapper = new LuceneSearchProvider(this.eagleiOntModel, dir, analyzer);
        LuceneSearchProviderIndexUpdater indexerUpdater = new LuceneSearchProviderIndexUpdater(this.nestedProvider, indexer);
        boolean useIndexerThread = Boolean.valueOf(System.getProperty("org.eaglei.search.provider.lucene.composite.indexer.thread", Boolean.TRUE.toString()));
        if (useIndexerThread) {
            Thread initThread = new Thread((Runnable)indexerUpdater, "CompositeLuceneProviderIndexUpater");
            initThread.setPriority(1);
            initThread.setDaemon(true);
            initThread.start();
        } else {
            indexerUpdater.updateIndex();
        }
    }

    @Override
    public SearchResultSet query(SearchRequest request) throws IOException {
        return this.luceneWrapper.query(request);
    }

    @Override
    public SearchCounts count(SearchCountRequest request) throws IOException {
        return this.luceneWrapper.count(request);
    }
}

