/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.lucene.LuceneSearchIndexSchema;

public final class LuceneHighlightGenerator {
    private static final Log logger = LogFactory.getLog(LuceneHighlightGenerator.class);
    private static final int MAX_HIGHLIGHT_MATCHES = 3;

    protected static String computeHighlight(Highlighter highlighter, Analyzer analyzer, EIOntModel ontModel, SearchRequest request, Query query2, Document document, SearchResult result) {
        SearchRequest.Term term = request.getTerm();
        SearchRequest.TypeBinding binding = request.getBinding();
        if (term != null && term.getQuery() != null || binding != null && !binding.getDataTypeProperties().isEmpty()) {
            StringBuilder highlights = new StringBuilder();
            boolean firstHighlight = true;
            int totalHighlightMatches = 0;
            for (Fieldable f : document.getFields()) {
                String propLabel;
                String highlight;
                String name = f.name();
                String strValue = f.stringValue();
                if (strValue == null || !LuceneSearchIndexSchema.isPropertyField(name) || !f.isTokenized() || (highlight = LuceneHighlightGenerator.getHighlightForField(highlighter, analyzer, name, strValue)) == null) continue;
                if (firstHighlight) {
                    highlights.append("...");
                    firstHighlight = false;
                }
                if ((propLabel = LuceneHighlightGenerator.getPropertyLabel(ontModel, result.getType().getURI().toString(), name)) != null) {
                    highlights.append(propLabel + ": ");
                }
                highlights.append(highlight);
                highlights.append("...");
                if (totalHighlightMatches++ < 3) continue;
                break;
            }
            return highlights.toString();
        }
        return null;
    }

    private static String getPropertyLabel(EIOntModel eagleiOntModel, String typeURI, String propURI) {
        if (propURI.equals(RDF.type.getURI())) {
            return "type";
        }
        for (EIProperty prop : eagleiOntModel.getProperties(EIURI.create(typeURI))) {
            if (!prop.getEntity().getURI().toString().equals(propURI)) continue;
            return prop.getEntity().getLabel();
        }
        return null;
    }

    private static String getHighlightForField(Highlighter highlighter, Analyzer analyzer, String fieldName, String fieldValue) {
        try {
            String highlight = highlighter.getBestFragment(analyzer, fieldName, fieldValue);
            if (highlight != null) {
                return highlight;
            }
        }
        catch (InvalidTokenOffsetsException itoe) {
            logger.error(itoe);
        }
        catch (IOException ioe) {
            logger.error(ioe);
        }
        return null;
    }
}

