/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.lucene;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.SearchResultSet;
import org.eaglei.search.provider.lucene.LuceneSearchProviderIndexer;

public final class LuceneSearchProviderIndexUpdater
implements Runnable {
    private static final Log logger = LogFactory.getLog(LuceneSearchProviderIndexUpdater.class);
    private static final int MAX_RESULTS_TO_INDEX_FROM_EACH_NODE = 100000;
    private final SearchProvider nestedProvider;
    private final LuceneSearchProviderIndexer indexer;
    private long updateFrequency = 10000L;

    public LuceneSearchProviderIndexUpdater(SearchProvider nestedProvider, LuceneSearchProviderIndexer indexer) {
        this.nestedProvider = nestedProvider;
        this.indexer = indexer;
        String updateFrequencyProp = System.getProperty("org.eaglei.search.provider.lucene.composite.update.freq");
        if (updateFrequencyProp != null) {
            try {
                this.setUpdateFrequency(Long.parseLong(updateFrequencyProp));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public void setUpdateFrequency(long updateFrequency) {
        if (updateFrequency < 1000L) {
            this.updateFrequency = 1000L;
        }
    }

    public long getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void updateIndex() throws IOException {
        SearchRequest request = new SearchRequest();
        request.setMaxResults(100000);
        SearchResultSet resultSet = this.nestedProvider.query(request);
        if (resultSet.getTotalCount() > 0) {
            for (SearchResult result : resultSet.getResults()) {
                this.indexer.indexSearchResult(result, true);
            }
            this.indexer.commit();
            HashSet<EIURI> docsToUpdate = new HashSet<EIURI>();
            for (SearchResult result : resultSet.getResults()) {
                EIURI uri = result.getEntity().getURI();
                if (!LuceneSearchProviderIndexer.isDeletedSearchResult(result)) {
                    docsToUpdate.add(uri);
                }
                List<EIURI> relatedDocs = this.indexer.getRelatedDocuments(uri);
                docsToUpdate.addAll(relatedDocs);
            }
            for (EIURI uri : docsToUpdate) {
                this.indexer.addIndirectProperties(uri);
            }
            this.indexer.commit();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.updateIndex();
            }
            catch (Throwable t) {
                logger.error("Failed to rebuild lucene index", t);
            }
            try {
                Thread.sleep(this.getUpdateFrequency());
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

