/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.eaglei.services.NodeConfig;

public final class RepositoryHttpConfig {
    public static final String EAGLEI_REPOSITORY_USERNAME_PROPERTY = "org.eaglei.repository.username";
    public static final String EAGLEI_REPOSITORY_PASSWORD_PROPERTY = "org.eaglei.repository.password";
    public static final String PUBLISHED_NG = "http://eagle-i.org/ont/repo/1.0/NG_Published";
    public static final String DEFAULT_NG = "http://eagle-i.org/ont/repo/1.0/NG_DefaultWorkspace";
    public static final String PUBLISHED_VIEW = "published-resources";
    private String hostURL;
    private String whoamiUrl;
    private String logoutUrl;
    private String sparqlUrl;
    private String harvestUrl;
    private String instanceUrl;
    private String searchUsername;
    private String searchPassword;
    private HttpClient searchHttpClient;

    public RepositoryHttpConfig(NodeConfig nodeConfig, String tier) {
        this(RepositoryHttpConfig.computeHostURL(tier, nodeConfig.getRepositoryHostUrl()));
        this.setSearchUsername(nodeConfig.getSearchUsername());
        this.setSearchPassword(nodeConfig.getSearchPassword());
    }

    public RepositoryHttpConfig(String hostURL) {
        assert (hostURL != null);
        this.hostURL = hostURL;
        String baseUrl = hostURL + "repository/";
        this.whoamiUrl = baseUrl + "whoami";
        this.logoutUrl = baseUrl + "logout/";
        this.sparqlUrl = baseUrl + "sparql";
        this.harvestUrl = baseUrl + "harvest";
        this.instanceUrl = hostURL + "i";
    }

    public String getHostURL() {
        return this.hostURL;
    }

    public static HttpClient createHttpClient(String username, String password) {
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager(new MultiThreadedHttpConnectionManager());
        client.getState().setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
        client.getParams().setParameter("accept", "application/sparql-results+xml");
        client.getParams().setAuthenticationPreemptive(true);
        return client;
    }

    public static String computeHostURL(String tier, String repositoryHostUrl) {
        if (repositoryHostUrl == null) {
            return "localhost/";
        }
        StringBuilder buf = new StringBuilder();
        String domainOnly = repositoryHostUrl.startsWith("https://") ? repositoryHostUrl.substring(repositoryHostUrl.indexOf("https://".length())) : (repositoryHostUrl.startsWith("http://") ? repositoryHostUrl.substring(repositoryHostUrl.indexOf("http://".length())) : repositoryHostUrl);
        buf.append("https://");
        if (tier != null) {
            buf.append(tier.toLowerCase());
            buf.append('.');
        }
        buf.append(domainOnly);
        return buf.toString();
    }

    public String getWhoamiUrl() {
        return this.whoamiUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getHarvestUrl() {
        return this.harvestUrl;
    }

    public String getSparqlUrl() {
        return this.sparqlUrl;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getSearchUsername() {
        return this.searchUsername;
    }

    public void setSearchUsername(String searchUsername) {
        this.searchUsername = searchUsername;
    }

    public String getSearchPassword() {
        return this.searchPassword;
    }

    public void setSearchPassword(String searchPassword) {
        this.searchPassword = searchPassword;
    }

    public HttpClient getSearchHttpClient() {
        if (this.searchHttpClient == null) {
            this.searchHttpClient = RepositoryHttpConfig.createHttpClient(this.getSearchUsername(), this.getSearchPassword());
        }
        return this.searchHttpClient;
    }
}

