/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.mindswap.pellet.utils.NumberUtils;

public class XSDYearMonth
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace YEAR_MONTH_VALUE_SPACE;
    public static XSDYearMonth instance;

    protected XSDYearMonth(ATermAppl name) {
        super(name, YEAR_MONTH_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDYearMonth type = new XSDYearMonth(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"gYearMonth");
            min = (IDateTimeValueType)dt.createValue("0001-01", null);
            max = (IDateTimeValueType)dt.createValue("9999-12", null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        YEAR_MONTH_VALUE_SPACE = new YearMonthValueSpace();
        instance = new XSDYearMonth(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#gYearMonth"));
    }

    private static class YearMonthValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public YearMonthValueSpace() {
            super(min, max, dt);
        }

        public int count(Object start, Object end) {
            BigDateTimeValueType calendarStart = ((IDateTimeValueType)start).getBigValue();
            BigDateTimeValueType calendarEnd = ((IDateTimeValueType)end).getBigValue();
            int numYears = calendarEnd.getYear().intValue() - calendarStart.getYear().intValue() + 1;
            int numMonths = calendarEnd.getMonth() - calendarStart.getMonth() + 1;
            return 12 * numYears + numMonths;
        }

        public Object succ(Object value, int n) {
            BigInteger bigN = new BigInteger(String.valueOf(n));
            BigTimeDurationValueType nMonths = new BigTimeDurationValueType(NumberUtils.INTEGER_ZERO, bigN, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.INTEGER_ZERO, NumberUtils.DECIMAL_ZERO);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nMonths);
            return s;
        }
    }
}

