/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.dig;

import java.net.BindException;
import java.util.logging.Logger;
import org.mindswap.pellet.dig.PelletDIGReasoner;
import org.mindswap.pellet.utils.VersionInfo;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.util.MultiException;

public class PelletDIGServer
extends AbstractHttpHandler
implements HttpHandler {
    private static final long serialVersionUID = 5605350732186236386L;
    protected static Logger log = Logger.getLogger(PelletDIGServer.class.getName());
    private PelletDIGReasoner reasoner;
    private int port;
    public static int DEFAULT_PORT = 8081;

    public PelletDIGServer(int port) {
        this.port = port;
    }

    public PelletDIGServer() {
        this(DEFAULT_PORT);
        this.reasoner = new PelletDIGReasoner();
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) {
        try {
            response.setContentType("text/html");
            this.reasoner.process(request.getInputStream(), response.getOutputStream());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void run() {
        try {
            HttpServer server = new HttpServer();
            SocketListener listener = new SocketListener();
            listener.setPort(this.port);
            listener.setMinThreads(2);
            listener.setMaxThreads(10);
            server.addListener((HttpListener)listener);
            HttpContext context = server.addContext("/");
            context.addHandler((HttpHandler)new PelletDIGServer());
            server.start();
            VersionInfo vinfo = VersionInfo.getInstance();
            System.out.println();
            System.out.print("PelletDIGServer ");
            System.out.print("Version " + vinfo.getVersionString());
            System.out.print(" (" + vinfo.getReleaseDate() + ")");
            System.out.println();
            System.out.println("Port: " + this.port);
            log.fine("Debug is enabled");
        }
        catch (Exception e2) {
            if (e2 instanceof MultiException && ((MultiException)e2).getException(0) instanceof BindException) {
                BindException e1 = (BindException)((MultiException)e2).getException(0);
                System.err.println("Cannot start server. Unable to bind to port " + this.port + " : " + e1.getMessage());
            } else {
                e2.printStackTrace();
            }
            System.exit(0);
        }
    }
}

