/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.intset;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.intset.IntIterator;
import org.mindswap.pellet.utils.intset.IntSet;

public class BitIntSet
implements IntSet {
    private BitSet bits;

    public BitIntSet() {
        this.bits = new BitSet();
    }

    public BitIntSet(BitIntSet other) {
        this.bits = (BitSet)other.bits.clone();
    }

    public void add(int value) {
        if (value < 0) {
            throw new UnsupportedOperationException("Negatibe integers cannot be added to this set");
        }
        this.bits.set(value);
    }

    public void addAll(IntSet values) {
        if (values instanceof BitIntSet) {
            this.bits.or(((BitIntSet)values).bits);
        } else {
            IntIterator i = values.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    public boolean contains(int value) {
        return this.bits.get(value);
    }

    public IntSet copy() {
        return new BitIntSet(this);
    }

    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int next;
            {
                this.next = BitIntSet.this.bits.nextSetBit(0);
            }

            public boolean hasNext() {
                return this.next != -1;
            }

            public int next() {
                int curr = this.next;
                if (curr == -1) {
                    throw new NoSuchElementException();
                }
                this.next = BitIntSet.this.bits.nextSetBit(0);
                return curr;
            }
        };
    }

    public int max() {
        return this.bits.length() - 1;
    }

    public int min() {
        return this.bits.nextSetBit(0);
    }

    public void remove(int value) {
        if (value >= 0) {
            this.bits.clear(value);
        }
    }

    public int size() {
        return this.bits.cardinality();
    }

    public IntSet union(IntSet values) {
        IntSet newSet = this.copy();
        newSet.addAll(values);
        return newSet;
    }
}

