/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.beans.PropertyDescriptor;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.DynamicMBean;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JmxUtils {
    public static final String IDENTITY_OBJECT_NAME_KEY = "identity";
    private static final String MBEAN_SUFFIX = "MBean";
    private static final String MXBEAN_SUFFIX = "MXBean";
    private static final String MXBEAN_ANNOTATION_CLASS_NAME = "javax.management.MXBean";
    private static final boolean mxBeanAnnotationAvailable = ClassUtils.isPresent("javax.management.MXBean", JmxUtils.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(JmxUtils.class);

    public static MBeanServer locateMBeanServer() throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(null);
    }

    public static MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        ArrayList<MBeanServer> servers;
        MBeanServer server = null;
        if (!"".equals(agentId) && (servers = MBeanServerFactory.findMBeanServer(agentId)) != null && servers.size() > 0) {
            if (servers.size() > 1 && logger.isWarnEnabled()) {
                logger.warn("Found more than one MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : "") + ". Returning first from list.");
            }
            server = (MBeanServer)servers.get(0);
        }
        if (server == null && !StringUtils.hasLength(agentId)) {
            try {
                server = ManagementFactory.getPlatformMBeanServer();
            }
            catch (SecurityException ex) {
                throw new MBeanServerNotFoundException("No specific MBeanServer found, and not allowed to obtain the Java platform MBeanServer", ex);
            }
        }
        if (server == null) {
            throw new MBeanServerNotFoundException("Unable to locate an MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found MBeanServer: " + server);
        }
        return server;
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo) throws ClassNotFoundException {
        return JmxUtils.parameterInfoToTypes(paramInfo, ClassUtils.getDefaultClassLoader());
    }

    public static Class[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] types = null;
        if (paramInfo != null && paramInfo.length > 0) {
            types = new Class[paramInfo.length];
            int x = 0;
            while (x < paramInfo.length) {
                types[x] = ClassUtils.forName(paramInfo[x].getType(), classLoader);
                ++x;
            }
        }
        return types;
    }

    public static String[] getMethodSignature(Method method) {
        Class<?>[] types = method.getParameterTypes();
        String[] signature = new String[types.length];
        int x = 0;
        while (x < types.length) {
            signature[x] = types[x].getName();
            ++x;
        }
        return signature;
    }

    public static String getAttributeName(PropertyDescriptor property, boolean useStrictCasing) {
        if (useStrictCasing) {
            return StringUtils.capitalize(property.getName());
        }
        return property.getName();
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put(IDENTITY_OBJECT_NAME_KEY, ObjectUtils.getIdentityHexString(managedResource));
        return ObjectNameManager.getInstance(objectName.getDomain(), keyProperties);
    }

    public static Class getClassToExpose(Object managedBean) {
        return ClassUtils.getUserClass(managedBean);
    }

    public static Class getClassToExpose(Class beanClass) {
        return ClassUtils.getUserClass(beanClass);
    }

    public static boolean isMBean(Class beanClass) {
        return beanClass != null && (DynamicMBean.class.isAssignableFrom(beanClass) || JmxUtils.getMBeanInterface(beanClass) != null || JmxUtils.getMXBeanInterface(beanClass) != null);
    }

    public static Class getMBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        String mbeanInterfaceName = String.valueOf(clazz.getName()) + MBEAN_SUFFIX;
        Class<?>[] classArray = implementedInterfaces = clazz.getInterfaces();
        int n = implementedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.getName().equals(mbeanInterfaceName)) {
                return iface;
            }
            ++n2;
        }
        return JmxUtils.getMBeanInterface(clazz.getSuperclass());
    }

    public static Class getMXBeanInterface(Class clazz) {
        Class<?>[] implementedInterfaces;
        if (clazz.getSuperclass() == null) {
            return null;
        }
        Class<?>[] classArray = implementedInterfaces = clazz.getInterfaces();
        int n = implementedInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean checkResult;
            Class<?> iface = classArray[n2];
            boolean isMxBean = iface.getName().endsWith(MXBEAN_SUFFIX);
            if (mxBeanAnnotationAvailable && (checkResult = MXBeanChecker.evaluateMXBeanAnnotation(iface)) != null) {
                isMxBean = checkResult;
            }
            if (isMxBean) {
                return iface;
            }
            ++n2;
        }
        return JmxUtils.getMXBeanInterface(clazz.getSuperclass());
    }

    public static boolean isMXBeanSupportAvailable() {
        return mxBeanAnnotationAvailable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MXBeanChecker {
        private MXBeanChecker() {
        }

        public static Boolean evaluateMXBeanAnnotation(Class<?> iface) {
            MXBean mxBean = iface.getAnnotation(MXBean.class);
            return mxBean != null ? Boolean.valueOf(mxBean.value()) : null;
        }
    }
}

