/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import junit.framework.Assert;
import org.eaglei.model.EIEntity;
import org.eaglei.network.actions.ResultCheckingStrategy;
import org.eaglei.search.common.Serializer;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.node.actions.QueryAction;
import org.spin.tools.Util;

public final class QueryTestUtils {
    private QueryTestUtils() {
    }

    public static void doPerformTest(QueryAction<SearchRequest> action, SearchRequest request) throws Exception {
        QueryTestUtils.doPerformTest(action, request, Serializer.SearchResultSetSerializer, ResultCheckingStrategy.RequireAtLeastOneResult);
    }

    public static void doPerformTest(QueryAction<SearchCountRequest> action, SearchCountRequest request) throws Exception {
        QueryTestUtils.doPerformTest(action, request, Serializer.SearchCountsSerializer, new ResultCheckingStrategy<SearchCounts>(){

            @Override
            public void checkResults(SearchCounts results) {
                Assert.assertNotNull((Object)results);
            }
        });
    }

    public static <C, R> void doPerformTest(QueryAction<C> action, C request, Serializer<R> resultSerializer, ResultCheckingStrategy<R> resultCheckingStrategy) throws Exception {
        Util.guardNotNull(action);
        Util.guardNotNull(request);
        Util.guardNotNull(resultCheckingStrategy);
        String result = action.perform(null, request);
        Assert.assertNotNull((String)"Should have non-null result", (Object)result);
        Assert.assertTrue((String)"Result shouldn't be zero-length", (result.length() > 0 ? 1 : 0) != 0);
        Object unmarshalled = resultSerializer.deserialize(result);
        resultCheckingStrategy.checkResults(unmarshalled);
    }

    public static void doSearchResultsTest(SearchResultSet searchResultSet) {
        QueryTestUtils.doSearchResultsTest(searchResultSet, ResultCheckingStrategy.RequireAtLeastOneResult);
    }

    public static void doSearchResultsTest(SearchResultSet searchResultSet, ResultCheckingStrategy<SearchResultSet> resultCheckingStrategy) {
        Util.guardNotNull(resultCheckingStrategy);
        Assert.assertNotNull((Object)searchResultSet);
        resultCheckingStrategy.checkResults(searchResultSet);
    }

    public static SearchRequest searchRequestForUniversity(EIEntity university) {
        SearchRequest request = new SearchRequest();
        request.setInstitution(university.getURI());
        return request;
    }
}

