/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.pellint.lintpattern.ontology.ClassCollector;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

class ExistentialClassCollector
extends ClassCollector {
    ExistentialClassCollector() {
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.visitObject((OWLClassExpression)desc.getFiller());
    }

    public void visit(OWLObjectMinCardinality desc) {
        if (desc.getCardinality() > 0) {
            this.visitObject((OWLClassExpression)desc.getFiller());
        }
    }

    public void visit(OWLObjectExactCardinality desc) {
        if (desc.getCardinality() > 0) {
            this.visitObject((OWLClassExpression)desc.getFiller());
        }
    }

    public void visit(OWLObjectIntersectionOf desc) {
        for (OWLClassExpression op : desc.getOperands()) {
            op.accept((OWLClassExpressionVisitor)this);
        }
    }

    public void visit(OWLObjectUnionOf desc) {
        for (OWLClassExpression op : desc.getOperands()) {
            op.accept((OWLClassExpressionVisitor)this);
        }
    }

    private void visitObject(OWLClassExpression filler) {
        if (!filler.isAnonymous()) {
            this.m_Classes.add(filler.asOWLClass());
        }
    }
}

